/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRpcAcceptedReply {
    @Test
    public void testAcceptState() {
        Assertions.assertEquals((Object)RpcAcceptedReply.AcceptState.SUCCESS, (Object)RpcAcceptedReply.AcceptState.fromValue((int)0));
        Assertions.assertEquals((Object)RpcAcceptedReply.AcceptState.PROG_UNAVAIL, (Object)RpcAcceptedReply.AcceptState.fromValue((int)1));
        Assertions.assertEquals((Object)RpcAcceptedReply.AcceptState.PROG_MISMATCH, (Object)RpcAcceptedReply.AcceptState.fromValue((int)2));
        Assertions.assertEquals((Object)RpcAcceptedReply.AcceptState.PROC_UNAVAIL, (Object)RpcAcceptedReply.AcceptState.fromValue((int)3));
        Assertions.assertEquals((Object)RpcAcceptedReply.AcceptState.GARBAGE_ARGS, (Object)RpcAcceptedReply.AcceptState.fromValue((int)4));
        Assertions.assertEquals((Object)RpcAcceptedReply.AcceptState.SYSTEM_ERR, (Object)RpcAcceptedReply.AcceptState.fromValue((int)5));
    }

    @Test
    public void testAcceptStateFromInvalidValue() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> RpcAcceptedReply.AcceptState.fromValue((int)6));
    }

    @Test
    public void testConstructor() {
        VerifierNone verifier = new VerifierNone();
        RpcAcceptedReply reply = new RpcAcceptedReply(0, RpcReply.ReplyState.MSG_ACCEPTED, (Verifier)verifier, RpcAcceptedReply.AcceptState.SUCCESS);
        Assertions.assertEquals((int)0, (int)reply.getXid());
        Assertions.assertEquals((Object)RpcMessage.Type.RPC_REPLY, (Object)reply.getMessageType());
        Assertions.assertEquals((Object)RpcReply.ReplyState.MSG_ACCEPTED, (Object)reply.getState());
        Assertions.assertEquals((Object)verifier, (Object)reply.getVerifier());
        Assertions.assertEquals((Object)RpcAcceptedReply.AcceptState.SUCCESS, (Object)reply.getAcceptState());
    }
}

