/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestScriptBasedMapping {
    @Test
    public void testNoArgsMeansNoResult() {
        Configuration conf = new Configuration();
        conf.setInt("net.topology.script.number.args", 0);
        conf.set("net.topology.script.file.name", "any-filename");
        conf.set("net.topology.script.file.name", "any-filename");
        ScriptBasedMapping mapping = this.createMapping(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("some.machine.name");
        names.add("other.machine.name");
        List result = mapping.resolve(names);
        Assertions.assertNull((Object)result, (String)"Expected an empty list");
    }

    @Test
    public void testNoFilenameMeansSingleSwitch() throws Throwable {
        Configuration conf = new Configuration();
        ScriptBasedMapping mapping = this.createMapping(conf);
        Assertions.assertTrue((boolean)mapping.isSingleSwitch(), (String)"Expected to be single switch");
        Assertions.assertTrue((boolean)AbstractDNSToSwitchMapping.isMappingSingleSwitch((DNSToSwitchMapping)mapping), (String)"Expected to be single switch");
    }

    @Test
    public void testFilenameMeansMultiSwitch() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("net.topology.script.file.name", "any-filename");
        ScriptBasedMapping mapping = this.createMapping(conf);
        Assertions.assertFalse((boolean)mapping.isSingleSwitch(), (String)"Expected to be multi switch");
        mapping.setConf(new Configuration());
        Assertions.assertTrue((boolean)mapping.isSingleSwitch(), (String)"Expected to be single switch");
    }

    @Test
    public void testNullConfig() throws Throwable {
        ScriptBasedMapping mapping = this.createMapping(null);
        Assertions.assertTrue((boolean)mapping.isSingleSwitch(), (String)"Expected to be single switch");
    }

    private ScriptBasedMapping createMapping(Configuration conf) {
        ScriptBasedMapping mapping = new ScriptBasedMapping();
        mapping.setConf(conf);
        return mapping;
    }
}

