/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.hadoop.net.DNSDomainNameResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestDNSDomainNameResolver {
    static DNSDomainNameResolver DNR = new DNSDomainNameResolver();

    @Test
    public void testGetHostNameByIP() throws UnknownHostException {
        InetAddress localhost = InetAddress.getLocalHost();
        Assumptions.assumeFalse((boolean)Objects.equals(localhost.getCanonicalHostName(), localhost.getHostAddress()), (String)"IP lookup support required");
        InetAddress unresolved = InetAddress.getByAddress(localhost.getHostAddress(), localhost.getAddress());
        Assertions.assertEquals((Object)localhost.getHostAddress(), (Object)unresolved.getHostName());
        String canonicalHostName = DNR.getHostnameByIP(unresolved);
        Assertions.assertNotEquals((Object)localhost.getHostAddress(), (Object)canonicalHostName);
        Assertions.assertEquals((Object)localhost.getCanonicalHostName(), (Object)canonicalHostName);
    }
}

