/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.ganglia;

import java.net.DatagramSocket;
import java.net.MulticastSocket;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaSink30;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGangliaSink {
    @Test
    public void testShouldCreateDatagramSocketByDefault() throws Exception {
        SubsetConfiguration conf = new ConfigBuilder().subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        DatagramSocket socket = gangliaSink.getDatagramSocket();
        Assertions.assertFalse((socket == null || socket instanceof MulticastSocket ? 1 : 0) != 0, (String)"Did not create DatagramSocket");
    }

    @Test
    public void testShouldCreateDatagramSocketIfMulticastIsDisabled() throws Exception {
        SubsetConfiguration conf = new ConfigBuilder().add("test.sink.ganglia.multicast", false).subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        DatagramSocket socket = gangliaSink.getDatagramSocket();
        Assertions.assertFalse((socket == null || socket instanceof MulticastSocket ? 1 : 0) != 0, (String)"Did not create DatagramSocket");
    }

    @Test
    public void testShouldCreateMulticastSocket() throws Exception {
        SubsetConfiguration conf = new ConfigBuilder().add("test.sink.ganglia.multicast", true).subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        DatagramSocket socket = gangliaSink.getDatagramSocket();
        Assertions.assertTrue((socket != null && socket instanceof MulticastSocket ? 1 : 0) != 0, (String)"Did not create MulticastSocket");
        int ttl = ((MulticastSocket)socket).getTimeToLive();
        Assertions.assertEquals((int)1, (int)ttl, (String)"Did not set default TTL");
    }

    @Test
    public void testShouldSetMulticastSocketTtl() throws Exception {
        SubsetConfiguration conf = new ConfigBuilder().add("test.sink.ganglia.multicast", true).add("test.sink.ganglia.multicast.ttl", 3).subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        DatagramSocket socket = gangliaSink.getDatagramSocket();
        Assertions.assertTrue((socket != null && socket instanceof MulticastSocket ? 1 : 0) != 0, (String)"Did not create MulticastSocket");
        int ttl = ((MulticastSocket)socket).getTimeToLive();
        Assertions.assertEquals((int)3, (int)ttl, (String)"Did not set TTL");
    }

    @Test
    public void testMultipleMetricsServers() {
        SubsetConfiguration conf = new ConfigBuilder().add("test.sink.ganglia.servers", "server1,server2").subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        Assertions.assertEquals((int)2, (int)gangliaSink.getMetricsServers().size());
    }
}

