/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.sink.PrometheusMetricsSink;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPrometheusMetricsSink {
    @Test
    public void testPublish() throws IOException {
        MetricsSystem metrics = DefaultMetricsSystem.instance();
        metrics.init("test");
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        metrics.register("Prometheus", "Prometheus", (MetricsSink)sink);
        TestMetrics testMetrics = (TestMetrics)metrics.register("TestMetrics", "Testing metrics", (Object)new TestMetrics());
        testMetrics.numBucketCreateFails.incr();
        metrics.publishMetricsNow();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        sink.writeMetrics((Writer)writer);
        writer.flush();
        String writtenMetrics = stream.toString(StandardCharsets.UTF_8.name());
        System.out.println(writtenMetrics);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writtenMetrics.contains("test_metrics_num_bucket_create_fails{context=\"dfs\""), (String)"The expected metric line is missing from prometheus metrics output");
        metrics.unregisterSource("TestMetrics");
        metrics.stop();
        metrics.shutdown();
    }

    @Test
    public void testPublishMultiple() throws IOException {
        MetricsSystem metrics = DefaultMetricsSystem.instance();
        metrics.init("test");
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        metrics.register("Prometheus", "Prometheus", (MetricsSink)sink);
        TestMetrics testMetrics1 = (TestMetrics)metrics.register("TestMetrics1", "Testing metrics", (Object)new TestMetrics("1"));
        TestMetrics testMetrics2 = (TestMetrics)metrics.register("TestMetrics2", "Testing metrics", (Object)new TestMetrics("2"));
        testMetrics1.numBucketCreateFails.incr();
        testMetrics2.numBucketCreateFails.incr();
        metrics.publishMetricsNow();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        sink.writeMetrics((Writer)writer);
        writer.flush();
        String writtenMetrics = stream.toString(StandardCharsets.UTF_8.name());
        System.out.println(writtenMetrics);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writtenMetrics.contains("test_metrics_num_bucket_create_fails{context=\"dfs\",testtag=\"testTagValue1\""), (String)"The expected first metric line is missing from prometheus metrics output");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writtenMetrics.contains("test_metrics_num_bucket_create_fails{context=\"dfs\",testtag=\"testTagValue2\""), (String)"The expected second metric line is missing from prometheus metrics output");
        metrics.unregisterSource("TestMetrics1");
        metrics.unregisterSource("TestMetrics2");
        metrics.stop();
        metrics.shutdown();
    }

    @Test
    public void testPublishFlush() throws IOException {
        MetricsSystem metrics = DefaultMetricsSystem.instance();
        metrics.init("test");
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        metrics.register("Prometheus", "Prometheus", (MetricsSink)sink);
        TestMetrics testMetrics = (TestMetrics)metrics.register("TestMetrics", "Testing metrics", (Object)new TestMetrics("1"));
        testMetrics.numBucketCreateFails.incr();
        metrics.publishMetricsNow();
        metrics.unregisterSource("TestMetrics");
        testMetrics = (TestMetrics)metrics.register("TestMetrics", "Testing metrics", (Object)new TestMetrics("2"));
        testMetrics.numBucketCreateFails.incr();
        metrics.publishMetricsNow();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        sink.writeMetrics((Writer)writer);
        writer.flush();
        String writtenMetrics = stream.toString(StandardCharsets.UTF_8.name());
        System.out.println(writtenMetrics);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)writtenMetrics.contains("test_metrics_num_bucket_create_fails{context=\"dfs\",testtag=\"testTagValue1\""), (String)"The first metric should not exist after flushing");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writtenMetrics.contains("test_metrics_num_bucket_create_fails{context=\"dfs\",testtag=\"testTagValue2\""), (String)"The expected metric line is missing from prometheus metrics output");
        metrics.unregisterSource("TestMetrics");
        metrics.stop();
        metrics.shutdown();
    }

    @Test
    public void testNamingCamelCase() {
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"rpc_time_some_metrics", (Object)sink.prometheusName("RpcTime", "SomeMetrics"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"om_rpc_time_om_info_keys", (Object)sink.prometheusName("OMRpcTime", "OMInfoKeys"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"rpc_time_small", (Object)sink.prometheusName("RpcTime", "small"));
    }

    @Test
    public void testNamingPipeline() {
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        String recordName = "SCMPipelineMetrics";
        String metricName = "NumBlocksAllocated-RATIS-THREE-47659e3d-40c9-43b3-9792-4982fc279aba";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"scm_pipeline_metrics_num_blocks_allocated_ratis_three_47659e3d_40c9_43b3_9792_4982fc279aba", (Object)sink.prometheusName(recordName, metricName));
    }

    @Test
    public void testNamingPeriods() {
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        String recordName = "org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl";
        String metricName = "DfsUsed";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org_apache_hadoop_hdfs_server_datanode_fsdataset_impl_fs_dataset_impl_dfs_used", (Object)sink.prometheusName(recordName, metricName));
    }

    @Test
    public void testNamingWhitespaces() {
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        String recordName = "JvmMetrics";
        String metricName = "GcCountG1 Old Generation";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"jvm_metrics_gc_count_g1_old_generation", (Object)sink.prometheusName(recordName, metricName));
    }

    @Test
    public void testTopMetricsPublish() throws IOException {
        MetricsSystem metrics = DefaultMetricsSystem.instance();
        metrics.init("test");
        PrometheusMetricsSink sink = new PrometheusMetricsSink();
        metrics.register("prometheus", "prometheus", (MetricsSink)sink);
        TestTopMetrics topMetrics = new TestTopMetrics();
        topMetrics.add("60000");
        topMetrics.add("1500000");
        metrics.register("NNTopUserOpCounts", "Top N operations by user", (Object)topMetrics);
        metrics.start();
        metrics.publishMetricsNow();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        sink.writeMetrics((Writer)writer);
        writer.flush();
        String writtenMetrics = stream.toString(StandardCharsets.UTF_8.name());
        System.out.println(writtenMetrics);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)writtenMetrics).contains(new CharSequence[]{"nn_top_user_op_counts_window_ms_60000_total_count{context=\"dfs\""})).contains(new CharSequence[]{"nn_top_user_op_counts_window_ms_60000_count{"})).contains(new CharSequence[]{"nn_top_user_op_counts_window_ms_1500000_count{"})).contains(new CharSequence[]{"op=\"rename\",user=\"hadoop/TEST_HOSTNAME.com@HOSTNAME.COM\""});
        metrics.stop();
        metrics.shutdown();
    }

    private class TestTopMetrics
    implements MetricsSource {
        public static final String TOPMETRICS_METRICS_SOURCE_NAME = "NNTopUserOpCounts";
        private final List<String> windowMsNames = new ArrayList<String>();

        private TestTopMetrics() {
        }

        public void add(String windowMs) {
            this.windowMsNames.add(String.format(".windowMs=%s", windowMs));
        }

        public void getMetrics(MetricsCollector collector, boolean all) {
            for (String windowMs : this.windowMsNames) {
                MetricsRecordBuilder rb = collector.addRecord(TOPMETRICS_METRICS_SOURCE_NAME + windowMs).setContext("dfs");
                rb.addCounter(Interns.info((String)("op=" + StringUtils.deleteWhitespace((String)"rename") + ".TotalCount"), (String)"Total operation count"), 2);
                rb.addCounter(Interns.info((String)("op=" + StringUtils.deleteWhitespace((String)"rename") + ".user=hadoop/TEST_HOSTNAME.com@HOSTNAME.COM.count"), (String)"Total operations performed by user"), 3);
                rb.addCounter(Interns.info((String)("op=" + StringUtils.deleteWhitespace((String)"delete") + ".user=test_user2.count"), (String)"Total operations performed by user"), 4);
            }
        }
    }

    @Metrics(about="Test Metrics", context="dfs")
    private static class TestMetrics {
        private String id;
        @Metric
        private MutableCounterLong numBucketCreateFails;

        TestMetrics() {
            this("1");
        }

        TestMetrics(String id) {
            this.id = id;
        }

        @Metric(value={"testTag", ""}, type=Metric.Type.TAG)
        String testTag1() {
            return "testTagValue" + this.id;
        }
    }
}

