/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeFloat;
import org.apache.hadoop.metrics2.lib.MutableInverseQuantiles;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRates;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.metrics2.util.Quantile;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.thirdparty.com.google.common.math.Stats;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMutableMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(TestMutableMetrics.class);
    private static final double EPSILON = 1.0E-42;
    private static final int SLEEP_TIME_MS = 6000;
    private static final int SAMPLE_COUNT = 1000;

    @Test
    public void testSnapshot() {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        registry.newCounter("c1", "int counter", 1);
        registry.newCounter("c2", "long counter", 2L);
        registry.newGauge("g1", "int gauge", 3);
        registry.newGauge("g2", "long gauge", 4L);
        registry.newGauge("g3", "float gauge", 5.0f);
        registry.newStat("s1", "stat", "Ops", "Time", true).add(0L);
        registry.newRate("s2", "stat", false).add(0L);
        registry.snapshot(mb, true);
        MutableStat s2 = (MutableStat)registry.get("s2");
        s2.snapshot(mb, true);
        s2.add(1L);
        s2.snapshot(mb, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"c1", (String)"int counter"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"c2", (String)"long counter"), 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"g1", (String)"int gauge"), 3);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"g2", (String)"long gauge"), 4L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"g3", (String)"float gauge"), 5.0f);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"S1NumOps", (String)"Number of ops for stat"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S1AvgTime", (String)"Average time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S1StdevTime", (String)"Standard deviation of time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S1IMinTime", (String)"Interval min time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S1IMaxTime", (String)"Interval max time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S1MinTime", (String)"Min time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S1MaxTime", (String)"Max time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S1INumOps", (String)"Interval number of ops for stat")), ArgumentMatchers.eq((long)1L));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addCounter(Interns.info((String)"S2NumOps", (String)"Number of ops for stat"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S2AvgTime", (String)"Average time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"S2NumOps", (String)"Number of ops for stat"), 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S2AvgTime", (String)"Average time for stat")), AdditionalMatchers.eq((double)1.0, (double)1.0E-42));
        MutableStat s1 = (MutableStat)registry.get("s1");
        s1.add(0L);
        registry.snapshot(mb, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"S1NumOps", (String)"Number of ops for stat"), 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)"S1INumOps", (String)"Interval number of ops for stat")), ArgumentMatchers.eq((long)1L));
    }

    @Test
    public void testMutableRates() {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableRates rates = new MutableRates(registry);
        rates.init(TestProtocol.class);
        registry.snapshot(rb, false);
        MetricsAsserts.assertCounter("FooNumOps", 0L, rb);
        MetricsAsserts.assertGauge("FooAvgTime", 0.0, rb);
        MetricsAsserts.assertCounter("BarNumOps", 0L, rb);
        MetricsAsserts.assertGauge("BarAvgTime", 0.0, rb);
    }

    @Test
    public void testMutableRatesWithAggregationInit() {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        MutableRatesWithAggregation rates = new MutableRatesWithAggregation();
        rates.init(TestProtocol.class);
        rates.snapshot(rb, false);
        MetricsAsserts.assertCounter("FooNumOps", 0L, rb);
        MetricsAsserts.assertGauge("FooAvgTime", 0.0, rb);
        MetricsAsserts.assertCounter("BarNumOps", 0L, rb);
        MetricsAsserts.assertGauge("BarAvgTime", 0.0, rb);
    }

    @Test
    public void testMutableRatesWithAggregationInitWithArray() {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        MutableRatesWithAggregation rates = new MutableRatesWithAggregation();
        rates.init(new String[]{"Foo", "Bar"});
        rates.snapshot(rb, false);
        MetricsAsserts.assertCounter("FooNumOps", 0L, rb);
        MetricsAsserts.assertGauge("FooAvgTime", 0.0, rb);
        MetricsAsserts.assertCounter("BarNumOps", 0L, rb);
        MetricsAsserts.assertGauge("BarAvgTime", 0.0, rb);
    }

    @Test
    public void testMutableRatesWithAggregationSingleThread() {
        MutableRatesWithAggregation rates = new MutableRatesWithAggregation();
        rates.add("foo", 1L);
        rates.add("bar", 5L);
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        rates.snapshot(rb, false);
        MetricsAsserts.assertCounter("FooNumOps", 1L, rb);
        MetricsAsserts.assertGauge("FooAvgTime", 1.0, rb);
        MetricsAsserts.assertCounter("BarNumOps", 1L, rb);
        MetricsAsserts.assertGauge("BarAvgTime", 5.0, rb);
        rates.add("foo", 1L);
        rates.add("foo", 3L);
        rates.add("bar", 6L);
        rb = MetricsAsserts.mockMetricsRecordBuilder();
        rates.snapshot(rb, false);
        MetricsAsserts.assertCounter("FooNumOps", 3L, rb);
        MetricsAsserts.assertGauge("FooAvgTime", 2.0, rb);
        MetricsAsserts.assertCounter("BarNumOps", 2L, rb);
        MetricsAsserts.assertGauge("BarAvgTime", 6.0, rb);
    }

    @Test
    public void testMutableRatesWithAggregationManyThreads() throws InterruptedException {
        int i;
        final MutableRatesWithAggregation rates = new MutableRatesWithAggregation();
        int n = 10;
        long[] opCount = new long[10];
        double[] opTotalTime = new double[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            opCount[i2] = 0L;
            opTotalTime[i2] = 0.0;
            rates.add("metric" + i2, 0L);
        }
        Thread[] threads = new Thread[10];
        final CountDownLatch firstAddsFinished = new CountDownLatch(threads.length);
        final CountDownLatch firstSnapshotsFinished = new CountDownLatch(1);
        final CountDownLatch secondAddsFinished = new CountDownLatch(threads.length);
        final CountDownLatch secondSnapshotsFinished = new CountDownLatch(1);
        long seed = new Random().nextLong();
        LOG.info("Random seed = " + seed);
        final Random sleepRandom = new Random(seed);
        int tIdx = 0;
        while (tIdx < threads.length) {
            final int threadIdx = tIdx++;
            threads[threadIdx] = new Thread(){

                @Override
                public void run() {
                    try {
                        int i;
                        for (i = 0; i < 1000; ++i) {
                            rates.add("metric" + i % 10, i / 10 % 2 == 0 ? 1L : 2L);
                            Thread.sleep(sleepRandom.nextInt(5));
                        }
                        firstAddsFinished.countDown();
                        firstSnapshotsFinished.await();
                        if (threadIdx % 2 == 0) {
                            for (i = 0; i < 1000; ++i) {
                                rates.add("metric" + i % 10, i / 10 % 2 == 0 ? 1L : 2L);
                            }
                            secondAddsFinished.countDown();
                            secondSnapshotsFinished.await();
                        } else {
                            secondAddsFinished.countDown();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
        }
        for (Thread t : threads) {
            t.start();
        }
        for (i = 0; i < 100; ++i) {
            TestMutableMetrics.snapshotMutableRatesWithAggregation(rates, opCount, opTotalTime);
            Thread.sleep(sleepRandom.nextInt(20));
        }
        firstAddsFinished.await();
        TestMutableMetrics.snapshotMutableRatesWithAggregation(rates, opCount, opTotalTime);
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((long)1001L, (long)opCount[i], (String)("metric" + i + " count"));
            Assertions.assertEquals((double)1500.0, (double)opTotalTime[i], (double)1.0, (String)("metric" + i + " total"));
        }
        firstSnapshotsFinished.countDown();
        secondAddsFinished.await();
        TestMutableMetrics.snapshotMutableRatesWithAggregation(rates, opCount, opTotalTime);
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((long)1501L, (long)opCount[i], (String)("metric" + i + " count"));
            Assertions.assertEquals((double)2250.0, (double)opTotalTime[i], (double)1.0, (String)("metric" + i + " total"));
        }
        secondSnapshotsFinished.countDown();
    }

    private static void snapshotMutableRatesWithAggregation(MutableRatesWithAggregation rates, long[] opCount, double[] opTotalTime) {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        rates.snapshot(rb, true);
        int i = 0;
        while (i < opCount.length) {
            long newOpCount;
            long prevOpCount = opCount[i];
            opCount[i] = newOpCount = MetricsAsserts.getLongCounter("Metric" + i + "NumOps", rb);
            double avgTime = MetricsAsserts.getDoubleGauge("Metric" + i + "AvgTime", rb);
            int n = i++;
            opTotalTime[n] = opTotalTime[n] + avgTime * (double)(newOpCount - prevOpCount);
        }
    }

    @Test
    public void testMutableWithoutChanged() {
        MetricsRecordBuilder builderWithChange = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRecordBuilder builderWithoutChange = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableStat stat = registry.newStat("Test", "Test", "Ops", "Val", true);
        stat.add(1000L, 1000L);
        stat.add(1000L, 2000L);
        registry.snapshot(builderWithChange, true);
        MetricsAsserts.assertCounter("TestNumOps", 2000L, builderWithChange);
        MetricsAsserts.assertGauge("TestINumOps", 2000L, builderWithChange);
        MetricsAsserts.assertGauge("TestAvgVal", 1.5, builderWithChange);
        registry.snapshot(builderWithoutChange, true);
        MetricsAsserts.assertGauge("TestINumOps", 0L, builderWithoutChange);
        MetricsAsserts.assertGauge("TestAvgVal", 0.0, builderWithoutChange);
    }

    @Test
    public void testDuplicateMetrics() {
        MutableRatesWithAggregation rates = new MutableRatesWithAggregation();
        MutableRatesWithAggregation deferredRpcRates = new MutableRatesWithAggregation();
        Class<Long> protocol = Long.class;
        rates.init(protocol);
        deferredRpcRates.init(protocol, "Deferred");
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        rates.snapshot(rb, true);
        deferredRpcRates.snapshot(rb, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.times((int)1))).addCounter(Interns.info((String)"GetLongNumOps", (String)"Number of ops for getLong"), 0L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb, (VerificationMode)Mockito.times((int)1))).addCounter(Interns.info((String)"DeferredGetLongNumOps", (String)"Number of ops for deferredGetLong"), 0L);
        rb = MetricsAsserts.mockMetricsRecordBuilder();
        rates.add("testRpcMethod", 10L);
        deferredRpcRates.add("testRpcMethod", 100L);
        deferredRpcRates.add("testRpcMethod", 500L);
        rates.snapshot(rb, true);
        deferredRpcRates.snapshot(rb, true);
        MetricsAsserts.assertCounter("TestRpcMethodNumOps", 1L, rb);
        MetricsAsserts.assertGauge("TestRpcMethodAvgTime", 10.0, rb);
        MetricsAsserts.assertCounter("DeferredTestRpcMethodNumOps", 2L, rb);
        MetricsAsserts.assertGauge("DeferredTestRpcMethodAvgTime", 300.0, rb);
    }

    @Test
    public void testMutableStatWithBulkAdd() {
        int i;
        ArrayList<Long> samples = new ArrayList<Long>();
        for (i = 0; i < 1000; ++i) {
            samples.add(1000L);
        }
        for (i = 0; i < 1000; ++i) {
            samples.add(2000L);
        }
        Stats stats = Stats.of(samples);
        for (int bulkSize : new int[]{1, 10, 100, 1000}) {
            MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
            MetricsRegistry registry = new MetricsRegistry("test");
            MutableStat stat = registry.newStat("Test", "Test", "Ops", "Val", true);
            for (int i2 = 0; i2 < samples.size(); i2 += bulkSize) {
                stat.add((long)bulkSize, samples.subList(i2, i2 + bulkSize).stream().mapToLong(Long::longValue).sum());
            }
            registry.snapshot(rb, false);
            MetricsAsserts.assertCounter("TestNumOps", 2000L, rb);
            MetricsAsserts.assertGauge("TestAvgVal", stats.mean(), rb);
            MetricsAsserts.assertGauge("TestStdevVal", stats.sampleStandardDeviation(), rb);
        }
    }

    @Test
    public void testLargeMutableStatAdd() {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableStat stat = registry.newStat("Test", "Test", "Ops", "Val", true);
        long sample = 1000000000000009L;
        for (int i = 0; i < 100; ++i) {
            stat.add(1L, sample);
        }
        registry.snapshot(rb, false);
        MetricsAsserts.assertCounter("TestNumOps", 100L, rb);
        MetricsAsserts.assertGauge("TestAvgVal", (double)sample, rb);
        MetricsAsserts.assertGauge("TestStdevVal", 0.0, rb);
    }

    @Test
    @Timeout(value=30L)
    public void testMutableQuantilesError() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles quantiles = registry.newQuantiles("foo", "stat", "Ops", "Latency", 5);
        long startTimeMS = System.currentTimeMillis();
        for (long i = 1L; i <= 1000L; ++i) {
            quantiles.add(i);
            quantiles.add(1001L - i);
        }
        long endTimeMS = System.currentTimeMillis();
        Thread.sleep(6000L - (endTimeMS - startTimeMS));
        registry.snapshot(mb, false);
        Map previousSnapshot = quantiles.previousSnapshot;
        for (Map.Entry item : previousSnapshot.entrySet()) {
            System.out.println(String.format("Quantile %.2f has value %d", ((Quantile)item.getKey()).quantile, item.getValue()));
        }
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 2000L);
        Quantile[] quants = MutableQuantiles.QUANTILES;
        String name = "Foo%dthPercentileLatency";
        String desc = "%d percentile latency with 5 second interval for stat";
        for (Quantile q : quants) {
            int percentile = (int)(100.0 * q.quantile);
            int error = (int)(1000.0 * q.error);
            String n = String.format(name, percentile);
            String d = String.format(desc, percentile);
            long expected = (long)(q.quantile * 1000.0);
            ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)n, (String)d)), AdditionalMatchers.leq((long)(expected + (long)error)));
            ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)n, (String)d)), AdditionalMatchers.geq((long)(expected - (long)error)));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testMutableInverseQuantilesError() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles inverseQuantiles = registry.newInverseQuantiles("foo", "stat", "Ops", "Latency", 5);
        long startTimeMS = System.currentTimeMillis();
        for (long i = 1L; i <= 1000L; ++i) {
            inverseQuantiles.add(i);
            inverseQuantiles.add(1001L - i);
        }
        long endTimeMS = System.currentTimeMillis();
        Thread.sleep(6000L - (endTimeMS - startTimeMS));
        registry.snapshot(mb, false);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 2000L);
        Quantile[] inverseQuants = MutableInverseQuantiles.INVERSE_QUANTILES;
        String name = "Foo%dthInversePercentileLatency";
        String desc = "%d inverse percentile latency with 5 second interval for stat";
        for (Quantile q : inverseQuants) {
            int inversePercentile = (int)(100.0 * (1.0 - q.quantile));
            int error = (int)(1000.0 * q.error);
            String n = String.format(name, inversePercentile);
            String d = String.format(desc, inversePercentile);
            long expected = (long)(q.quantile * 1000.0);
            ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)n, (String)d)), AdditionalMatchers.leq((long)(expected + (long)error)));
            ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)n, (String)d)), AdditionalMatchers.geq((long)(expected - (long)error)));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testMutableQuantilesRollover() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles quantiles = registry.newQuantiles("foo", "stat", "Ops", "Latency", 5);
        Quantile[] quants = MutableQuantiles.QUANTILES;
        String name = "Foo%dthPercentileLatency";
        String desc = "%d percentile latency with 5 second interval for stat";
        long startTimeMS = System.currentTimeMillis();
        for (int i = 1; i <= 3; ++i) {
            for (long j = 1L; j <= 1000L; ++j) {
                quantiles.add((long)i);
            }
            long sleepTimeMS = startTimeMS + 5000L * (long)i + 1000L - System.currentTimeMillis();
            Thread.sleep(sleepTimeMS);
            registry.snapshot(mb, false);
            for (Quantile q : quants) {
                int percentile = (int)(100.0 * q.quantile);
                String n = String.format(name, percentile);
                String d = String.format(desc, percentile);
                ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)n, (String)d), (long)i);
            }
        }
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)3))).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 1000L);
        for (Quantile q : quants) {
            int percentile = (int)(100.0 * q.quantile);
            String n = String.format(name, percentile);
            String d = String.format(desc, percentile);
            ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)3))).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)n, (String)d)), ArgumentMatchers.anyLong());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testMutableInverseQuantilesRollover() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles inverseQuantiles = registry.newInverseQuantiles("foo", "stat", "Ops", "Latency", 5);
        Quantile[] quants = MutableInverseQuantiles.INVERSE_QUANTILES;
        String name = "Foo%dthInversePercentileLatency";
        String desc = "%d inverse percentile latency with 5 second interval for stat";
        long startTimeMS = System.currentTimeMillis();
        for (int i = 1; i <= 3; ++i) {
            for (long j = 1L; j <= 1000L; ++j) {
                inverseQuantiles.add((long)i);
            }
            long sleepTimeMS = startTimeMS + 5000L * (long)i + 1000L - System.currentTimeMillis();
            Thread.sleep(sleepTimeMS);
            registry.snapshot(mb, false);
            for (Quantile q : quants) {
                int inversePercentile = (int)(100.0 * (1.0 - q.quantile));
                String n = String.format(name, inversePercentile);
                String d = String.format(desc, inversePercentile);
                ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)n, (String)d), (long)i);
            }
        }
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)3))).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 1000L);
        for (Quantile q : quants) {
            int inversePercentile = (int)(100.0 * (1.0 - q.quantile));
            String n = String.format(name, inversePercentile);
            String d = String.format(desc, inversePercentile);
            ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)3))).addGauge((MetricsInfo)ArgumentMatchers.eq((Object)Interns.info((String)n, (String)d)), ArgumentMatchers.anyLong());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testMutableQuantilesEmptyRollover() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles quantiles = registry.newQuantiles("foo", "stat", "Ops", "Latency", 5);
        quantiles.snapshot(mb, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 0L);
        Thread.sleep(6000L);
        quantiles.snapshot(mb, false);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 0L);
    }

    @Test
    @Timeout(value=30L)
    public void testMutableInverseQuantilesEmptyRollover() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles inverseQuantiles = registry.newInverseQuantiles("foo", "stat", "Ops", "Latency", 5);
        inverseQuantiles.snapshot(mb, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 0L);
        Thread.sleep(6000L);
        inverseQuantiles.snapshot(mb, false);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 0L);
    }

    @Test
    @Timeout(value=30L)
    public void testMutableGaugeFloat() {
        MutableGaugeFloat mgf = new MutableGaugeFloat((MetricsInfo)MsInfo.Context, 3.2f);
        Assertions.assertEquals((double)3.2f, (double)mgf.value(), (double)0.0);
        mgf.incr();
        Assertions.assertEquals((double)4.2f, (double)mgf.value(), (double)0.0);
        mgf.set(Float.NaN);
        Assertions.assertEquals((double)Double.NaN, (double)mgf.value(), (double)0.0);
    }

    static interface TestProtocol {
        public void foo();

        public void bar();
    }
}

