/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.List;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsVisitor;
import org.apache.hadoop.metrics2.impl.MetricsLists;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestMetricsVisitor {
    @Captor
    private ArgumentCaptor<MetricsInfo> c1;
    @Captor
    private ArgumentCaptor<MetricsInfo> c2;
    @Captor
    private ArgumentCaptor<MetricsInfo> g1;
    @Captor
    private ArgumentCaptor<MetricsInfo> g2;
    @Captor
    private ArgumentCaptor<MetricsInfo> g3;
    @Captor
    private ArgumentCaptor<MetricsInfo> g4;

    @Test
    public void testCommon() {
        MetricsVisitor visitor = (MetricsVisitor)Mockito.mock(MetricsVisitor.class);
        MetricsRegistry registry = new MetricsRegistry("test");
        List metrics = MetricsLists.builder("test").addCounter(Interns.info((String)"c1", (String)"int counter"), 1).addCounter(Interns.info((String)"c2", (String)"long counter"), 2L).addGauge(Interns.info((String)"g1", (String)"int gauge"), 5).addGauge(Interns.info((String)"g2", (String)"long gauge"), 6L).addGauge(Interns.info((String)"g3", (String)"float gauge"), 7.0f).addGauge(Interns.info((String)"g4", (String)"double gauge"), 8.0).metrics();
        for (AbstractMetric metric : metrics) {
            metric.visit(visitor);
        }
        ((MetricsVisitor)Mockito.verify((Object)visitor)).counter((MetricsInfo)this.c1.capture(), Mockito.eq((int)1));
        Assertions.assertEquals((Object)"c1", (Object)((MetricsInfo)this.c1.getValue()).name(), (String)"c1 name");
        Assertions.assertEquals((Object)"int counter", (Object)((MetricsInfo)this.c1.getValue()).description(), (String)"c1 description");
        ((MetricsVisitor)Mockito.verify((Object)visitor)).counter((MetricsInfo)this.c2.capture(), Mockito.eq((long)2L));
        Assertions.assertEquals((Object)"c2", (Object)((MetricsInfo)this.c2.getValue()).name(), (String)"c2 name");
        Assertions.assertEquals((Object)"long counter", (Object)((MetricsInfo)this.c2.getValue()).description(), (String)"c2 description");
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricsInfo)this.g1.capture(), Mockito.eq((int)5));
        Assertions.assertEquals((Object)"g1", (Object)((MetricsInfo)this.g1.getValue()).name(), (String)"g1 name");
        Assertions.assertEquals((Object)"int gauge", (Object)((MetricsInfo)this.g1.getValue()).description(), (String)"g1 description");
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricsInfo)this.g2.capture(), Mockito.eq((long)6L));
        Assertions.assertEquals((Object)"g2", (Object)((MetricsInfo)this.g2.getValue()).name(), (String)"g2 name");
        Assertions.assertEquals((Object)"long gauge", (Object)((MetricsInfo)this.g2.getValue()).description(), (String)"g2 description");
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricsInfo)this.g3.capture(), Mockito.eq((float)7.0f));
        Assertions.assertEquals((Object)"g3", (Object)((MetricsInfo)this.g3.getValue()).name(), (String)"g3 name");
        Assertions.assertEquals((Object)"float gauge", (Object)((MetricsInfo)this.g3.getValue()).description(), (String)"g3 description");
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricsInfo)this.g4.capture(), Mockito.eq((double)8.0));
        Assertions.assertEquals((Object)"g4", (Object)((MetricsInfo)this.g4.getValue()).name(), (String)"g4 name");
        Assertions.assertEquals((Object)"double gauge", (Object)((MetricsInfo)this.g4.getValue()).description(), (String)"g4 description");
    }
}

