/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.filter;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.filter.GlobFilter;
import org.apache.hadoop.metrics2.filter.RegexFilter;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestPatternFilter {
    @Test
    public void emptyConfigShouldAccept() {
        SubsetConfiguration empty = new ConfigBuilder().subset("");
        TestPatternFilter.shouldAccept(empty, "anything");
        TestPatternFilter.shouldAccept(empty, Arrays.asList(Interns.tag((String)"key", (String)"desc", (String)"value")));
        TestPatternFilter.shouldAccept(empty, TestPatternFilter.mockMetricsRecord("anything", Arrays.asList(Interns.tag((String)"key", (String)"desc", (String)"value"))));
    }

    @Test
    public void includeOnlyShouldOnlyIncludeMatched() {
        SubsetConfiguration wl = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(wl, "foo");
        TestPatternFilter.shouldAccept(wl, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""), Interns.tag((String)"foo", (String)"", (String)"f")), new boolean[]{false, true});
        TestPatternFilter.shouldAccept(wl, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""), Interns.tag((String)"foo", (String)"", (String)"f"))));
        TestPatternFilter.shouldReject(wl, "bar");
        TestPatternFilter.shouldReject(wl, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)"")));
        TestPatternFilter.shouldReject(wl, Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"boo")));
        TestPatternFilter.shouldReject(wl, TestPatternFilter.mockMetricsRecord("bar", Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f"))));
        TestPatternFilter.shouldReject(wl, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""))));
    }

    @Test
    public void excludeOnlyShouldOnlyExcludeMatched() {
        SubsetConfiguration bl = new ConfigBuilder().add("p.exclude", "foo").add("p.exclude.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(bl, "bar");
        TestPatternFilter.shouldAccept(bl, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)"")));
        TestPatternFilter.shouldAccept(bl, TestPatternFilter.mockMetricsRecord("bar", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""))));
        TestPatternFilter.shouldReject(bl, "foo");
        TestPatternFilter.shouldReject(bl, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""), Interns.tag((String)"foo", (String)"", (String)"f")), new boolean[]{true, false});
        TestPatternFilter.shouldReject(bl, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""))));
        TestPatternFilter.shouldReject(bl, TestPatternFilter.mockMetricsRecord("bar", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)""), Interns.tag((String)"foo", (String)"", (String)"f"))));
    }

    @Test
    public void shouldAcceptUnmatchedWhenBothAreConfigured() {
        SubsetConfiguration c = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").add("p.exclude", "bar").add("p.exclude.tags", "bar:b").subset("p");
        TestPatternFilter.shouldAccept(c, "foo");
        TestPatternFilter.shouldAccept(c, Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f")));
        TestPatternFilter.shouldAccept(c, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f"))));
        TestPatternFilter.shouldReject(c, "bar");
        TestPatternFilter.shouldReject(c, Arrays.asList(Interns.tag((String)"bar", (String)"", (String)"b")));
        TestPatternFilter.shouldReject(c, TestPatternFilter.mockMetricsRecord("bar", Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f"))));
        TestPatternFilter.shouldReject(c, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"bar", (String)"", (String)"b"))));
        TestPatternFilter.shouldAccept(c, "foobar");
        TestPatternFilter.shouldAccept(c, Arrays.asList(Interns.tag((String)"foobar", (String)"", (String)"")));
        TestPatternFilter.shouldAccept(c, TestPatternFilter.mockMetricsRecord("foobar", Arrays.asList(Interns.tag((String)"foobar", (String)"", (String)""))));
    }

    @Test
    public void includeShouldOverrideExclude() {
        SubsetConfiguration c = new ConfigBuilder().add("p.include", "foo").add("p.include.tags", "foo:f").add("p.exclude", "foo").add("p.exclude.tags", "foo:f").subset("p");
        TestPatternFilter.shouldAccept(c, "foo");
        TestPatternFilter.shouldAccept(c, Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f")));
        TestPatternFilter.shouldAccept(c, TestPatternFilter.mockMetricsRecord("foo", Arrays.asList(Interns.tag((String)"foo", (String)"", (String)"f"))));
    }

    static void shouldAccept(SubsetConfiguration conf, String s) {
        Assertions.assertTrue((boolean)TestPatternFilter.newGlobFilter(conf).accepts(s), (String)("accepts " + s));
        Assertions.assertTrue((boolean)TestPatternFilter.newRegexFilter(conf).accepts(s), (String)("accepts " + s));
    }

    static void shouldAccept(SubsetConfiguration conf, List<MetricsTag> tags) {
        TestPatternFilter.shouldAcceptImpl(true, conf, tags, new boolean[]{true});
    }

    static void shouldAccept(SubsetConfiguration conf, List<MetricsTag> tags, boolean[] expectedAcceptedSpec) {
        TestPatternFilter.shouldAcceptImpl(true, conf, tags, expectedAcceptedSpec);
    }

    static void shouldReject(SubsetConfiguration conf, List<MetricsTag> tags) {
        TestPatternFilter.shouldAcceptImpl(false, conf, tags, new boolean[]{false});
    }

    static void shouldReject(SubsetConfiguration conf, List<MetricsTag> tags, boolean[] expectedAcceptedSpec) {
        TestPatternFilter.shouldAcceptImpl(false, conf, tags, expectedAcceptedSpec);
    }

    private static void shouldAcceptImpl(boolean expectAcceptList, SubsetConfiguration conf, List<MetricsTag> tags, boolean[] expectedAcceptedSpec) {
        GlobFilter globFilter = TestPatternFilter.newGlobFilter(conf);
        RegexFilter regexFilter = TestPatternFilter.newRegexFilter(conf);
        Assertions.assertEquals((Object)expectAcceptList, (Object)globFilter.accepts(tags), (String)("accepts " + tags));
        Assertions.assertEquals((Object)expectAcceptList, (Object)regexFilter.accepts(tags), (String)("accepts " + tags));
        int acceptedCount = 0;
        for (int i = 0; i < tags.size(); ++i) {
            MetricsTag tag = tags.get(i);
            boolean actGlob = globFilter.accepts(tag);
            boolean actRegex = regexFilter.accepts(tag);
            Assertions.assertEquals((Object)expectedAcceptedSpec[i], (Object)actGlob, (String)("accepts " + tag));
            Assertions.assertEquals((Object)actGlob, (Object)actRegex);
            if (!actGlob) continue;
            ++acceptedCount;
        }
        if (expectAcceptList) {
            Assertions.assertTrue((acceptedCount > 0 ? 1 : 0) != 0, (String)("No tag of the following accepted: " + tags));
        } else {
            Assertions.assertTrue((acceptedCount < tags.size() ? 1 : 0) != 0, (String)("No tag of the following rejected: " + tags));
        }
    }

    static void shouldAccept(SubsetConfiguration conf, MetricsRecord record) {
        Assertions.assertTrue((boolean)TestPatternFilter.newGlobFilter(conf).accepts(record), (String)("accepts " + record));
        Assertions.assertTrue((boolean)TestPatternFilter.newRegexFilter(conf).accepts(record), (String)("accepts " + record));
    }

    static void shouldReject(SubsetConfiguration conf, String s) {
        Assertions.assertTrue((!TestPatternFilter.newGlobFilter(conf).accepts(s) ? 1 : 0) != 0, (String)("rejects " + s));
        Assertions.assertTrue((!TestPatternFilter.newRegexFilter(conf).accepts(s) ? 1 : 0) != 0, (String)("rejects " + s));
    }

    static void shouldReject(SubsetConfiguration conf, MetricsRecord record) {
        Assertions.assertTrue((!TestPatternFilter.newGlobFilter(conf).accepts(record) ? 1 : 0) != 0, (String)("rejects " + record));
        Assertions.assertTrue((!TestPatternFilter.newRegexFilter(conf).accepts(record) ? 1 : 0) != 0, (String)("rejects " + record));
    }

    public static GlobFilter newGlobFilter(SubsetConfiguration conf) {
        GlobFilter f = new GlobFilter();
        f.init(conf);
        return f;
    }

    public static RegexFilter newRegexFilter(SubsetConfiguration conf) {
        RegexFilter f = new RegexFilter();
        f.init(conf);
        return f;
    }

    private static MetricsRecord mockMetricsRecord(String name, List<MetricsTag> tags) {
        MetricsRecord record = (MetricsRecord)Mockito.mock(MetricsRecord.class);
        Mockito.when((Object)record.name()).thenReturn((Object)name);
        Mockito.when((Object)record.tags()).thenReturn(tags);
        return record;
    }
}

