/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import org.apache.hadoop.log.LogThrottlingHelper;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLogThrottlingHelper {
    private static final int LOG_PERIOD = 100;
    private LogThrottlingHelper helper;
    private FakeTimer timer;

    @BeforeEach
    public void setup() {
        this.timer = new FakeTimer();
        this.helper = new LogThrottlingHelper(100L, null, (Timer)this.timer);
    }

    @Test
    public void testBasicLogging() {
        Assertions.assertTrue((boolean)this.helper.record(new double[0]).shouldLog());
        for (int i = 0; i < 5; ++i) {
            this.timer.advance(10L);
            Assertions.assertFalse((boolean)this.helper.record(new double[0]).shouldLog());
        }
        this.timer.advance(100L);
        Assertions.assertTrue((boolean)this.helper.record(new double[0]).shouldLog());
    }

    @Test
    public void testLoggingWithValue() {
        Assertions.assertTrue((boolean)this.helper.record(new double[]{1.0}).shouldLog());
        for (int i = 0; i < 4; ++i) {
            this.timer.advance(20L);
            Assertions.assertFalse((boolean)this.helper.record(new double[]{i % 2 == 0 ? 0.0 : 1.0}).shouldLog());
        }
        this.timer.advance(100L);
        LogThrottlingHelper.LogAction action = this.helper.record(new double[]{0.5});
        Assertions.assertTrue((boolean)action.shouldLog());
        Assertions.assertEquals((int)5, (int)action.getCount());
        Assertions.assertEquals((double)0.5, (double)action.getStats(0).getMean(), (double)0.01);
        Assertions.assertEquals((double)1.0, (double)action.getStats(0).getMax(), (double)0.01);
        Assertions.assertEquals((double)0.0, (double)action.getStats(0).getMin(), (double)0.01);
    }

    @Test
    public void testLoggingWithMultipleValues() {
        Assertions.assertTrue((boolean)this.helper.record(new double[]{1.0}).shouldLog());
        for (int i = 0; i < 4; ++i) {
            this.timer.advance(20L);
            int base = i % 2 == 0 ? 0 : 1;
            Assertions.assertFalse((boolean)this.helper.record(new double[]{base, base * 2}).shouldLog());
        }
        this.timer.advance(100L);
        LogThrottlingHelper.LogAction action = this.helper.record(new double[]{0.5, 1.0});
        Assertions.assertTrue((boolean)action.shouldLog());
        Assertions.assertEquals((int)5, (int)action.getCount());
        for (int i = 1; i <= 2; ++i) {
            Assertions.assertEquals((double)(0.5 * (double)i), (double)action.getStats(i - 1).getMean(), (double)0.01);
            Assertions.assertEquals((double)(1.0 * (double)i), (double)action.getStats(i - 1).getMax(), (double)0.01);
            Assertions.assertEquals((double)0.0, (double)action.getStats(i - 1).getMin(), (double)0.01);
        }
    }

    @Test
    public void testLoggingWithInconsistentValues() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Assertions.assertTrue((boolean)this.helper.record(new double[]{1.0, 2.0}).shouldLog());
            this.helper.record(new double[]{1.0, 2.0});
            this.helper.record(new double[]{1.0, 2.0, 3.0});
        });
    }

    @Test
    public void testNamedLoggersWithoutSpecifiedPrimary() {
        Assertions.assertTrue((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("foo", 50L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("bar", 50L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("foo", 100L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 100L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("foo", 150L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("bar", 150L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("bar", 200L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("foo", 200L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 200L, new double[0]).shouldLog());
    }

    @Test
    public void testPrimaryAndDependentLoggers() {
        this.helper = new LogThrottlingHelper(100L, "foo", (Timer)this.timer);
        Assertions.assertTrue((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("foo", 50L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("bar", 50L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("foo", 100L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 100L, new double[0]).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("bar", 200L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("foo", 200L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
    }

    @Test
    public void testInfrequentPrimaryAndDependentLoggers() {
        this.helper = new LogThrottlingHelper(100L, "foo", (Timer)this.timer);
        Assertions.assertTrue((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 0L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("foo", 100L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 100L, new double[0]).shouldLog());
    }

    @Test
    public void testMultipleLoggersWithValues() {
        this.helper = new LogThrottlingHelper(100L, "foo", (Timer)this.timer);
        Assertions.assertTrue((boolean)this.helper.record("foo", 0L, new double[0]).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("bar", 0L, new double[]{2.0}).shouldLog());
        Assertions.assertTrue((boolean)this.helper.record("baz", 0L, new double[]{3.0, 3.0}).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("bar", 100L, new double[]{2.0}).shouldLog());
        Assertions.assertFalse((boolean)this.helper.record("baz", 100L, new double[]{3.0, 3.0}).shouldLog());
        LogThrottlingHelper.LogAction foo = this.helper.record("foo", 100L, new double[0]);
        LogThrottlingHelper.LogAction bar = this.helper.record("bar", 100L, new double[]{2.0});
        LogThrottlingHelper.LogAction baz = this.helper.record("baz", 100L, new double[]{3.0, 3.0});
        Assertions.assertTrue((boolean)foo.shouldLog());
        Assertions.assertTrue((boolean)bar.shouldLog());
        Assertions.assertTrue((boolean)baz.shouldLog());
        Assertions.assertEquals((int)1, (int)foo.getCount());
        Assertions.assertEquals((int)2, (int)bar.getCount());
        Assertions.assertEquals((int)2, (int)baz.getCount());
        Assertions.assertEquals((double)2.0, (double)bar.getStats(0).getMean(), (double)0.01);
        Assertions.assertEquals((double)3.0, (double)baz.getStats(0).getMean(), (double)0.01);
        Assertions.assertEquals((double)3.0, (double)baz.getStats(1).getMean(), (double)0.01);
        Assertions.assertEquals((double)2.0, (double)this.helper.getCurrentStats("bar", 0).getMax(), (double)0.0);
        Assertions.assertEquals((double)3.0, (double)this.helper.getCurrentStats("baz", 0).getMax(), (double)0.0);
    }
}

