/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedByInterruptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.TestRpcBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRPCWaitForProxy
extends TestRpcBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestRPCWaitForProxy.class);
    private static final Configuration conf = new Configuration();

    @BeforeEach
    public void setupProtocolEngine() {
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
    }

    @Test
    @Timeout(value=50L)
    public void testWaitForProxy() throws Throwable {
        RpcThread worker = new RpcThread(0);
        worker.start();
        worker.join();
        Throwable caught = worker.getCaught();
        Throwable cause = caught.getCause();
        Assertions.assertNotNull((Object)cause, (String)"No exception was raised");
        if (!(cause instanceof ConnectException)) {
            throw caught;
        }
    }

    @Test
    @Timeout(value=10L)
    public void testInterruptedWaitForProxy() throws Throwable {
        RpcThread worker = new RpcThread(100);
        worker.start();
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)worker.waitStarted, (String)"worker hasn't started");
        worker.interrupt();
        worker.join();
        Throwable caught = worker.getCaught();
        Assertions.assertNotNull((Object)caught, (String)"No exception was raised");
        Throwable cause = caught.getCause();
        if (cause == null) {
            cause = caught;
        } else if (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (!(cause instanceof InterruptedIOException) && !(cause instanceof ClosedByInterruptException)) {
            throw caught;
        }
    }

    private class RpcThread
    extends Thread {
        private Throwable caught;
        private int connectRetries;
        private volatile boolean waitStarted = false;

        private RpcThread(int connectRetries) {
            this.connectRetries = connectRetries;
        }

        @Override
        public void run() {
            try {
                Configuration config = new Configuration(conf);
                config.setInt("ipc.client.connect.max.retries", this.connectRetries);
                config.setInt("ipc.client.connect.max.retries.on.timeouts", this.connectRetries);
                this.waitStarted = true;
                int invalidPort = 20;
                InetSocketAddress invalidAddress = new InetSocketAddress("0.0.0.0", invalidPort);
                TestRpcBase.TestRpcService proxy = (TestRpcBase.TestRpcService)RPC.getProxy(TestRpcBase.TestRpcService.class, (long)1L, (InetSocketAddress)invalidAddress, (Configuration)conf);
                proxy.echo(null, TestRpcBase.newEchoRequest("hello"));
            }
            catch (Throwable throwable) {
                this.caught = throwable;
            }
        }

        public Throwable getCaught() {
            return this.caught;
        }
    }
}

