/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtoBufRPCCompatibility {
    private static final String ADDRESS = "0.0.0.0";
    public static final int PORT = 0;
    private static InetSocketAddress addr;
    private static RPC.Server server;
    private static Configuration conf;

    @Test
    public void testProtocolVersionMismatch() throws IOException, ServiceException {
        TestProtos.EmptyRequestProto emptyRequest;
        block2: {
            conf = new Configuration();
            conf.setInt("ipc.maximum.data.length", 1024);
            RPC.setProtocolEngine((Configuration)conf, NewRpcService.class, ProtobufRpcEngine2.class);
            NewServerImpl serverImpl = new NewServerImpl();
            BlockingService service = TestRpcServiceProtos.NewProtobufRpcProto.newReflectiveBlockingService(serverImpl);
            server = new RPC.Builder(conf).setProtocol(NewRpcService.class).setInstance((Object)service).setBindAddress(ADDRESS).setPort(0).build();
            addr = NetUtils.getConnectAddress((Server)server);
            server.start();
            RPC.setProtocolEngine((Configuration)conf, OldRpcService.class, ProtobufRpcEngine2.class);
            OldRpcService proxy = (OldRpcService)RPC.getProxy(OldRpcService.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
            emptyRequest = TestProtos.EmptyRequestProto.newBuilder().build();
            try {
                proxy.ping(null, emptyRequest);
                Assertions.fail((String)"Expected an exception to occur as version mismatch.");
            }
            catch (Exception e) {
                if (e.getMessage().contains("version mismatch")) break block2;
                throw new IOException(e);
            }
        }
        RPC.setProtocolEngine((Configuration)conf, NewerRpcService.class, ProtobufRpcEngine2.class);
        NewerRpcService newProxy = (NewerRpcService)RPC.getProxy(NewerRpcService.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
        newProxy.echo(null, emptyRequest);
    }

    @ProtocolInfo(protocolName="testProto", protocolVersion=2L)
    public static class NewerServerImpl
    implements NewerRpcService {
        @Override
        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            byte[] clientId = Server.getClientId();
            Assertions.assertNotNull((Object)Server.getClientId());
            Assertions.assertEquals((int)16, (int)clientId.length);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.EmptyResponseProto echo(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            byte[] clientId = Server.getClientId();
            Assertions.assertNotNull((Object)Server.getClientId());
            Assertions.assertEquals((int)16, (int)clientId.length);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }
    }

    public static class NewServerImpl
    implements NewRpcService {
        @Override
        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            byte[] clientId = Server.getClientId();
            Assertions.assertNotNull((Object)Server.getClientId());
            Assertions.assertEquals((int)16, (int)clientId.length);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.OptResponseProto echo(RpcController unused, TestProtos.OptRequestProto request) throws ServiceException {
            return TestProtos.OptResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }
    }

    public static class OldServerImpl
    implements OldRpcService {
        @Override
        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            byte[] clientId = Server.getClientId();
            Assertions.assertNotNull((Object)Server.getClientId());
            Assertions.assertEquals((int)16, (int)clientId.length);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.EmptyResponseProto echo(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            byte[] clientId = Server.getClientId();
            Assertions.assertNotNull((Object)Server.getClientId());
            Assertions.assertEquals((int)16, (int)clientId.length);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }
    }

    @ProtocolInfo(protocolName="testProto", protocolVersion=2L)
    public static interface NewerRpcService
    extends TestRpcServiceProtos.NewerProtobufRpcProto.BlockingInterface {
    }

    @ProtocolInfo(protocolName="testProto", protocolVersion=2L)
    public static interface NewRpcService
    extends TestRpcServiceProtos.NewProtobufRpcProto.BlockingInterface {
    }

    @ProtocolInfo(protocolName="testProto", protocolVersion=1L)
    public static interface OldRpcService
    extends TestRpcServiceProtos.OldProtobufRpcProto.BlockingInterface {
    }
}

