/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallQueueManager;
import org.apache.hadoop.ipc.FairCallQueue;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RpcMultiplexer;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.ipc.UserIdentityProvider;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.MetricsAsserts;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFairCallQueue {
    private FairCallQueue<Schedulable> fcq;

    private Schedulable mockCall(String id, int priority) {
        Schedulable mockCall = (Schedulable)Mockito.mock(Schedulable.class);
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi.getUserName()).thenReturn((Object)id);
        Mockito.when((Object)mockCall.getUserGroupInformation()).thenReturn((Object)ugi);
        Mockito.when((Object)mockCall.getPriorityLevel()).thenReturn((Object)priority);
        Mockito.when((Object)mockCall.toString()).thenReturn((Object)("id=" + id + " priority=" + priority));
        return mockCall;
    }

    private Schedulable mockCall(String id) {
        return this.mockCall(id, 0);
    }

    @BeforeEach
    public void setUp() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        this.fcq = new FairCallQueue(2, 10, "ns", conf);
    }

    @Test
    public void testTotalCapacityOfSubQueues() {
        Configuration conf = new Configuration();
        FairCallQueue fairCallQueue = new FairCallQueue(1, 1000, "ns", conf);
        Assertions.assertThat((int)fairCallQueue.remainingCapacity()).isEqualTo(1000);
        fairCallQueue = new FairCallQueue(4, 1000, "ns", conf);
        Assertions.assertThat((int)fairCallQueue.remainingCapacity()).isEqualTo(1000);
        fairCallQueue = new FairCallQueue(7, 1000, "ns", conf);
        Assertions.assertThat((int)fairCallQueue.remainingCapacity()).isEqualTo(1000);
        fairCallQueue = new FairCallQueue(1, 1025, "ns", conf);
        Assertions.assertThat((int)fairCallQueue.remainingCapacity()).isEqualTo(1025);
        fairCallQueue = new FairCallQueue(4, 1025, "ns", conf);
        Assertions.assertThat((int)fairCallQueue.remainingCapacity()).isEqualTo(1025);
        fairCallQueue = new FairCallQueue(7, 1025, "ns", conf);
        Assertions.assertThat((int)fairCallQueue.remainingCapacity()).isEqualTo(1025);
        fairCallQueue = new FairCallQueue(7, 1025, "ns", new int[]{7, 6, 5, 4, 3, 2, 1}, false, conf);
        Assertions.assertThat((int)fairCallQueue.remainingCapacity()).isEqualTo(1025);
    }

    @Test
    public void testPrioritization() {
        int numQueues = 10;
        Configuration conf = new Configuration();
        this.fcq = new FairCallQueue(numQueues, numQueues, "ns", conf);
        ArrayList<Schedulable> calls = new ArrayList<Schedulable>();
        for (int i = 0; i < numQueues; ++i) {
            Schedulable call = this.mockCall("u", i);
            calls.add(call);
            this.fcq.add(call);
        }
        final AtomicInteger currentIndex = new AtomicInteger();
        this.fcq.setMultiplexer(new RpcMultiplexer(){

            public int getAndAdvanceCurrentIndex() {
                return currentIndex.get();
            }
        });
        currentIndex.set(3);
        org.junit.jupiter.api.Assertions.assertSame(calls.get(3), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(0), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(1), (Object)this.fcq.poll());
        currentIndex.set(6);
        org.junit.jupiter.api.Assertions.assertSame(calls.get(6), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(2), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(4), (Object)this.fcq.poll());
        currentIndex.set(8);
        org.junit.jupiter.api.Assertions.assertSame(calls.get(8), (Object)this.fcq.poll());
        currentIndex.set(9);
        org.junit.jupiter.api.Assertions.assertSame(calls.get(9), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(5), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(7), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertNull((Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertNull((Object)this.fcq.poll());
    }

    @Test
    public void testQueueCapacity() {
        int numQueues = 2;
        int capacity = 4;
        Configuration conf = new Configuration();
        ArrayList<Schedulable> calls = new ArrayList<Schedulable>();
        this.fcq = new FairCallQueue(numQueues, 4, "ns", conf);
        FairCallQueue fcq1 = new FairCallQueue(numQueues, capacity, "ns", new int[]{1, 3}, false, conf);
        for (int i = 0; i < capacity; ++i) {
            Schedulable call = this.mockCall("u", i % 2);
            calls.add(call);
            this.fcq.add(call);
            fcq1.add(call);
        }
        final AtomicInteger currentIndex = new AtomicInteger();
        this.fcq.setMultiplexer(new RpcMultiplexer(){

            public int getAndAdvanceCurrentIndex() {
                return currentIndex.get();
            }
        });
        fcq1.setMultiplexer(new RpcMultiplexer(){

            public int getAndAdvanceCurrentIndex() {
                return currentIndex.get();
            }
        });
        currentIndex.set(1);
        org.junit.jupiter.api.Assertions.assertSame(calls.get(1), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(3), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(0), (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(2), (Object)this.fcq.poll());
        currentIndex.set(1);
        org.junit.jupiter.api.Assertions.assertSame(calls.get(1), (Object)fcq1.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(2), (Object)fcq1.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(3), (Object)fcq1.poll());
        org.junit.jupiter.api.Assertions.assertSame(calls.get(0), (Object)fcq1.poll());
    }

    @Test
    public void testInsertionWithFailover() {
        Configuration conf = new Configuration();
        this.fcq = (FairCallQueue)Mockito.spy((Object)new FairCallQueue(3, 6, "ns", true, conf));
        Schedulable p0 = this.mockCall("a", 0);
        Schedulable p1 = this.mockCall("b", 1);
        this.addToQueueAndVerify(p0, 1, 0, 0);
        this.addToQueueAndVerify(p1, 0, 1, 0);
        this.addToQueueAndVerify(p0, 1, 0, 0);
        this.addToQueueAndVerify(p0, 1, 1, 0);
        this.addToQueueAndVerify(p1, 0, 1, 1);
        this.addToQueueAndVerify(p0, 1, 1, 1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p0);
            org.junit.jupiter.api.Assertions.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.FATAL, true);
        }
    }

    private void addToQueueAndVerify(Schedulable call, int expectedQueue0, int expectedQueue1, int expectedQueue2) {
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(call);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)expectedQueue0))).offerQueue(0, call);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)expectedQueue1))).offerQueue(1, call);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)expectedQueue2))).offerQueue(2, call);
    }

    @Test
    public void testInsertion() throws Exception {
        Configuration conf = new Configuration();
        this.fcq = (FairCallQueue)Mockito.spy((Object)new FairCallQueue(3, 6, "ns", conf));
        Schedulable p0 = this.mockCall("a", 0);
        Schedulable p1 = this.mockCall("b", 1);
        Schedulable p2 = this.mockCall("c", 2);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p0);
            org.junit.jupiter.api.Assertions.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR, false);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p1);
            org.junit.jupiter.api.Assertions.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR, false);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p2);
            org.junit.jupiter.api.Assertions.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.FATAL, false);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p2);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        RuntimeException stopPuts = new RuntimeException();
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            ((FairCallQueue)Mockito.doThrow((Throwable[])new Throwable[]{stopPuts}).when(this.fcq)).putQueue(Mockito.anyInt(), (Schedulable)Mockito.any());
            this.fcq.put(p0);
            org.junit.jupiter.api.Assertions.fail((String)"didn't fail");
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.assertSame((Object)stopPuts, (Object)e);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).putQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            ((FairCallQueue)Mockito.doThrow((Throwable[])new Throwable[]{stopPuts}).when(this.fcq)).putQueue(Mockito.anyInt(), (Schedulable)Mockito.any());
            this.fcq.put(p2);
            org.junit.jupiter.api.Assertions.fail((String)"didn't fail");
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.assertSame((Object)stopPuts, (Object)e);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).putQueue(2, p2);
    }

    private void checkOverflowException(Exception ex, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto status, boolean failOverTriggered) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(ex instanceof CallQueueManager.CallQueueOverflowException), (String)(ex.getClass().getName() + " != CallQueueOverflowException"));
        IOException ioe = ((CallQueueManager.CallQueueOverflowException)ex).getCause();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)ioe);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(ioe instanceof RpcServerException), (String)(ioe.getClass().getName() + " != RpcServerException"));
        RpcServerException rse = (RpcServerException)ioe;
        org.junit.jupiter.api.Assertions.assertEquals((Object)status, (Object)rse.getRpcStatusProto());
        if (failOverTriggered) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(rse.getCause() instanceof StandbyException), (String)(rse.getClass().getName() + " != RetriableException"));
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(rse.getCause() instanceof RetriableException), (String)(rse.getClass().getName() + " != RetriableException"));
        }
    }

    @Test
    public void testPollReturnsNullWhenEmpty() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.fcq.poll());
    }

    @Test
    public void testPollReturnsTopCallWhenNotEmpty() {
        Schedulable call = this.mockCall("c");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcq.offer(call));
        org.junit.jupiter.api.Assertions.assertEquals((Object)call, (Object)this.fcq.poll());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.fcq.size());
    }

    @Test
    public void testOfferSucceeds() {
        for (int i = 0; i < 5; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcq.offer(this.mockCall("c")));
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.fcq.size());
    }

    @Test
    public void testOfferFailsWhenFull() {
        for (int i = 0; i < 5; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcq.offer(this.mockCall("c")));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fcq.offer(this.mockCall("c")));
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.fcq.size());
    }

    @Test
    public void testOfferSucceedsWhenScheduledLowPriority() {
        int[] mockedPriorities = new int[]{0, 0, 0, 0, 0, 1, 0};
        for (int i = 0; i < 5; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcq.offer(this.mockCall("c", mockedPriorities[i])));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcq.offer(this.mockCall("c", mockedPriorities[5])));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)this.fcq.size());
    }

    @Test
    public void testPeekNullWhenEmpty() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.fcq.peek());
    }

    @Test
    public void testPeekNonDestructive() {
        Schedulable call = this.mockCall("c", 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcq.offer(call));
        org.junit.jupiter.api.Assertions.assertEquals((Object)call, (Object)this.fcq.peek());
        org.junit.jupiter.api.Assertions.assertEquals((Object)call, (Object)this.fcq.peek());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.fcq.size());
    }

    @Test
    public void testPeekPointsAtHead() {
        Schedulable call = this.mockCall("c", 0);
        Schedulable next = this.mockCall("b", 0);
        this.fcq.offer(call);
        this.fcq.offer(next);
        org.junit.jupiter.api.Assertions.assertEquals((Object)call, (Object)this.fcq.peek());
    }

    @Test
    public void testPollTimeout() throws InterruptedException {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.fcq.poll(10L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testPollSuccess() throws InterruptedException {
        Schedulable call = this.mockCall("c", 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcq.offer(call));
        org.junit.jupiter.api.Assertions.assertEquals((Object)call, (Object)this.fcq.poll(10L, TimeUnit.MILLISECONDS));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.fcq.size());
    }

    @Test
    public void testOfferTimeout() throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcq.offer(this.mockCall("c"), 10L, TimeUnit.MILLISECONDS));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fcq.offer(this.mockCall("e"), 10L, TimeUnit.MILLISECONDS));
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.fcq.size());
    }

    @Test
    public void testDrainTo() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        FairCallQueue fcq2 = new FairCallQueue(2, 10, "ns", conf);
        for (int i = 0; i < 3; ++i) {
            this.fcq.offer(this.mockCall("c"));
        }
        this.fcq.drainTo((Collection)fcq2);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.fcq.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)fcq2.size());
    }

    @Test
    public void testDrainToWithLimit() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        FairCallQueue fcq2 = new FairCallQueue(2, 10, "ns", conf);
        for (int i = 0; i < 3; ++i) {
            this.fcq.offer(this.mockCall("c"));
        }
        this.fcq.drainTo((Collection)fcq2, 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.fcq.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)fcq2.size());
    }

    @Test
    public void testInitialRemainingCapacity() {
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)this.fcq.remainingCapacity());
    }

    @Test
    public void testFirstQueueFullRemainingCapacity() {
        while (this.fcq.offer(this.mockCall("c"))) {
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.fcq.remainingCapacity());
    }

    @Test
    public void testAllQueuesFullRemainingCapacity() {
        int[] mockedPriorities = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0};
        int i = 0;
        while (this.fcq.offer(this.mockCall("c", mockedPriorities[i++]))) {
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.fcq.remainingCapacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)this.fcq.size());
    }

    @Test
    public void testQueuesPartialFilledRemainingCapacity() {
        int[] mockedPriorities = new int[]{0, 1, 0, 1, 0};
        for (int i = 0; i < 5; ++i) {
            this.fcq.offer(this.mockCall("c", mockedPriorities[i]));
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.fcq.remainingCapacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.fcq.size());
    }

    public void assertCanTake(BlockingQueue<Schedulable> cq, int numberOfTakes, int takeAttempts) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(numberOfTakes);
        Taker taker = new Taker(cq, takeAttempts, "default", latch);
        Thread t = new Thread(taker);
        t.start();
        latch.await();
        org.junit.jupiter.api.Assertions.assertEquals((int)numberOfTakes, (int)taker.callsTaken);
        t.interrupt();
    }

    public void assertCanPut(BlockingQueue<Schedulable> cq, int numberOfPuts, int putAttempts) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(numberOfPuts);
        Putter putter = new Putter(cq, putAttempts, null, latch);
        Thread t = new Thread(putter);
        t.start();
        latch.await();
        org.junit.jupiter.api.Assertions.assertEquals((int)numberOfPuts, (int)putter.callsAdded);
        t.interrupt();
    }

    @Test
    public void testPutOverflows() throws InterruptedException {
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 8, 8);
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)this.fcq.size());
    }

    @Test
    public void testPutBlocksWhenAllFull() throws InterruptedException {
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 10, 10);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)this.fcq.size());
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 0, 1);
    }

    @Test
    public void testTakeBlocksWhenEmpty() throws InterruptedException {
        this.assertCanTake((BlockingQueue<Schedulable>)this.fcq, 0, 1);
    }

    @Test
    public void testTakeRemovesCall() throws InterruptedException {
        Schedulable call = this.mockCall("c");
        this.fcq.offer(call);
        org.junit.jupiter.api.Assertions.assertEquals((Object)call, (Object)this.fcq.take());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.fcq.size());
    }

    @Test
    public void testTakeTriesNextQueue() throws InterruptedException {
        RpcMultiplexer q0mux = (RpcMultiplexer)Mockito.mock(RpcMultiplexer.class);
        Mockito.when((Object)q0mux.getAndAdvanceCurrentIndex()).thenReturn((Object)0);
        this.fcq.setMultiplexer(q0mux);
        Schedulable call = this.mockCall("c", 1);
        this.fcq.put(call);
        org.junit.jupiter.api.Assertions.assertEquals((Object)call, (Object)this.fcq.take());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.fcq.size());
    }

    @Test
    public void testFairCallQueueMXBean() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=ns,name=FairCallQueue");
        Schedulable call = this.mockCall("c");
        this.fcq.put(call);
        int[] queueSizes = (int[])mbs.getAttribute(mxbeanName, "QueueSizes");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)queueSizes[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)queueSizes[1]);
        this.fcq.take();
        queueSizes = (int[])mbs.getAttribute(mxbeanName, "QueueSizes");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)queueSizes[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)queueSizes[1]);
    }

    @Test
    public void testFairCallQueueMetrics() throws Exception {
        String fcqMetrics = "ns.FairCallQueue";
        Schedulable p0 = this.mockCall("a", 0);
        Schedulable p1 = this.mockCall("b", 1);
        MetricsAsserts.assertGauge("FairCallQueueSize_p0", 0, MetricsAsserts.getMetrics("ns.FairCallQueue"));
        MetricsAsserts.assertGauge("FairCallQueueSize_p1", 0, MetricsAsserts.getMetrics("ns.FairCallQueue"));
        MetricsAsserts.assertCounter("FairCallQueueOverflowedCalls_p0", 0L, MetricsAsserts.getMetrics("ns.FairCallQueue"));
        MetricsAsserts.assertCounter("FairCallQueueOverflowedCalls_p1", 0L, MetricsAsserts.getMetrics("ns.FairCallQueue"));
        for (int i = 0; i < 5; ++i) {
            this.fcq.add(p0);
            this.fcq.add(p1);
        }
        try {
            this.fcq.add(p1);
            org.junit.jupiter.api.Assertions.fail((String)"didn't overflow");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        MetricsAsserts.assertGauge("FairCallQueueSize_p0", 5, MetricsAsserts.getMetrics("ns.FairCallQueue"));
        MetricsAsserts.assertGauge("FairCallQueueSize_p1", 5, MetricsAsserts.getMetrics("ns.FairCallQueue"));
        MetricsAsserts.assertCounter("FairCallQueueOverflowedCalls_p0", 0L, MetricsAsserts.getMetrics("ns.FairCallQueue"));
        MetricsAsserts.assertCounter("FairCallQueueOverflowedCalls_p1", 1L, MetricsAsserts.getMetrics("ns.FairCallQueue"));
    }

    public class Taker
    implements Runnable {
        private final BlockingQueue<Schedulable> cq;
        public final String tag;
        public volatile int callsTaken = 0;
        public volatile Schedulable lastResult = null;
        private final int maxCalls;
        private final CountDownLatch latch;
        private IdentityProvider uip;

        public Taker(BlockingQueue<Schedulable> aCq, int maxCalls, String tag, CountDownLatch latch) {
            this.maxCalls = maxCalls;
            this.cq = aCq;
            this.tag = tag;
            this.uip = new UserIdentityProvider();
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                while (this.callsTaken < this.maxCalls || this.maxCalls < 0) {
                    Schedulable res = this.cq.take();
                    String identity = this.uip.makeIdentity(res);
                    if (this.tag != null && this.tag.equals(identity)) {
                        this.cq.put(res);
                        continue;
                    }
                    ++this.callsTaken;
                    this.latch.countDown();
                    this.lastResult = res;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public class Putter
    implements Runnable {
        private final BlockingQueue<Schedulable> cq;
        public final String tag;
        public volatile int callsAdded = 0;
        private final int maxCalls;
        private final CountDownLatch latch;

        public Putter(BlockingQueue<Schedulable> aCq, int maxCalls, String tag, CountDownLatch latch) {
            this.maxCalls = maxCalls;
            this.cq = aCq;
            this.tag = tag;
            this.latch = latch;
        }

        private String getTag() {
            if (this.tag != null) {
                return this.tag;
            }
            return "";
        }

        @Override
        public void run() {
            try {
                while (this.callsAdded < this.maxCalls || this.maxCalls < 0) {
                    this.cq.put(TestFairCallQueue.this.mockCall(this.getTag()));
                    ++this.callsAdded;
                    this.latch.countDown();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

