/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallerContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCallerContext {
    @Test
    public void testBuilderAppend() {
        Configuration conf = new Configuration();
        conf.set("hadoop.caller.context.separator", "$");
        CallerContext.Builder builder = new CallerContext.Builder(null, conf);
        CallerContext context = builder.append("context1").append("context2").append("key3", "value3").build();
        Assertions.assertEquals((Object)true, (Object)context.getContext().contains("$"));
        String[] items = context.getContext().split("\\$");
        Assertions.assertEquals((int)3, (int)items.length);
        Assertions.assertEquals((Object)"key3:value3", (Object)items[2]);
        builder.append("$$");
        Assertions.assertEquals((Object)"context1$context2$key3:value3$$$", (Object)builder.build().getContext());
    }

    @Test
    public void testBuilderAppendIfAbsent() {
        Configuration conf = new Configuration();
        conf.set("hadoop.caller.context.separator", "$");
        CallerContext.Builder builder = new CallerContext.Builder(null, conf);
        builder.append("key1", "value1");
        Assertions.assertEquals((Object)"key1:value1", (Object)builder.build().getContext());
        builder.appendIfAbsent("key1", "value2");
        String[] items = builder.build().getContext().split("\\$");
        Assertions.assertEquals((int)1, (int)items.length);
        Assertions.assertEquals((Object)"key1:value1", (Object)builder.build().getContext());
        builder.appendIfAbsent("key2", "value2");
        String[] items2 = builder.build().getContext().split("\\$");
        Assertions.assertEquals((int)2, (int)items2.length);
        Assertions.assertEquals((Object)"key1:value1$key2:value2", (Object)builder.build().getContext());
        builder.appendIfAbsent("key", "value");
        String[] items3 = builder.build().getContext().split("\\$");
        Assertions.assertEquals((int)3, (int)items3.length);
        Assertions.assertEquals((Object)"key1:value1$key2:value2$key:value", (Object)builder.build().getContext());
    }

    @Test
    public void testNewBuilder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Configuration conf = new Configuration();
            conf.set("hadoop.caller.context.separator", "\t");
            CallerContext.Builder builder = new CallerContext.Builder(null, conf);
            builder.build();
        });
    }
}

