/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;

public class TestSerializationFactory {
    static Configuration conf;
    static SerializationFactory factory;

    @BeforeAll
    public static void setup() throws Exception {
        conf = new Configuration();
        factory = new SerializationFactory(conf);
    }

    @Test
    public void testSerializationKeyIsEmpty() {
        Configuration conf = new Configuration();
        conf.set("io.serializations", "");
        SerializationFactory factory = new SerializationFactory(conf);
    }

    @Test
    public void testSerializationKeyIsUnset() {
        Configuration conf = new Configuration();
        conf.unset("io.serializations");
        SerializationFactory factory = new SerializationFactory(conf);
    }

    @Test
    public void testSerializationKeyIsInvalid() {
        Configuration conf = new Configuration();
        conf.set("io.serializations", "INVALID_KEY_XXX");
        SerializationFactory factory = new SerializationFactory(conf);
    }

    @Test
    public void testGetSerializer() {
        Assertions.assertNotNull((Object)factory.getSerializer(Writable.class), (String)"A valid class must be returned for default Writable SerDe");
        Assertions.assertNull((Object)factory.getSerializer(TestSerializationFactory.class), (String)"A null should be returned if there are no serializers found.");
    }

    @Test
    public void testGetDeserializer() {
        Assertions.assertNotNull((Object)factory.getDeserializer(Writable.class), (String)"A valid class must be returned for default Writable SerDe");
        Assertions.assertNull((Object)factory.getDeserializer(TestSerializationFactory.class), (String)"A null should be returned if there are no deserializers found");
    }

    @Test
    public void testSerializationKeyIsTrimmed() {
        Configuration conf = new Configuration();
        conf.set("io.serializations", " org.apache.hadoop.io.serializer.WritableSerialization ");
        SerializationFactory factory = new SerializationFactory(conf);
        Assertions.assertNotNull((Object)factory.getSerializer(LongWritable.class), (String)"Valid class must be returned");
    }

    static {
        GenericTestUtils.setLogLevel(SerializationFactory.LOG, Level.TRACE);
    }
}

