/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.Utils;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestVLong {
    private static String ROOT = GenericTestUtils.getTestDir().getAbsolutePath();
    private Configuration conf;
    private FileSystem fs;
    private Path path;
    private String outputFile = "TestVLong";

    @BeforeEach
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.path = new Path(ROOT, this.outputFile);
        this.fs = this.path.getFileSystem(this.conf);
        if (this.fs.exists(this.path)) {
            this.fs.delete(this.path, false);
        }
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.fs.exists(this.path)) {
            this.fs.delete(this.path, false);
        }
    }

    @Test
    public void testVLongByte() throws IOException {
        FSDataOutputStream out = this.fs.create(this.path);
        for (int i = -128; i <= 127; ++i) {
            Utils.writeVLong((DataOutput)out, (long)i);
        }
        out.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)352L, (long)this.fs.getFileStatus(this.path).getLen(), (String)"Incorrect encoded size");
        FSDataInputStream in = this.fs.open(this.path);
        for (int i = -128; i <= 127; ++i) {
            Assertions.assertThat((long)Utils.readVLong((DataInput)in)).isEqualTo((long)i);
        }
        in.close();
        this.fs.delete(this.path, false);
    }

    private long writeAndVerify(int shift) throws IOException {
        FSDataOutputStream out = this.fs.create(this.path);
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            Utils.writeVLong((DataOutput)out, (long)((long)i << shift));
        }
        out.close();
        FSDataInputStream in = this.fs.open(this.path);
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            Assertions.assertThat((long)Utils.readVLong((DataInput)in)).isEqualTo((long)i << shift);
        }
        in.close();
        long ret = this.fs.getFileStatus(this.path).getLen();
        this.fs.delete(this.path, false);
        return ret;
    }

    @Test
    public void testVLongShort() throws IOException {
        long size = this.writeAndVerify(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)186208L, (long)size, (String)"Incorrect encoded size");
    }

    @Test
    public void testVLong3Bytes() throws IOException {
        long size = this.writeAndVerify(8);
        org.junit.jupiter.api.Assertions.assertEquals((long)253911L, (long)size, (String)"Incorrect encoded size");
    }

    @Test
    public void testVLong4Bytes() throws IOException {
        long size = this.writeAndVerify(16);
        org.junit.jupiter.api.Assertions.assertEquals((long)323550L, (long)size, (String)"Incorrect encoded size");
    }

    @Test
    public void testVLong5Bytes() throws IOException {
        long size = this.writeAndVerify(24);
        org.junit.jupiter.api.Assertions.assertEquals((long)392941L, (long)size, (String)"Incorrect encoded size");
    }

    private void verifySixOrMoreBytes(int bytes) throws IOException {
        long size = this.writeAndVerify(8 * (bytes - 2));
        org.junit.jupiter.api.Assertions.assertEquals((long)(65536 * (bytes + 1) - 256 - bytes + 1), (long)size, (String)"Incorrect encoded size");
    }

    @Test
    public void testVLong6Bytes() throws IOException {
        this.verifySixOrMoreBytes(6);
    }

    @Test
    public void testVLong7Bytes() throws IOException {
        this.verifySixOrMoreBytes(7);
    }

    @Test
    public void testVLong8Bytes() throws IOException {
        this.verifySixOrMoreBytes(8);
    }

    @Test
    public void testVLongRandom() throws IOException {
        int count = 0x100000;
        long[] data = new long[count];
        Random rng = new Random();
        for (int i = 0; i < data.length; ++i) {
            int shift = rng.nextInt(64) + 1;
            long mask = (1L << shift) - 1L;
            long a = (long)rng.nextInt() << 32;
            long b = (long)rng.nextInt() & 0xFFFFFFFFL;
            data[i] = a + b & mask;
        }
        FSDataOutputStream out = this.fs.create(this.path);
        for (int i = 0; i < data.length; ++i) {
            Utils.writeVLong((DataOutput)out, (long)data[i]);
        }
        out.close();
        FSDataInputStream in = this.fs.open(this.path);
        for (int i = 0; i < data.length; ++i) {
            Assertions.assertThat((long)Utils.readVLong((DataInput)in)).isEqualTo(data[i]);
        }
        in.close();
        this.fs.delete(this.path, false);
    }
}

