/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.MetaBlockAlreadyExists;
import org.apache.hadoop.io.file.tfile.MetaBlockDoesNotExist;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTFile {
    private static String ROOT = GenericTestUtils.getTempPath("tfile-test");
    private FileSystem fs;
    private Configuration conf;
    private static final int minBlockSize = 512;
    private static final int largeVal = 0x300000;
    private static final String localFormatter = "%010d";

    @BeforeEach
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    @AfterEach
    public void tearDown() throws IOException {
    }

    public byte[] readKey(TFile.Reader.Scanner scanner) throws IOException {
        int keylen = scanner.entry().getKeyLength();
        byte[] read = new byte[keylen];
        scanner.entry().getKey(read);
        return read;
    }

    public byte[] readValue(TFile.Reader.Scanner scanner) throws IOException {
        int valueLen = scanner.entry().getValueLength();
        byte[] read = new byte[valueLen];
        scanner.entry().getValue(read);
        return read;
    }

    public byte[] readLongValue(TFile.Reader.Scanner scanner, int len) throws IOException {
        DataInputStream din = scanner.entry().getValueStream();
        byte[] b = new byte[len];
        din.readFully(b);
        din.close();
        return b;
    }

    private int writeSomeRecords(TFile.Writer writer, int start, int n) throws IOException {
        String value = "value";
        for (int i = start; i < start + n; ++i) {
            String key = String.format(localFormatter, i);
            writer.append(key.getBytes(), (value + key).getBytes());
            writer.append(key.getBytes(), (value + key).getBytes());
        }
        return start + n;
    }

    private int readAndCheckbytes(TFile.Reader.Scanner scanner, int start, int n) throws IOException {
        String value = "value";
        for (int i = start; i < start + n; ++i) {
            byte[] key = this.readKey(scanner);
            byte[] val = this.readValue(scanner);
            String keyStr = String.format(localFormatter, i);
            String valStr = value + keyStr;
            Assertions.assertTrue((boolean)Arrays.equals(keyStr.getBytes(), key), (String)("bytes for keys do not match " + keyStr + " " + new String(key)));
            Assertions.assertTrue((boolean)Arrays.equals(valStr.getBytes(), val), (String)("bytes for vals do not match " + valStr + " " + new String(val)));
            Assertions.assertTrue((boolean)scanner.advance());
            key = this.readKey(scanner);
            val = this.readValue(scanner);
            Assertions.assertTrue((boolean)Arrays.equals(keyStr.getBytes(), key), (String)"bytes for keys do not match");
            Assertions.assertTrue((boolean)Arrays.equals(valStr.getBytes(), val), (String)"bytes for vals do not match");
            Assertions.assertTrue((boolean)scanner.advance());
        }
        return start + n;
    }

    private int writeLargeRecords(TFile.Writer writer, int start, int n) throws IOException {
        byte[] value = new byte[0x300000];
        for (int i = start; i < start + n; ++i) {
            String key = String.format(localFormatter, i);
            writer.append(key.getBytes(), value);
            writer.append(key.getBytes(), value);
        }
        return start + n;
    }

    private int readLargeRecords(TFile.Reader.Scanner scanner, int start, int n) throws IOException {
        for (int i = start; i < start + n; ++i) {
            byte[] key = this.readKey(scanner);
            String keyStr = String.format(localFormatter, i);
            Assertions.assertTrue((boolean)Arrays.equals(keyStr.getBytes(), key), (String)"bytes for keys do not match");
            scanner.advance();
            key = this.readKey(scanner);
            Assertions.assertTrue((boolean)Arrays.equals(keyStr.getBytes(), key), (String)"bytes for keys do not match");
            scanner.advance();
        }
        return start + n;
    }

    private void writeEmptyRecords(TFile.Writer writer, int n) throws IOException {
        byte[] key = new byte[]{};
        byte[] value = new byte[]{};
        for (int i = 0; i < n; ++i) {
            writer.append(key, value);
        }
    }

    private void readEmptyRecords(TFile.Reader.Scanner scanner, int n) throws IOException {
        byte[] key = new byte[]{};
        byte[] value = new byte[]{};
        byte[] readKey = null;
        byte[] readValue = null;
        for (int i = 0; i < n; ++i) {
            readKey = this.readKey(scanner);
            readValue = this.readValue(scanner);
            Assertions.assertTrue((boolean)Arrays.equals(readKey, key), (String)"failed to match keys");
            Assertions.assertTrue((boolean)Arrays.equals(readValue, value), (String)"failed to match values");
            Assertions.assertTrue((boolean)scanner.advance(), (String)"failed to advance cursor");
        }
    }

    private int writePrepWithKnownLength(TFile.Writer writer, int start, int n) throws IOException {
        String key = String.format(localFormatter, start);
        int keyLen = key.getBytes().length;
        String value = "value" + key;
        int valueLen = value.getBytes().length;
        for (int i = start; i < start + n; ++i) {
            DataOutputStream out = writer.prepareAppendKey(keyLen);
            String localKey = String.format(localFormatter, i);
            out.write(localKey.getBytes());
            out.close();
            out = writer.prepareAppendValue(valueLen);
            String localValue = "value" + localKey;
            out.write(localValue.getBytes());
            out.close();
        }
        return start + n;
    }

    private int readPrepWithKnownLength(TFile.Reader.Scanner scanner, int start, int n) throws IOException {
        for (int i = start; i < start + n; ++i) {
            String key = String.format(localFormatter, i);
            byte[] read = this.readKey(scanner);
            Assertions.assertTrue((boolean)Arrays.equals(key.getBytes(), read), (String)"keys not equal");
            String value = "value" + key;
            read = this.readValue(scanner);
            Assertions.assertTrue((boolean)Arrays.equals(value.getBytes(), read), (String)"values not equal");
            scanner.advance();
        }
        return start + n;
    }

    private int writePrepWithUnkownLength(TFile.Writer writer, int start, int n) throws IOException {
        for (int i = start; i < start + n; ++i) {
            DataOutputStream out = writer.prepareAppendKey(-1);
            String localKey = String.format(localFormatter, i);
            out.write(localKey.getBytes());
            out.close();
            String value = "value" + localKey;
            out = writer.prepareAppendValue(-1);
            out.write(value.getBytes());
            out.close();
        }
        return start + n;
    }

    private int readPrepWithUnknownLength(TFile.Reader.Scanner scanner, int start, int n) throws IOException {
        for (int i = start; i < start; ++i) {
            String key = String.format(localFormatter, i);
            byte[] read = this.readKey(scanner);
            Assertions.assertTrue((boolean)Arrays.equals(key.getBytes(), read), (String)"keys not equal");
            try {
                read = this.readValue(scanner);
                Assertions.assertTrue((boolean)false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String value = "value" + key;
            read = this.readLongValue(scanner, value.getBytes().length);
            Assertions.assertTrue((boolean)Arrays.equals(read, value.getBytes()), (String)"values nto equal");
            scanner.advance();
        }
        return start + n;
    }

    private byte[] getSomeKey(int rowId) {
        return String.format(localFormatter, rowId).getBytes();
    }

    private void writeRecords(TFile.Writer writer) throws IOException {
        this.writeEmptyRecords(writer, 10);
        int ret = this.writeSomeRecords(writer, 0, 100);
        ret = this.writeLargeRecords(writer, ret, 1);
        ret = this.writePrepWithKnownLength(writer, ret, 40);
        ret = this.writePrepWithUnkownLength(writer, ret, 50);
        writer.close();
    }

    private void readAllRecords(TFile.Reader.Scanner scanner) throws IOException {
        this.readEmptyRecords(scanner, 10);
        int ret = this.readAndCheckbytes(scanner, 0, 100);
        ret = this.readLargeRecords(scanner, ret, 1);
        ret = this.readPrepWithKnownLength(scanner, ret, 40);
        ret = this.readPrepWithUnknownLength(scanner, ret, 50);
    }

    private FSDataOutputStream createFSOutput(Path name) throws IOException {
        if (this.fs.exists(name)) {
            this.fs.delete(name, true);
        }
        FSDataOutputStream fout = this.fs.create(name);
        return fout;
    }

    void basicWithSomeCodec(String codec) throws IOException {
        Path ncTFile = new Path(ROOT, "basic.tfile");
        FSDataOutputStream fout = this.createFSOutput(ncTFile);
        TFile.Writer writer = new TFile.Writer(fout, 512, codec, "memcmp", this.conf);
        this.writeRecords(writer);
        fout.close();
        FSDataInputStream fin = this.fs.open(ncTFile);
        TFile.Reader reader = new TFile.Reader(this.fs.open(ncTFile), this.fs.getFileStatus(ncTFile).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        this.readAllRecords(scanner);
        scanner.seekTo(this.getSomeKey(50));
        Assertions.assertTrue((boolean)scanner.seekTo(this.getSomeKey(50)), (String)"location lookup failed");
        byte[] readKey = this.readKey(scanner);
        Assertions.assertTrue((boolean)Arrays.equals(this.getSomeKey(50), readKey), (String)"seeked key does not match");
        scanner.seekTo(new byte[0]);
        byte[] val1 = this.readValue(scanner);
        scanner.seekTo(new byte[0]);
        byte[] val2 = this.readValue(scanner);
        Assertions.assertTrue((boolean)Arrays.equals(val1, val2));
        scanner.lowerBound(this.getSomeKey(50));
        Assertions.assertTrue((scanner.currentLocation.compareTo(reader.end()) < 0 ? 1 : 0) != 0, (String)"locaton lookup failed");
        readKey = this.readKey(scanner);
        Assertions.assertTrue((boolean)Arrays.equals(readKey, this.getSomeKey(50)), (String)"seeked key does not match");
        scanner.upperBound(this.getSomeKey(50));
        Assertions.assertTrue((scanner.currentLocation.compareTo(reader.end()) < 0 ? 1 : 0) != 0, (String)"location lookup failed");
        readKey = this.readKey(scanner);
        Assertions.assertTrue((boolean)Arrays.equals(readKey, this.getSomeKey(51)), (String)"seeked key does not match");
        scanner.close();
        scanner = reader.createScannerByKey(this.getSomeKey(10), this.getSomeKey(60));
        this.readAndCheckbytes(scanner, 10, 50);
        Assertions.assertFalse((boolean)scanner.advance());
        scanner.close();
        reader.close();
        fin.close();
        this.fs.delete(ncTFile, true);
    }

    void unsortedWithSomeCodec(String codec) throws IOException {
        Path uTfile = new Path(ROOT, "unsorted.tfile");
        FSDataOutputStream fout = this.createFSOutput(uTfile);
        TFile.Writer writer = new TFile.Writer(fout, 512, codec, null, this.conf);
        this.writeRecords(writer);
        writer.close();
        fout.close();
        FSDataInputStream fin = this.fs.open(uTfile);
        TFile.Reader reader = new TFile.Reader(this.fs.open(uTfile), this.fs.getFileStatus(uTfile).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        this.readAllRecords(scanner);
        scanner.close();
        reader.close();
        fin.close();
        this.fs.delete(uTfile, true);
    }

    @Test
    public void testTFileFeatures() throws IOException {
        this.basicWithSomeCodec("none");
        this.basicWithSomeCodec("gz");
    }

    @Test
    public void testUnsortedTFileFeatures() throws IOException {
        this.unsortedWithSomeCodec("none");
        this.unsortedWithSomeCodec("gz");
    }

    private void writeNumMetablocks(TFile.Writer writer, String compression, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            DataOutputStream dout = writer.prepareMetaBlock("TfileMeta" + i, compression);
            byte[] b = ("something to test" + i).getBytes();
            dout.write(b);
            dout.close();
        }
    }

    private void someTestingWithMetaBlock(TFile.Writer writer, String compression) throws IOException {
        DataOutputStream dout = null;
        this.writeNumMetablocks(writer, compression, 10);
        try {
            dout = writer.prepareMetaBlock("TfileMeta1", compression);
            Assertions.assertTrue((boolean)false);
        }
        catch (MetaBlockAlreadyExists metaBlockAlreadyExists) {
            // empty catch block
        }
        dout = writer.prepareMetaBlock("TFileMeta100", compression);
        dout.close();
    }

    private void readNumMetablocks(TFile.Reader reader, int n) throws IOException {
        int len = "something to test0".getBytes().length;
        for (int i = 0; i < n; ++i) {
            DataInputStream din = reader.getMetaBlock("TfileMeta" + i);
            byte[] b = new byte[len];
            din.readFully(b);
            Assertions.assertTrue((boolean)Arrays.equals(("something to test" + i).getBytes(), b), (String)"faield to match metadata");
            din.close();
        }
    }

    private void someReadingWithMetaBlock(TFile.Reader reader) throws IOException {
        DataInputStream din = null;
        this.readNumMetablocks(reader, 10);
        try {
            din = reader.getMetaBlock("NO ONE");
            Assertions.assertTrue((boolean)false);
        }
        catch (MetaBlockDoesNotExist metaBlockDoesNotExist) {
            // empty catch block
        }
        din = reader.getMetaBlock("TFileMeta100");
        int read = din.read();
        Assertions.assertTrue((read == -1 ? 1 : 0) != 0, (String)"check for status");
        din.close();
    }

    @Test
    public void testMetaBlocks() throws IOException {
        Path mFile = new Path(ROOT, "meta.tfile");
        FSDataOutputStream fout = this.createFSOutput(mFile);
        TFile.Writer writer = new TFile.Writer(fout, 512, "none", null, this.conf);
        this.someTestingWithMetaBlock(writer, "none");
        writer.close();
        fout.close();
        FSDataInputStream fin = this.fs.open(mFile);
        TFile.Reader reader = new TFile.Reader(fin, this.fs.getFileStatus(mFile).getLen(), this.conf);
        this.someReadingWithMetaBlock(reader);
        this.fs.delete(mFile, true);
        reader.close();
        fin.close();
    }
}

