/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestCompression {
    @BeforeAll
    public static void resetConfigBeforeAll() {
        Compression.Algorithm.conf.setBoolean("test.reload.lzo.codec", true);
    }

    @AfterAll
    public static void resetConfigAfterAll() {
        Compression.Algorithm.conf.setBoolean("test.reload.lzo.codec", false);
    }

    @Test
    public void testConfigureLZOCodec() throws IOException {
        String defaultCodec = "org.apache.hadoop.io.compress.DefaultCodec";
        Compression.Algorithm.conf.set("io.compression.codec.lzo.class", defaultCodec);
        Assertions.assertEquals((Object)defaultCodec, (Object)Compression.Algorithm.LZO.getCodec().getClass().getName());
    }

    @Test
    public void testMisconfiguredLZOCodec() throws Exception {
        String defaultCodec = "org.apache.hadoop.io.compress.InvalidLzoCodec";
        Compression.Algorithm.conf.set("io.compression.codec.lzo.class", defaultCodec);
        IOException ioEx = LambdaTestUtils.intercept(IOException.class, defaultCodec, () -> Compression.Algorithm.LZO.getCodec());
        if (!(ioEx.getCause() instanceof ClassNotFoundException)) {
            throw ioEx;
        }
    }
}

