/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.rawcoder.DummyRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.TestRawCoderBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDummyRawCoder
extends TestRawCoderBase {
    @BeforeEach
    public void setup() {
        this.encoderFactoryClass = DummyRawErasureCoderFactory.class;
        this.decoderFactoryClass = DummyRawErasureCoderFactory.class;
        this.setAllowDump(false);
        this.setChunkSize(this.baseChunkSize);
    }

    @Test
    public void testCoding_6x3_erasing_d0_d2() {
        this.prepare(null, 6, 3, new int[]{0, 2}, new int[0], false);
        this.testCodingDoMixed();
    }

    @Test
    public void testCoding_6x3_erasing_d0_p0() {
        this.prepare(null, 6, 3, new int[]{0}, new int[]{0}, false);
        this.testCodingDoMixed();
    }

    @Override
    protected void testCoding(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        this.prepareBufferAllocator(true);
        this.setAllowChangeInputs(false);
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        this.markChunks(dataChunks);
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        try {
            this.encoder.encode(dataChunks, parityChunks);
        }
        catch (IOException e) {
            Assertions.fail((String)("Unexpected IOException: " + e.getMessage()));
        }
        this.compareAndVerify(parityChunks, this.getEmptyChunks(parityChunks.length));
        this.restoreChunksFromMark(dataChunks);
        this.backupAndEraseChunks(dataChunks, parityChunks);
        ECChunk[] inputChunks = this.prepareInputChunksForDecoding(dataChunks, parityChunks);
        this.ensureOnlyLeastRequiredChunks(inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        try {
            this.decoder.decode(inputChunks, this.getErasedIndexesForDecoding(), recoveredChunks);
        }
        catch (IOException e) {
            Assertions.fail((String)("Unexpected IOException: " + e.getMessage()));
        }
        this.compareAndVerify(recoveredChunks, this.getEmptyChunks(recoveredChunks.length));
    }

    private ECChunk[] getEmptyChunks(int num) {
        ECChunk[] chunks = new ECChunk[num];
        for (int i = 0; i < chunks.length; ++i) {
            chunks[i] = new ECChunk(ByteBuffer.wrap(this.getZeroChunkBytes()));
        }
        return chunks;
    }
}

