/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.codec;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCodecOptions;
import org.apache.hadoop.io.erasurecode.codec.HHXORErasureCodec;
import org.apache.hadoop.io.erasurecode.coder.ErasureDecoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHHXORErasureCodec {
    private ECSchema schema = new ECSchema("hhxor", 10, 4);
    private ErasureCodecOptions options = new ErasureCodecOptions(this.schema);

    @Test
    public void testGoodCodec() {
        HHXORErasureCodec codec = new HHXORErasureCodec(new Configuration(), this.options);
        ErasureEncoder encoder = codec.createEncoder();
        Assertions.assertEquals((int)10, (int)encoder.getNumDataUnits());
        Assertions.assertEquals((int)4, (int)encoder.getNumParityUnits());
        ErasureDecoder decoder = codec.createDecoder();
        Assertions.assertEquals((int)10, (int)decoder.getNumDataUnits());
        Assertions.assertEquals((int)4, (int)decoder.getNumParityUnits());
    }
}

