/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import java.util.HashMap;
import java.util.TreeMap;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=300L)
public class TestECSchema {
    @Test
    public void testGoodSchema() {
        int numDataUnits = 6;
        int numParityUnits = 3;
        String codec = "rs";
        String extraOption = "extraOption";
        String extraOptionValue = "extraOptionValue";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("numDataUnits", String.valueOf(numDataUnits));
        options.put("numParityUnits", String.valueOf(numParityUnits));
        options.put("codec", codec);
        options.put(extraOption, extraOptionValue);
        ECSchema schema = new ECSchema(options);
        System.out.println(schema.toString());
        Assertions.assertEquals((int)numDataUnits, (int)schema.getNumDataUnits());
        Assertions.assertEquals((int)numParityUnits, (int)schema.getNumParityUnits());
        Assertions.assertEquals((Object)codec, (Object)schema.getCodecName());
        Assertions.assertEquals((Object)extraOptionValue, schema.getExtraOptions().get(extraOption));
        TreeMap<String, String> extraMap = new TreeMap<String, String>();
        extraMap.put(extraOption, extraOptionValue);
        ECSchema sameSchema = new ECSchema(codec, numDataUnits, numParityUnits, extraMap);
        Assertions.assertEquals((Object)sameSchema, (Object)schema, (String)"Different constructors not equal");
    }

    @Test
    public void testEqualsAndHashCode() {
        TreeMap<String, String> extraMap = new TreeMap<String, String>();
        extraMap.put("key", "value");
        ECSchema[] schemas = new ECSchema[]{new ECSchema("one", 1, 2, null), new ECSchema("two", 1, 2, null), new ECSchema("one", 2, 2, null), new ECSchema("one", 1, 1, null), new ECSchema("one", 1, 2, extraMap)};
        for (int i = 0; i < schemas.length; ++i) {
            ECSchema ei = schemas[i];
            ECSchema temp = new ECSchema(ei.getCodecName(), ei.getNumDataUnits(), ei.getNumParityUnits(), ei.getExtraOptions());
            Assertions.assertEquals((Object)ei, (Object)temp);
            Assertions.assertEquals((int)ei.hashCode(), (int)temp.hashCode());
            for (int j = 0; j < schemas.length; ++j) {
                ECSchema ej = schemas[j];
                if (i == j) {
                    Assertions.assertEquals((Object)ei, (Object)ej);
                    Assertions.assertEquals((int)ei.hashCode(), (int)ej.hashCode());
                    continue;
                }
                Assertions.assertNotEquals((Object)ei, (Object)ej);
                Assertions.assertNotEquals((Object)ei, (Object)ej.hashCode());
            }
        }
    }
}

