/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.snappy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.snappy.SnappyCompressor;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSnappyCompressorDecompressor {
    public static final Logger LOG = LoggerFactory.getLogger(TestSnappyCompressorDecompressor.class);

    @BeforeEach
    public void before() {
    }

    @Test
    public void testSnappyCompressorSetInputNullPointerException() {
        try {
            SnappyCompressor compressor = new SnappyCompressor();
            compressor.setInput(null, 0, 10);
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorSetInputNullPointerException error !!!");
        }
        catch (NullPointerException compressor) {
        }
        catch (Exception ex) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorSetInputNullPointerException ex error !!!");
        }
    }

    @Test
    public void testSnappyDecompressorSetInputNullPointerException() {
        try {
            SnappyDecompressor decompressor = new SnappyDecompressor();
            decompressor.setInput(null, 0, 10);
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyDecompressorSetInputNullPointerException error !!!");
        }
        catch (NullPointerException decompressor) {
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyDecompressorSetInputNullPointerException ex error !!!");
        }
    }

    @Test
    public void testSnappyCompressorSetInputAIOBException() {
        try {
            SnappyCompressor compressor = new SnappyCompressor();
            compressor.setInput(new byte[0], -5, 10);
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorSetInputAIOBException error !!!");
        }
        catch (ArrayIndexOutOfBoundsException compressor) {
        }
        catch (Exception ex) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorSetInputAIOBException ex error !!!");
        }
    }

    @Test
    public void testSnappyDecompressorSetInputAIOUBException() {
        try {
            SnappyDecompressor decompressor = new SnappyDecompressor();
            decompressor.setInput(new byte[0], -5, 10);
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyDecompressorSetInputAIOUBException error !!!");
        }
        catch (ArrayIndexOutOfBoundsException decompressor) {
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyDecompressorSetInputAIOUBException ex error !!!");
        }
    }

    @Test
    public void testSnappyCompressorCompressNullPointerException() {
        try {
            SnappyCompressor compressor = new SnappyCompressor();
            byte[] bytes = BytesGenerator.get(6144);
            compressor.setInput(bytes, 0, bytes.length);
            compressor.compress(null, 0, 0);
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorCompressNullPointerException error !!!");
        }
        catch (NullPointerException compressor) {
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorCompressNullPointerException ex error !!!");
        }
    }

    @Test
    public void testSnappyDecompressorCompressNullPointerException() {
        try {
            SnappyDecompressor decompressor = new SnappyDecompressor();
            byte[] bytes = BytesGenerator.get(6144);
            decompressor.setInput(bytes, 0, bytes.length);
            decompressor.decompress(null, 0, 0);
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyDecompressorCompressNullPointerException error !!!");
        }
        catch (NullPointerException decompressor) {
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyDecompressorCompressNullPointerException ex error !!!");
        }
    }

    @Test
    public void testSnappyCompressorCompressAIOBException() {
        try {
            SnappyCompressor compressor = new SnappyCompressor();
            byte[] bytes = BytesGenerator.get(6144);
            compressor.setInput(bytes, 0, bytes.length);
            compressor.compress(new byte[0], 0, -1);
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorCompressAIOBException error !!!");
        }
        catch (ArrayIndexOutOfBoundsException compressor) {
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorCompressAIOBException ex error !!!");
        }
    }

    @Test
    public void testSnappyDecompressorCompressAIOBException() {
        try {
            SnappyDecompressor decompressor = new SnappyDecompressor();
            byte[] bytes = BytesGenerator.get(6144);
            decompressor.setInput(bytes, 0, bytes.length);
            decompressor.decompress(new byte[0], 0, -1);
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyDecompressorCompressAIOBException error !!!");
        }
        catch (ArrayIndexOutOfBoundsException decompressor) {
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyDecompressorCompressAIOBException ex error !!!");
        }
    }

    @Test
    public void testSnappyCompressDecompress() throws Exception {
        int BYTE_SIZE = 55296;
        byte[] bytes = BytesGenerator.get(BYTE_SIZE);
        SnappyCompressor compressor = new SnappyCompressor();
        compressor.setInput(bytes, 0, bytes.length);
        org.junit.jupiter.api.Assertions.assertTrue((compressor.getBytesRead() > 0L ? 1 : 0) != 0, (String)"SnappyCompressDecompress getBytesRead error !!!");
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)compressor.getBytesWritten(), (String)"SnappyCompressDecompress getBytesWritten before compress error !!!");
        int maxSize = 32 + BYTE_SIZE + BYTE_SIZE / 6;
        byte[] compressed = new byte[maxSize];
        int cSize = compressor.compress(compressed, 0, compressed.length);
        LOG.info("input size: {}", (Object)BYTE_SIZE);
        LOG.info("compressed size: {}", (Object)cSize);
        org.junit.jupiter.api.Assertions.assertTrue((compressor.getBytesWritten() > 0L ? 1 : 0) != 0, (String)"SnappyCompressDecompress getBytesWritten after compress error !!!");
        SnappyDecompressor decompressor = new SnappyDecompressor();
        decompressor.setInput(compressed, 0, cSize);
        byte[] decompressed = new byte[BYTE_SIZE];
        decompressor.decompress(decompressed, 0, decompressed.length);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)decompressor.finished(), (String)"testSnappyCompressDecompress finished error !!!");
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])bytes, (byte[])decompressed);
        compressor.reset();
        decompressor.reset();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)decompressor.getRemaining(), (String)"decompressor getRemaining error !!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressorDecompressorEmptyStreamLogic() {
        ByteArrayInputStream bytesIn = null;
        ByteArrayOutputStream bytesOut = null;
        byte[] buf = null;
        BlockDecompressorStream blockDecompressorStream = null;
        try {
            bytesOut = new ByteArrayOutputStream();
            BlockCompressorStream blockCompressorStream = new BlockCompressorStream((OutputStream)bytesOut, (Compressor)new SnappyCompressor(), 1024, 0);
            blockCompressorStream.close();
            buf = bytesOut.toByteArray();
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)buf.length, (String)"empty stream compressed output size != 4");
            bytesIn = new ByteArrayInputStream(buf);
            blockDecompressorStream = new BlockDecompressorStream((InputStream)bytesIn, (Decompressor)new SnappyDecompressor(), 1024);
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)blockDecompressorStream.read(), (String)"return value is not -1");
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)("testCompressorDecompressorEmptyStreamLogic ex error !!!" + e.getMessage()));
        }
        finally {
            if (blockDecompressorStream != null) {
                try {
                    bytesIn.close();
                    bytesOut.close();
                    blockDecompressorStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Test
    public void testSnappyBlockCompression() {
        int BYTE_SIZE = 51200;
        int BLOCK_SIZE = 512;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] block = new byte[BLOCK_SIZE];
        byte[] bytes = BytesGenerator.get(BYTE_SIZE);
        try {
            SnappyCompressor compressor = new SnappyCompressor();
            int off = 0;
            int len = BYTE_SIZE;
            int maxSize = BLOCK_SIZE - 18;
            if (BYTE_SIZE > maxSize) {
                int bufLen;
                do {
                    bufLen = Math.min(len, maxSize);
                    compressor.setInput(bytes, off, bufLen);
                    compressor.finish();
                    while (!compressor.finished()) {
                        compressor.compress(block, 0, block.length);
                        out.write(block);
                    }
                    compressor.reset();
                    off += bufLen;
                } while ((len -= bufLen) > 0);
            }
            org.junit.jupiter.api.Assertions.assertTrue((out.toByteArray().length > 0 ? 1 : 0) != 0, (String)"testSnappyBlockCompression error !!!");
        }
        catch (Exception ex) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyBlockCompression ex error !!!");
        }
    }

    @Test
    public void testSnappyCompressDecompressWithSmallBuffer() throws Exception {
        int inputSize = 51200;
        int bufferSize = 512;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        byte[] input = BytesGenerator.get(inputSize);
        SnappyCompressor compressor = new SnappyCompressor();
        compressor.setInput(input, 0, inputSize);
        compressor.finish();
        while (!compressor.finished()) {
            int len = compressor.compress(buffer, 0, buffer.length);
            out.write(buffer, 0, len);
        }
        byte[] compressed = out.toByteArray();
        Assertions.assertThat((byte[])compressed).hasSizeGreaterThan(0);
        out.reset();
        SnappyDecompressor decompressor = new SnappyDecompressor();
        decompressor.setInput(compressed, 0, compressed.length);
        while (!decompressor.finished()) {
            int len = decompressor.decompress(buffer, 0, buffer.length);
            out.write(buffer, 0, len);
        }
        byte[] decompressed = out.toByteArray();
        Assertions.assertThat((byte[])decompressed).isEqualTo((Object)input);
    }

    private void compressDecompressLoop(int rawDataSize) throws IOException {
        byte[] rawData = BytesGenerator.get(rawDataSize);
        byte[] compressedResult = new byte[rawDataSize + 20];
        int directBufferSize = Math.max(rawDataSize * 2, 65536);
        SnappyCompressor compressor = new SnappyCompressor(directBufferSize);
        compressor.setInput(rawData, 0, rawDataSize);
        int compressedSize = compressor.compress(compressedResult, 0, compressedResult.length);
        SnappyDecompressor.SnappyDirectDecompressor decompressor = new SnappyDecompressor.SnappyDirectDecompressor();
        ByteBuffer inBuf = ByteBuffer.allocateDirect(compressedSize);
        ByteBuffer outBuf = ByteBuffer.allocateDirect(rawDataSize);
        inBuf.put(compressedResult, 0, compressedSize);
        inBuf.flip();
        ByteBuffer expected = ByteBuffer.wrap(rawData);
        outBuf.clear();
        while (!decompressor.finished()) {
            decompressor.decompress(inBuf, outBuf);
            if (outBuf.remaining() != 0) continue;
            outBuf.flip();
            while (outBuf.remaining() > 0) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expected.get(), (byte)outBuf.get());
            }
            outBuf.clear();
        }
        outBuf.flip();
        while (outBuf.remaining() > 0) {
            org.junit.jupiter.api.Assertions.assertEquals((byte)expected.get(), (byte)outBuf.get());
        }
        outBuf.clear();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expected.remaining());
    }

    @Test
    public void testSnappyDirectBlockCompression() {
        int[] size = new int[]{4096, 65536, 131072, 0x100000};
        try {
            for (int i = 0; i < size.length; ++i) {
                this.compressDecompressLoop(size[i]);
            }
        }
        catch (IOException ex) {
            org.junit.jupiter.api.Assertions.fail((String)("testSnappyDirectBlockCompression ex !!!" + ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnappyCompressorDecopressorLogicWithCompressionStreams() {
        int BYTE_SIZE = 102400;
        byte[] bytes = BytesGenerator.get(BYTE_SIZE);
        int bufferSize = 262144;
        int compressionOverhead = bufferSize / 6 + 32;
        FilterOutputStream deflateOut = null;
        FilterInputStream inflateIn = null;
        try {
            DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
            BlockCompressorStream deflateFilter = new BlockCompressorStream((OutputStream)compressedDataBuffer, (Compressor)new SnappyCompressor(bufferSize), bufferSize, compressionOverhead);
            deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));
            ((DataOutputStream)deflateOut).write(bytes, 0, bytes.length);
            ((DataOutputStream)deflateOut).flush();
            deflateFilter.finish();
            DataInputBuffer deCompressedDataBuffer = new DataInputBuffer();
            deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
            BlockDecompressorStream inflateFilter = new BlockDecompressorStream((InputStream)deCompressedDataBuffer, (Decompressor)new SnappyDecompressor(bufferSize), bufferSize);
            inflateIn = new DataInputStream(new BufferedInputStream((InputStream)inflateFilter));
            byte[] result = new byte[BYTE_SIZE];
            ((DataInputStream)inflateIn).read(result);
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])result, (byte[])bytes, (String)"original array not equals compress/decompressed array");
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"testSnappyCompressorDecopressorLogicWithCompressionStreams ex error !!!");
        }
        finally {
            try {
                if (deflateOut != null) {
                    deflateOut.close();
                }
                if (inflateIn != null) {
                    inflateIn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testSnappyCompressDecompressInMultiThreads() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        for (int i = 0; i < 10; ++i) {
            ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

                @Override
                public void doWork() throws Exception {
                    TestSnappyCompressorDecompressor.this.testSnappyCompressDecompress();
                }
            });
        }
        ctx.startThreads();
        ctx.waitFor(60000L);
    }

    @Test
    public void testSnappyCompatibility() throws Exception {
        String rawData = "010a06030a040a0c0109020c0a010204020d02000b010701080605080b090902060a080502060a0d06070908080a0c0105030904090d05090800040c090c0d0d0804000d00040b0b0d010d060907020a030a0c0900040905080107040d0c01060a0b09070a04000b01040b09000e0e00020b06050b060e030e0a07050d06050d";
        String compressed = "8001f07f010a06030a040a0c0109020c0a010204020d02000b010701080605080b090902060a080502060a0d06070908080a0c0105030904090d05090800040c090c0d0d0804000d00040b0b0d010d060907020a030a0c0900040905080107040d0c01060a0b09070a04000b01040b09000e0e00020b06050b060e030e0a07050d06050d";
        byte[] rawDataBytes = Hex.decodeHex((String)rawData);
        byte[] compressedBytes = Hex.decodeHex((String)compressed);
        ByteBuffer inBuf = ByteBuffer.allocateDirect(compressedBytes.length);
        inBuf.put(compressedBytes, 0, compressedBytes.length);
        inBuf.flip();
        ByteBuffer outBuf = ByteBuffer.allocateDirect(rawDataBytes.length);
        ByteBuffer expected = ByteBuffer.wrap(rawDataBytes);
        SnappyDecompressor.SnappyDirectDecompressor decompressor = new SnappyDecompressor.SnappyDirectDecompressor();
        outBuf.clear();
        while (!decompressor.finished()) {
            decompressor.decompress(inBuf, outBuf);
            if (outBuf.remaining() != 0) continue;
            outBuf.flip();
            while (outBuf.remaining() > 0) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expected.get(), (byte)outBuf.get());
            }
            outBuf.clear();
        }
        outBuf.flip();
        while (outBuf.remaining() > 0) {
            org.junit.jupiter.api.Assertions.assertEquals((byte)expected.get(), (byte)outBuf.get());
        }
        outBuf.clear();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)expected.remaining());
    }

    static final class BytesGenerator {
        private static final byte[] CACHE = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        private static final Random rnd = new Random(12345L);

        private BytesGenerator() {
        }

        public static byte[] get(int size) {
            byte[] array = (byte[])Array.newInstance(Byte.TYPE, size);
            for (int i = 0; i < size; ++i) {
                array[i] = CACHE[rnd.nextInt(CACHE.length - 1)];
            }
            return array;
        }
    }
}

