/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.GzipCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGzipCodec {
    private static final Logger LOG = LoggerFactory.getLogger(TestGzipCodec.class);
    private static final String DATA1 = "Dogs don't know it's not bacon!\n";
    private static final String DATA2 = "It's baconnnn!!\n";
    private GzipCodec codec = new GzipCodec();

    @BeforeEach
    public void setUp() {
        this.codec.setConf(new Configuration(false));
    }

    @Test
    public void testSingleCompress() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressionOutputStream cmpOut = this.codec.createOutputStream((OutputStream)baos);
        cmpOut.write(DATA1.getBytes(StandardCharsets.UTF_8));
        cmpOut.finish();
        cmpOut.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        GZIPInputStream cmpIn = new GZIPInputStream(bais);
        byte[] buf = new byte[1024];
        int len = cmpIn.read(buf);
        String result = new String(buf, 0, len, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)DATA1, (Object)result, (String)"Input must match output");
    }

    @Test
    public void testResetCompress() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        CompressionOutputStream cmpOut = this.codec.createOutputStream((OutputStream)dob);
        cmpOut.write(DATA1.getBytes(StandardCharsets.UTF_8));
        cmpOut.finish();
        cmpOut.resetState();
        cmpOut.write(DATA2.getBytes(StandardCharsets.UTF_8));
        cmpOut.finish();
        cmpOut.close();
        dob.close();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        CompressionInputStream cmpIn = this.codec.createInputStream((InputStream)dib);
        byte[] buf = new byte[1024];
        StringBuilder result = new StringBuilder();
        int len = 0;
        while ((len = cmpIn.read(buf)) >= 0) {
            result.append(new String(buf, 0, len, StandardCharsets.UTF_8));
        }
        Assertions.assertEquals((Object)"Dogs don't know it's not bacon!\nIt's baconnnn!!\n", (Object)result.toString(), (String)"Output must match input");
    }

    @Test
    public void testWriteOverride() throws IOException {
        Random r = new Random();
        long seed = r.nextLong();
        LOG.info("seed: " + seed);
        r.setSeed(seed);
        byte[] buf = new byte[128];
        r.nextBytes(buf);
        DataOutputBuffer dob = new DataOutputBuffer();
        CompressionOutputStream cmpOut = this.codec.createOutputStream((OutputStream)dob);
        cmpOut.write(buf);
        int i = r.nextInt(118);
        int l = r.nextInt(128 - i);
        cmpOut.write(buf, i, l);
        cmpOut.write((int)((byte)(r.nextInt() & 0xFF)));
        cmpOut.close();
        r.setSeed(seed);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        CompressionInputStream cmpIn = this.codec.createInputStream((InputStream)dib);
        byte[] vbuf = new byte[128];
        Assertions.assertEquals((int)128, (int)cmpIn.read(vbuf));
        Assertions.assertArrayEquals((byte[])buf, (byte[])vbuf);
        r.nextBytes(vbuf);
        int vi = r.nextInt(118);
        int vl = r.nextInt(128 - vi);
        Assertions.assertEquals((int)vl, (int)cmpIn.read(vbuf, 0, vl));
        Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(buf, i, i + l), (byte[])Arrays.copyOf(vbuf, vl));
        Assertions.assertEquals((int)(r.nextInt() & 0xFF), (int)cmpIn.read());
        Assertions.assertEquals((int)-1, (int)cmpIn.read());
    }

    @Test
    public void testIdempotentResetState() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        CompressionOutputStream cmpOut = this.codec.createOutputStream((OutputStream)dob);
        cmpOut.write(DATA1.getBytes(StandardCharsets.UTF_8));
        cmpOut.finish();
        cmpOut.finish();
        cmpOut.finish();
        cmpOut.resetState();
        cmpOut.resetState();
        cmpOut.finish();
        cmpOut.resetState();
        cmpOut.close();
        dob.close();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        CompressionInputStream cmpIn = this.codec.createInputStream((InputStream)dib);
        byte[] buf = new byte[1024];
        StringBuilder result = new StringBuilder();
        int len = 0;
        while ((len = cmpIn.read(buf)) >= 0) {
            result.append(new String(buf, 0, len, StandardCharsets.UTF_8));
        }
        Assertions.assertEquals((Object)DATA1, (Object)result.toString(), (String)"Output must match input");
    }
}

