/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.util.Random;
import org.apache.hadoop.io.compress.CompressDecompressTester;
import org.apache.hadoop.io.compress.lz4.Lz4Compressor;
import org.apache.hadoop.io.compress.lz4.Lz4Decompressor;
import org.apache.hadoop.io.compress.snappy.SnappyCompressor;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibInflater;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.junit.jupiter.api.Test;

public class TestCompressorDecompressor {
    private static final Random rnd = new Random(12345L);

    @Test
    public void testCompressorDecompressor() {
        int SIZE = 45056;
        byte[] rawData = TestCompressorDecompressor.generate(SIZE);
        try {
            CompressDecompressTester.of(rawData).withCompressDecompressPair(new SnappyCompressor(), new SnappyDecompressor()).withCompressDecompressPair((SnappyCompressor)new Lz4Compressor(), (SnappyDecompressor)new Lz4Decompressor()).withCompressDecompressPair((SnappyCompressor)new BuiltInZlibDeflater(), (SnappyDecompressor)new BuiltInZlibInflater()).withTestCases((ImmutableSet<CompressDecompressTester.CompressionTestStrategy>)ImmutableSet.of((Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_SINGLE_BLOCK), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_BLOCK), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_ERRORS), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM))).test();
        }
        catch (Exception ex) {
            GenericTestUtils.assertExceptionContains("testCompressorDecompressor error !!!", ex);
        }
    }

    @Test
    public void testCompressorDecompressorWithExceedBufferLimit() {
        int byteSize = 102400;
        int bufferSize = 65536;
        byte[] rawData = TestCompressorDecompressor.generate(102400);
        try {
            CompressDecompressTester.of(rawData).withCompressDecompressPair(new SnappyCompressor(65536), new SnappyDecompressor(65536)).withCompressDecompressPair((SnappyCompressor)new Lz4Compressor(65536), (SnappyDecompressor)new Lz4Decompressor(65536)).withTestCases((ImmutableSet<CompressDecompressTester.CompressionTestStrategy>)ImmutableSet.of((Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_BLOCK), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_ERRORS), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM))).test();
        }
        catch (Exception ex) {
            GenericTestUtils.assertExceptionContains("testCompressorDecompressorWithExeedBufferLimit error !!!", ex);
        }
    }

    public static byte[] generate(int size) {
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (byte)rnd.nextInt(16);
        }
        return array;
    }
}

