/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.WeakReferencedElasticByteBufferPool;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMoreWeakReferencedElasticByteBufferPool
extends HadoopTestBase {
    @Test
    public void testMixedBuffersInPool() {
        WeakReferencedElasticByteBufferPool pool = new WeakReferencedElasticByteBufferPool();
        ByteBuffer buffer1 = pool.getBuffer(true, 5);
        ByteBuffer buffer2 = pool.getBuffer(true, 10);
        ByteBuffer buffer3 = pool.getBuffer(false, 5);
        ByteBuffer buffer4 = pool.getBuffer(false, 10);
        ByteBuffer buffer5 = pool.getBuffer(true, 15);
        this.assertBufferCounts(pool, 0, 0);
        pool.putBuffer(buffer1);
        pool.putBuffer(buffer2);
        this.assertBufferCounts(pool, 2, 0);
        pool.putBuffer(buffer3);
        this.assertBufferCounts(pool, 2, 1);
        pool.putBuffer(buffer5);
        this.assertBufferCounts(pool, 3, 1);
        pool.putBuffer(buffer4);
        this.assertBufferCounts(pool, 3, 2);
        pool.release();
        this.assertBufferCounts(pool, 0, 0);
    }

    @Test
    public void testUnexpectedBufferSizes() throws Exception {
        WeakReferencedElasticByteBufferPool pool = new WeakReferencedElasticByteBufferPool();
        ByteBuffer buffer1 = pool.getBuffer(true, 0);
        LambdaTestUtils.intercept(BufferOverflowException.class, () -> buffer1.put(new byte[1]));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> pool.getBuffer(true, -5));
        LambdaTestUtils.intercept(NullPointerException.class, () -> pool.putBuffer(null));
    }

    private void assertBufferCounts(WeakReferencedElasticByteBufferPool pool, int numDirectBuffersExpected, int numHeapBuffersExpected) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(true)).describedAs("Number of direct buffers in pool", new Object[0])).isEqualTo(numDirectBuffersExpected);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(false)).describedAs("Number of heap buffers in pool", new Object[0])).isEqualTo(numHeapBuffersExpected);
    }
}

