/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.FenceMethod;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestNodeFencer {
    private HAServiceTarget MOCK_TARGET;
    private static String FENCER_TRUE_COMMAND_UNIX = "shell(true)";
    private static String FENCER_TRUE_COMMAND_WINDOWS = "shell(rem)";

    @BeforeEach
    public void clearMockState() {
        AlwaysSucceedFencer.fenceCalled = 0;
        AlwaysSucceedFencer.callArgs.clear();
        AlwaysFailFencer.fenceCalled = 0;
        AlwaysFailFencer.callArgs.clear();
        this.MOCK_TARGET = (HAServiceTarget)Mockito.mock(HAServiceTarget.class);
        ((HAServiceTarget)Mockito.doReturn((Object)"my mock").when((Object)this.MOCK_TARGET)).toString();
        ((HAServiceTarget)Mockito.doReturn((Object)new InetSocketAddress("host", 1234)).when((Object)this.MOCK_TARGET)).getAddress();
    }

    private static String getFencerTrueCommand() {
        return Shell.WINDOWS ? FENCER_TRUE_COMMAND_WINDOWS : FENCER_TRUE_COMMAND_UNIX;
    }

    @Test
    public void testSingleFencer() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer(AlwaysSucceedFencer.class.getName() + "(foo)");
        Assertions.assertTrue((boolean)fencer.fence(this.MOCK_TARGET));
        Assertions.assertEquals((int)1, (int)AlwaysSucceedFencer.fenceCalled);
        Assertions.assertSame((Object)this.MOCK_TARGET, (Object)AlwaysSucceedFencer.fencedSvc);
        Assertions.assertEquals((Object)"foo", (Object)AlwaysSucceedFencer.callArgs.get(0));
    }

    @Test
    public void testMultipleFencers() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer(AlwaysSucceedFencer.class.getName() + "(foo)\n" + AlwaysSucceedFencer.class.getName() + "(bar)\n");
        Assertions.assertTrue((boolean)fencer.fence(this.MOCK_TARGET));
        Assertions.assertEquals((int)1, (int)AlwaysSucceedFencer.fenceCalled);
        Assertions.assertEquals((Object)"foo", (Object)AlwaysSucceedFencer.callArgs.get(0));
    }

    @Test
    public void testWhitespaceAndCommentsInConfig() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer("\n # the next one will always fail\n " + AlwaysFailFencer.class.getName() + "(foo) # <- fails\n" + AlwaysSucceedFencer.class.getName() + "(bar) \n");
        Assertions.assertTrue((boolean)fencer.fence(this.MOCK_TARGET));
        Assertions.assertEquals((int)1, (int)AlwaysFailFencer.fenceCalled);
        Assertions.assertSame((Object)this.MOCK_TARGET, (Object)AlwaysFailFencer.fencedSvc);
        Assertions.assertEquals((int)1, (int)AlwaysSucceedFencer.fenceCalled);
        Assertions.assertSame((Object)this.MOCK_TARGET, (Object)AlwaysSucceedFencer.fencedSvc);
        Assertions.assertEquals((Object)"foo", (Object)AlwaysFailFencer.callArgs.get(0));
        Assertions.assertEquals((Object)"bar", (Object)AlwaysSucceedFencer.callArgs.get(0));
    }

    @Test
    public void testArglessFencer() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer(AlwaysSucceedFencer.class.getName());
        Assertions.assertTrue((boolean)fencer.fence(this.MOCK_TARGET));
        Assertions.assertEquals((int)1, (int)AlwaysSucceedFencer.fenceCalled);
        Assertions.assertSame((Object)this.MOCK_TARGET, (Object)AlwaysSucceedFencer.fencedSvc);
        Assertions.assertEquals(null, (Object)AlwaysSucceedFencer.callArgs.get(0));
    }

    @Test
    public void testShortNameShell() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer(TestNodeFencer.getFencerTrueCommand());
        Assertions.assertTrue((boolean)fencer.fence(this.MOCK_TARGET));
    }

    @Test
    public void testShortNameSsh() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer("sshfence");
        Assertions.assertFalse((boolean)fencer.fence(this.MOCK_TARGET));
    }

    @Test
    public void testShortNameSshWithUser() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer("sshfence(user)");
        Assertions.assertFalse((boolean)fencer.fence(this.MOCK_TARGET));
    }

    @Test
    public void testShortNameSshWithPort() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer("sshfence(:123)");
        Assertions.assertFalse((boolean)fencer.fence(this.MOCK_TARGET));
    }

    @Test
    public void testShortNameSshWithUserPort() throws BadFencingConfigurationException {
        NodeFencer fencer = TestNodeFencer.setupFencer("sshfence(user:123)");
        Assertions.assertFalse((boolean)fencer.fence(this.MOCK_TARGET));
    }

    public static NodeFencer setupFencer(String confStr) throws BadFencingConfigurationException {
        System.err.println("Testing configuration:\n" + confStr);
        Configuration conf = new Configuration();
        return new NodeFencer(conf, confStr);
    }

    public static class AlwaysFailFencer
    extends Configured
    implements FenceMethod {
        static int fenceCalled = 0;
        static HAServiceTarget fencedSvc;
        static List<String> callArgs;

        public boolean tryFence(HAServiceTarget target, String args) {
            fencedSvc = target;
            callArgs.add(args);
            ++fenceCalled;
            return false;
        }

        public void checkArgs(String args) {
        }

        static {
            callArgs = Lists.newArrayList();
        }
    }

    public static class AlwaysSucceedFencer
    extends Configured
    implements FenceMethod {
        static int fenceCalled = 0;
        static HAServiceTarget fencedSvc;
        static List<String> callArgs;

        public boolean tryFence(HAServiceTarget target, String args) {
            fencedSvc = target;
            callArgs.add(args);
            ++fenceCalled;
            return true;
        }

        public void checkArgs(String args) {
        }

        public static HAServiceTarget getLastFencedService() {
            return fencedSvc;
        }

        static {
            callArgs = Lists.newArrayList();
        }
    }
}

