/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.ActiveStandbyElectorTestUtil;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Ints;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.AdditionalMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.event.Level;

public class TestActiveStandbyElectorRealZK
extends ClientBaseWithFixes {
    static final int NUM_ELECTORS = 2;
    static final String PARENT_DIR;
    ActiveStandbyElector[] electors = new ActiveStandbyElector[2];
    private byte[][] appDatas = new byte[2][];
    private ActiveStandbyElector.ActiveStandbyElectorCallback[] cbs = new ActiveStandbyElector.ActiveStandbyElectorCallback[2];
    private ZooKeeperServer zkServer;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.zkServer = TestActiveStandbyElectorRealZK.getServer(this.serverFactory);
        for (int i = 0; i < 2; ++i) {
            this.cbs[i] = (ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.mock(ActiveStandbyElector.ActiveStandbyElectorCallback.class);
            this.appDatas[i] = Ints.toByteArray((int)i);
            this.electors[i] = new ActiveStandbyElector(this.hostPort, 5000, PARENT_DIR, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, Collections.emptyList(), this.cbs[i], 3, null);
        }
    }

    private void checkFatalsAndReset() throws Exception {
        for (int i = 0; i < 2; ++i) {
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[i], (VerificationMode)Mockito.never())).notifyFatalError(Mockito.anyString());
            Mockito.reset((Object[])new ActiveStandbyElector.ActiveStandbyElectorCallback[]{this.cbs[i]});
        }
    }

    @Test
    @Timeout(value=20L)
    public void testActiveStandbyTransition() throws Exception {
        LOG.info("starting test with parentDir:" + PARENT_DIR);
        Assertions.assertFalse((boolean)this.electors[0].parentZNodeExists());
        this.electors[0].ensureParentZNode();
        Assertions.assertTrue((boolean)this.electors[0].parentZNodeExists());
        this.electors[0].joinElection(this.appDatas[0]);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, this.zkServer, PARENT_DIR, this.appDatas[0]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((long)1000L))).becomeActive();
        this.checkFatalsAndReset();
        this.electors[1].joinElection(this.appDatas[1]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((long)1000L))).becomeStandby();
        this.checkFatalsAndReset();
        this.electors[0].quitElection(true);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, this.zkServer, PARENT_DIR, this.appDatas[1]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((long)1000L))).becomeActive();
        this.checkFatalsAndReset();
        this.electors[0].joinElection(this.appDatas[0]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((long)1000L))).becomeStandby();
        this.checkFatalsAndReset();
        this.electors[1].preventSessionReestablishmentForTests();
        try {
            this.zkServer.closeSession(this.electors[1].getZKSessionIdForTests());
            ActiveStandbyElectorTestUtil.waitForActiveLockData(null, this.zkServer, PARENT_DIR, this.appDatas[0]);
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((long)1000L))).enterNeutralMode();
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((long)1000L))).fenceOldActive(AdditionalMatchers.aryEq((byte[])this.appDatas[1]));
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((long)1000L))).becomeActive();
        }
        finally {
            this.electors[1].allowSessionReestablishmentForTests();
        }
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((long)5000L))).becomeStandby();
        this.checkFatalsAndReset();
        this.electors[0].preventSessionReestablishmentForTests();
        try {
            this.zkServer.closeSession(this.electors[0].getZKSessionIdForTests());
            ActiveStandbyElectorTestUtil.waitForActiveLockData(null, this.zkServer, PARENT_DIR, this.appDatas[1]);
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((long)1000L))).enterNeutralMode();
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((long)1000L))).fenceOldActive(AdditionalMatchers.aryEq((byte[])this.appDatas[0]));
            ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((long)1000L))).becomeActive();
        }
        finally {
            this.electors[0].allowSessionReestablishmentForTests();
        }
        this.checkFatalsAndReset();
    }

    @Test
    @Timeout(value=15L)
    public void testHandleSessionExpiration() throws Exception {
        ActiveStandbyElector.ActiveStandbyElectorCallback cb = this.cbs[0];
        byte[] appData = this.appDatas[0];
        ActiveStandbyElector elector = this.electors[0];
        elector.ensureParentZNode();
        elector.joinElection(appData);
        ZooKeeperServer zks = TestActiveStandbyElectorRealZK.getServer(this.serverFactory);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, appData);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)cb, (VerificationMode)Mockito.timeout((long)1000L))).becomeActive();
        this.checkFatalsAndReset();
        LOG.info("========================== Expiring session");
        zks.closeSession(elector.getZKSessionIdForTests());
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)cb, (VerificationMode)Mockito.timeout((long)1000L))).enterNeutralMode();
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, appData);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)cb, (VerificationMode)Mockito.timeout((long)1000L))).becomeActive();
        this.checkFatalsAndReset();
        LOG.info("========================== Quitting election");
        elector.quitElection(false);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, null);
        Thread.sleep(1000L);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)cb, (VerificationMode)Mockito.never())).becomeActive();
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, null);
        this.checkFatalsAndReset();
    }

    @Test
    @Timeout(value=15L)
    public void testHandleSessionExpirationOfStandby() throws Exception {
        this.electors[0].ensureParentZNode();
        this.electors[0].joinElection(this.appDatas[0]);
        ZooKeeperServer zks = TestActiveStandbyElectorRealZK.getServer(this.serverFactory);
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, this.appDatas[0]);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.timeout((long)1000L))).becomeActive();
        this.checkFatalsAndReset();
        this.electors[1].joinElection(this.appDatas[1]);
        ActiveStandbyElectorTestUtil.waitForElectorState(null, this.electors[1], ActiveStandbyElector.State.STANDBY);
        LOG.info("========================== Expiring standby's session");
        zks.closeSession(this.electors[1].getZKSessionIdForTests());
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.timeout((long)1000L))).enterNeutralMode();
        ActiveStandbyElectorTestUtil.waitForElectorState(null, this.electors[1], ActiveStandbyElector.State.STANDBY);
        this.checkFatalsAndReset();
        LOG.info("========================== Quitting election");
        this.electors[1].quitElection(false);
        this.electors[0].quitElection(false);
        Thread.sleep(1000L);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.never())).becomeActive();
        ActiveStandbyElectorTestUtil.waitForActiveLockData(null, zks, PARENT_DIR, null);
        this.checkFatalsAndReset();
    }

    @Test
    @Timeout(value=15L)
    public void testDontJoinElectionOnDisconnectAndReconnect() throws Exception {
        this.electors[0].ensureParentZNode();
        this.stopServer();
        ActiveStandbyElectorTestUtil.waitForElectorState(null, this.electors[0], ActiveStandbyElector.State.NEUTRAL);
        this.startServer();
        TestActiveStandbyElectorRealZK.waitForServerUp(this.hostPort, CONNECTION_TIMEOUT);
        Thread.sleep(2000L);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[0], (VerificationMode)Mockito.never())).becomeActive();
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.cbs[1], (VerificationMode)Mockito.never())).becomeActive();
        this.checkFatalsAndReset();
    }

    @Test
    @Timeout(value=15L)
    public void testSetZooKeeperACLsOnParentZnodeName() throws Exception {
        ActiveStandbyElector.ActiveStandbyElectorCallback cb = (ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.mock(ActiveStandbyElector.ActiveStandbyElectorCallback.class);
        ActiveStandbyElector elector = new ActiveStandbyElector(this.hostPort, 5000, PARENT_DIR, (List)ZooDefs.Ids.READ_ACL_UNSAFE, Collections.emptyList(), cb, 3, null);
        TestableZooKeeper otherClient = this.createClient();
        otherClient.create(PARENT_DIR, "sample1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        otherClient.setData(PARENT_DIR, "sample2".getBytes(), -1);
        otherClient.close();
        elector.ensureParentZNode();
    }

    static {
        GenericTestUtils.setLogLevel(ActiveStandbyElector.LOG, Level.TRACE);
        PARENT_DIR = "/" + UUID.randomUUID();
    }
}

