/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestAcl {
    private static AclEntry ENTRY1;
    private static AclEntry ENTRY2;
    private static AclEntry ENTRY3;
    private static AclEntry ENTRY4;
    private static AclEntry ENTRY5;
    private static AclEntry ENTRY6;
    private static AclEntry ENTRY7;
    private static AclEntry ENTRY8;
    private static AclEntry ENTRY9;
    private static AclEntry ENTRY10;
    private static AclEntry ENTRY11;
    private static AclEntry ENTRY12;
    private static AclEntry ENTRY13;
    private static AclStatus STATUS1;
    private static AclStatus STATUS2;
    private static AclStatus STATUS3;
    private static AclStatus STATUS4;

    @BeforeAll
    public static void setUp() {
        AclEntry.Builder aclEntryBuilder = new AclEntry.Builder().setType(AclEntryType.USER).setName("user1").setPermission(FsAction.ALL);
        ENTRY1 = aclEntryBuilder.build();
        ENTRY2 = aclEntryBuilder.build();
        ENTRY3 = new AclEntry.Builder().setType(AclEntryType.GROUP).setName("group2").setPermission(FsAction.READ_WRITE).build();
        ENTRY4 = new AclEntry.Builder().setType(AclEntryType.OTHER).setPermission(FsAction.NONE).setScope(AclEntryScope.DEFAULT).build();
        ENTRY5 = new AclEntry.Builder().setType(AclEntryType.USER).setPermission(FsAction.ALL).build();
        ENTRY6 = new AclEntry.Builder().setType(AclEntryType.GROUP).setName("group3").setPermission(FsAction.READ_WRITE).setScope(AclEntryScope.DEFAULT).build();
        ENTRY7 = new AclEntry.Builder().setType(AclEntryType.OTHER).setPermission(FsAction.NONE).build();
        ENTRY8 = new AclEntry.Builder().setType(AclEntryType.USER).setName("user3").setPermission(FsAction.ALL).setScope(AclEntryScope.DEFAULT).build();
        ENTRY9 = new AclEntry.Builder().setType(AclEntryType.MASK).setPermission(FsAction.READ).build();
        ENTRY10 = new AclEntry.Builder().setType(AclEntryType.MASK).setPermission(FsAction.READ_EXECUTE).setScope(AclEntryScope.DEFAULT).build();
        ENTRY11 = new AclEntry.Builder().setType(AclEntryType.GROUP).setPermission(FsAction.READ).build();
        ENTRY12 = new AclEntry.Builder().setType(AclEntryType.GROUP).setPermission(FsAction.READ).setScope(AclEntryScope.DEFAULT).build();
        ENTRY13 = new AclEntry.Builder().setType(AclEntryType.USER).setPermission(FsAction.ALL).setScope(AclEntryScope.DEFAULT).build();
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder().owner("owner1").group("group1").addEntry(ENTRY1).addEntry(ENTRY3).addEntry(ENTRY4);
        STATUS1 = aclStatusBuilder.build();
        STATUS2 = aclStatusBuilder.build();
        STATUS3 = new AclStatus.Builder().owner("owner2").group("group2").stickyBit(true).build();
        STATUS4 = new AclStatus.Builder().addEntry(ENTRY1).addEntry(ENTRY3).addEntry(ENTRY4).addEntry(ENTRY5).addEntry(ENTRY6).addEntry(ENTRY7).addEntry(ENTRY8).addEntry(ENTRY9).addEntry(ENTRY10).addEntry(ENTRY11).addEntry(ENTRY12).addEntry(ENTRY13).build();
    }

    @Test
    public void testEntryEquals() {
        Assertions.assertNotSame((Object)ENTRY1, (Object)ENTRY2);
        Assertions.assertNotSame((Object)ENTRY1, (Object)ENTRY3);
        Assertions.assertNotSame((Object)ENTRY1, (Object)ENTRY4);
        Assertions.assertNotSame((Object)ENTRY2, (Object)ENTRY3);
        Assertions.assertNotSame((Object)ENTRY2, (Object)ENTRY4);
        Assertions.assertNotSame((Object)ENTRY3, (Object)ENTRY4);
        Assertions.assertEquals((Object)ENTRY1, (Object)ENTRY1);
        Assertions.assertEquals((Object)ENTRY2, (Object)ENTRY2);
        Assertions.assertEquals((Object)ENTRY1, (Object)ENTRY2);
        Assertions.assertEquals((Object)ENTRY2, (Object)ENTRY1);
        Assertions.assertFalse((boolean)ENTRY1.equals((Object)ENTRY3));
        Assertions.assertFalse((boolean)ENTRY1.equals((Object)ENTRY4));
        Assertions.assertFalse((boolean)ENTRY3.equals((Object)ENTRY4));
        Assertions.assertFalse((boolean)ENTRY1.equals(null));
        Assertions.assertFalse((boolean)ENTRY1.equals(new Object()));
    }

    @Test
    public void testEntryHashCode() {
        Assertions.assertEquals((int)ENTRY1.hashCode(), (int)ENTRY2.hashCode());
        Assertions.assertFalse((ENTRY1.hashCode() == ENTRY3.hashCode() ? 1 : 0) != 0);
        Assertions.assertFalse((ENTRY1.hashCode() == ENTRY4.hashCode() ? 1 : 0) != 0);
        Assertions.assertFalse((ENTRY3.hashCode() == ENTRY4.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEntryScopeIsAccessIfUnspecified() {
        Assertions.assertEquals((Object)AclEntryScope.ACCESS, (Object)ENTRY1.getScope());
        Assertions.assertEquals((Object)AclEntryScope.ACCESS, (Object)ENTRY2.getScope());
        Assertions.assertEquals((Object)AclEntryScope.ACCESS, (Object)ENTRY3.getScope());
        Assertions.assertEquals((Object)AclEntryScope.DEFAULT, (Object)ENTRY4.getScope());
    }

    @Test
    public void testStatusEquals() {
        Assertions.assertNotSame((Object)STATUS1, (Object)STATUS2);
        Assertions.assertNotSame((Object)STATUS1, (Object)STATUS3);
        Assertions.assertNotSame((Object)STATUS2, (Object)STATUS3);
        Assertions.assertEquals((Object)STATUS1, (Object)STATUS1);
        Assertions.assertEquals((Object)STATUS2, (Object)STATUS2);
        Assertions.assertEquals((Object)STATUS1, (Object)STATUS2);
        Assertions.assertEquals((Object)STATUS2, (Object)STATUS1);
        Assertions.assertFalse((boolean)STATUS1.equals((Object)STATUS3));
        Assertions.assertFalse((boolean)STATUS2.equals((Object)STATUS3));
        Assertions.assertFalse((boolean)STATUS1.equals(null));
        Assertions.assertFalse((boolean)STATUS1.equals(new Object()));
    }

    @Test
    public void testStatusHashCode() {
        Assertions.assertEquals((int)STATUS1.hashCode(), (int)STATUS2.hashCode());
        Assertions.assertFalse((STATUS1.hashCode() == STATUS3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"user:user1:rwx", (Object)ENTRY1.toString());
        Assertions.assertEquals((Object)"user:user1:rwx", (Object)ENTRY2.toString());
        Assertions.assertEquals((Object)"group:group2:rw-", (Object)ENTRY3.toString());
        Assertions.assertEquals((Object)"default:other::---", (Object)ENTRY4.toString());
        Assertions.assertEquals((Object)"owner: owner1, group: group1, acl: {entries: [user:user1:rwx, group:group2:rw-, default:other::---], stickyBit: false}", (Object)STATUS1.toString());
        Assertions.assertEquals((Object)"owner: owner1, group: group1, acl: {entries: [user:user1:rwx, group:group2:rw-, default:other::---], stickyBit: false}", (Object)STATUS2.toString());
        Assertions.assertEquals((Object)"owner: owner2, group: group2, acl: {entries: [], stickyBit: true}", (Object)STATUS3.toString());
    }
}

