/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.impl.prefetch.ExecutorServiceFuturePool;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestExecutorServiceFuturePool
extends AbstractHadoopTestBase {
    private ExecutorService executorService;

    @BeforeEach
    public void setUp() {
        this.executorService = Executors.newFixedThreadPool(3);
    }

    @AfterEach
    public void tearDown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    @Test
    public void testRunnableSucceeds() throws Exception {
        ExecutorServiceFuturePool futurePool = new ExecutorServiceFuturePool(this.executorService);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Future future = futurePool.executeRunnable(() -> atomicBoolean.set(true));
        future.get(30L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)atomicBoolean.get(), (String)"atomicBoolean set to true?");
    }

    @Test
    public void testSupplierSucceeds() throws Exception {
        ExecutorServiceFuturePool futurePool = new ExecutorServiceFuturePool(this.executorService);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Future future = futurePool.executeFunction(() -> {
            atomicBoolean.set(true);
            return null;
        });
        future.get(30L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)atomicBoolean.get(), (String)"atomicBoolean set to true?");
    }

    @Test
    public void testRunnableFails() throws Exception {
        ExecutorServiceFuturePool futurePool = new ExecutorServiceFuturePool(this.executorService);
        Future future = futurePool.executeRunnable(() -> {
            throw new IllegalStateException("deliberate");
        });
        LambdaTestUtils.interceptFuture(IllegalStateException.class, "deliberate", 30L, TimeUnit.SECONDS, future);
    }

    @Test
    public void testSupplierFails() throws Exception {
        ExecutorServiceFuturePool futurePool = new ExecutorServiceFuturePool(this.executorService);
        Future future = futurePool.executeFunction(() -> {
            throw new IllegalStateException("deliberate");
        });
        LambdaTestUtils.interceptFuture(IllegalStateException.class, "deliberate", 30L, TimeUnit.SECONDS, future);
    }
}

