/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.util.LambdaUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFutureIO
extends HadoopTestBase {
    private ThreadLocal<AtomicInteger> local;

    @BeforeEach
    public void setup() throws Exception {
        this.local = ThreadLocal.withInitial(() -> new AtomicInteger(1));
    }

    @Test
    public void testEvalInCurrentThread() throws Throwable {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture eval = LambdaUtils.eval(result, () -> this.getLocal().addAndGet(2));
        TestFutureIO.assertEquals((int)3, (int)this.getLocalValue(), (String)"Thread local value");
        TestFutureIO.assertEquals((int)3, (int)((Integer)eval.get()), (String)"Evaluated Value");
    }

    @Test
    public void testEvalAsync() throws Throwable {
        CompletableFuture<Integer> eval = CompletableFuture.supplyAsync(() -> this.getLocal().addAndGet(2));
        TestFutureIO.assertEquals((int)1, (int)this.getLocalValue(), (String)"Thread local value");
        TestFutureIO.assertEquals((int)3, (int)eval.get(), (String)"Evaluated Value");
    }

    protected AtomicInteger getLocal() {
        return this.local.get();
    }

    protected int getLocalValue() {
        return this.local.get().get();
    }
}

