/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.localfs;

import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.localfs.LocalFSContract;
import org.junit.jupiter.api.Test;

public class TestLocalFSContractLoaded
extends AbstractFSContractTestBase {
    @Override
    protected AbstractFSContract createContract(Configuration conf) {
        return new LocalFSContract(conf);
    }

    @Test
    public void testContractWorks() throws Throwable {
        String key = this.getContract().getConfKey("supports-atomic-rename");
        TestLocalFSContractLoaded.assertNotNull((Object)this.getContract().getConf().get(key), (String)("not set: " + key));
        TestLocalFSContractLoaded.assertTrue((boolean)this.getContract().isSupported("supports-atomic-rename", false), (String)("not true: " + key));
    }

    @Test
    public void testContractResourceOnClasspath() throws Throwable {
        URL url = this.getClass().getClassLoader().getResource("contract/localfs.xml");
        TestLocalFSContractLoaded.assertNotNull((Object)url, (String)"could not find contract resource");
    }
}

