/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractContractGetFileStatusTest
extends AbstractFSContractTestBase {
    private Path testPath;
    private Path target;
    private static final int TREE_DEPTH = 2;
    private static final int TREE_WIDTH = 3;
    private static final int TREE_FILES = 4;
    private static final int TREE_FILESIZE = 512;
    private static final PathFilter ALL_PATHS = new AllPathsFilter();
    private static final PathFilter NO_PATHS = new NoPathsFilter();

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.skipIfUnsupported("supports-getfilestatus");
        this.testPath = this.path("test");
        this.target = new Path(this.testPath, "target");
    }

    @Test
    public void testGetFileStatusNonexistentFile() throws Throwable {
        try {
            FileStatus status = this.getFileSystem().getFileStatus(this.target);
            AbstractContractGetFileStatusTest.fail((String)("expected a failure, got " + status));
        }
        catch (FileNotFoundException e) {
            this.handleExpectedException(e);
        }
    }

    @Test
    public void testGetFileStatusRoot() throws Throwable {
        ContractTestUtils.assertIsDirectory(this.getFileSystem().getFileStatus(new Path("/")));
    }

    @Test
    public void testListStatusEmptyDirectory() throws IOException {
        this.describe("List status on an empty directory");
        Path subfolder = this.createDirWithEmptySubFolder();
        FileSystem fs = this.getFileSystem();
        Path path = this.getContract().getTestPath();
        new ContractTestUtils.TreeScanResults(fs.listStatus(path)).assertSizeEquals("listStatus(" + path + ")", 0L, 1L, 0L);
        this.describe("Test on empty subdirectory");
        new ContractTestUtils.TreeScanResults(fs.listStatus(subfolder)).assertSizeEquals("listStatus(empty subfolder)", 0L, 0L, 0L);
    }

    @Test
    public void testListFilesEmptyDirectoryNonrecursive() throws IOException {
        this.listFilesOnEmptyDir(false);
    }

    @Test
    public void testListFilesEmptyDirectoryRecursive() throws IOException {
        this.listFilesOnEmptyDir(true);
    }

    private void listFilesOnEmptyDir(boolean recursive) throws IOException {
        this.describe("Invoke listFiles(recursive=" + recursive + ") on empty directories, expect nothing found");
        FileSystem fs = this.getFileSystem();
        Path path = this.getContract().getTestPath();
        fs.delete(path, true);
        Path subfolder = this.createDirWithEmptySubFolder();
        new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listFiles(path, recursive)).assertSizeEquals("listFiles(test dir, " + recursive + ")", 0L, 0L, 0L);
        this.describe("Test on empty subdirectory");
        new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listFiles(subfolder, recursive)).assertSizeEquals("listFiles(empty subfolder, " + recursive + ")", 0L, 0L, 0L);
    }

    @Test
    public void testListLocatedStatusEmptyDirectory() throws IOException {
        this.describe("Invoke listLocatedStatus() on empty directories; expect directories to be found");
        FileSystem fs = this.getFileSystem();
        Path path = this.getContract().getTestPath();
        fs.delete(path, true);
        Path subfolder = this.createDirWithEmptySubFolder();
        new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listLocatedStatus(path)).assertSizeEquals("listLocatedStatus(test dir)", 0L, 1L, 0L);
        this.describe("Test on empty subdirectory");
        new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listLocatedStatus(subfolder)).assertSizeEquals("listLocatedStatus(empty subfolder)", 0L, 0L, 0L);
    }

    @Test
    public void testComplexDirActions() throws Throwable {
        ContractTestUtils.TreeScanResults tree = this.createTestTree();
        this.checkListStatusStatusComplexDir(tree);
        this.checkListStatusIteratorComplexDir(tree);
        this.checkListLocatedStatusStatusComplexDir(tree);
        this.checkListFilesComplexDirNonRecursive(tree);
        this.checkListFilesComplexDirRecursive(tree);
    }

    protected void checkListStatusStatusComplexDir(ContractTestUtils.TreeScanResults tree) throws Throwable {
        this.describe("Expect listStatus to list all entries in top dir only");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.TreeScanResults listing = new ContractTestUtils.TreeScanResults(fs.listStatus(tree.getBasePath()));
        listing.assertSizeEquals("listStatus()", 4L, 3L, 0L);
    }

    protected void checkListStatusIteratorComplexDir(ContractTestUtils.TreeScanResults tree) throws Throwable {
        this.describe("Expect listStatusIterator to list all entries in top dir only");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.TreeScanResults listing = new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listStatusIterator(tree.getBasePath()));
        listing.assertSizeEquals("listStatus()", 4L, 3L, 0L);
        List resWithoutCheckingHasNext = ContractTestUtils.iteratorToListThroughNextCallsAlone(fs.listStatusIterator(tree.getBasePath()));
        List resWithCheckingHasNext = ContractTestUtils.iteratorToList(fs.listStatusIterator(tree.getBasePath()));
        ((ListAssert)Assertions.assertThat(resWithCheckingHasNext).describedAs("listStatusIterator() should return correct results even if hasNext() calls are not made.", new Object[0])).hasSameElementsAs(resWithoutCheckingHasNext);
    }

    protected void checkListLocatedStatusStatusComplexDir(ContractTestUtils.TreeScanResults tree) throws Throwable {
        this.describe("Expect listLocatedStatus to list all entries in top dir only");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.TreeScanResults listing = new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listLocatedStatus(tree.getBasePath()));
        listing.assertSizeEquals("listLocatedStatus()", 4L, 3L, 0L);
        this.verifyFileStats((RemoteIterator<LocatedFileStatus>)fs.listLocatedStatus(tree.getBasePath()));
        ContractTestUtils.TreeScanResults listStatus = new ContractTestUtils.TreeScanResults(fs.listStatus(tree.getBasePath()));
        listing.assertEquivalent(listStatus);
        List<LocatedFileStatus> statusThroughNext = ContractTestUtils.toListThroughNextCallsAlone((RemoteIterator<LocatedFileStatus>)fs.listLocatedStatus(tree.getBasePath()));
        ContractTestUtils.TreeScanResults resultsThroughNext = new ContractTestUtils.TreeScanResults(statusThroughNext);
        listStatus.assertFieldsEquivalent("files", listing, listStatus.getFiles(), resultsThroughNext.getFiles());
    }

    protected void checkListFilesComplexDirNonRecursive(ContractTestUtils.TreeScanResults tree) throws Throwable {
        this.describe("Expect non-recursive listFiles(false) to list all entries in top dir only");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.TreeScanResults listing = new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listFiles(tree.getBasePath(), false));
        listing.assertSizeEquals("listFiles(false)", 4L, 0L, 0L);
        this.verifyFileStats((RemoteIterator<LocatedFileStatus>)fs.listFiles(tree.getBasePath(), false));
        ContractTestUtils.TreeScanResults listStatus = new ContractTestUtils.TreeScanResults(fs.listStatus(tree.getBasePath()));
        listStatus.assertFieldsEquivalent("files", listing, listStatus.getFiles(), listing.getFiles());
        List<LocatedFileStatus> statusThroughNext = ContractTestUtils.toListThroughNextCallsAlone((RemoteIterator<LocatedFileStatus>)fs.listFiles(tree.getBasePath(), false));
        ContractTestUtils.TreeScanResults resultsThroughNext = new ContractTestUtils.TreeScanResults(statusThroughNext);
        listStatus.assertFieldsEquivalent("files", listing, listStatus.getFiles(), resultsThroughNext.getFiles());
    }

    protected void checkListFilesComplexDirRecursive(ContractTestUtils.TreeScanResults tree) throws Throwable {
        this.describe("Expect recursive listFiles(true) to list all files down the tree");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.TreeScanResults listing = new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listFiles(tree.getBasePath(), true));
        tree.assertFieldsEquivalent("files", listing, tree.getFiles(), listing.getFiles());
        int count = this.verifyFileStats((RemoteIterator<LocatedFileStatus>)fs.listFiles(tree.getBasePath(), true));
        this.describe("verifying consistency with treewalk's files");
        ContractTestUtils.TreeScanResults treeWalk = ContractTestUtils.treeWalk(fs, tree.getBasePath());
        treeWalk.assertFieldsEquivalent("files", listing, treeWalk.getFiles(), listing.getFiles());
        AbstractContractGetFileStatusTest.assertEquals((int)count, (int)ContractTestUtils.toListThroughNextCallsAlone((RemoteIterator<LocatedFileStatus>)fs.listFiles(tree.getBasePath(), true)).size(), (String)"Size of status list through next() calls");
    }

    @Test
    public void testListFilesNoDir() throws Throwable {
        RemoteIterator iterator2;
        this.describe("test the listFiles calls on a path which is not present");
        Path path = this.path("missing");
        try {
            iterator2 = this.getFileSystem().listFiles(path, false);
            AbstractContractGetFileStatusTest.fail((String)("Expected an exception, got an iterator: " + iterator2));
        }
        catch (FileNotFoundException iterator2) {
            // empty catch block
        }
        try {
            iterator2 = this.getFileSystem().listFiles(path, true);
            AbstractContractGetFileStatusTest.fail((String)("Expected an exception, got an iterator: " + iterator2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatusIteratorNoDir() throws Throwable {
        this.describe("test the listStatusIterator call on a path which is not present");
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.getFileSystem().listStatusIterator(this.path("missing")));
    }

    @Test
    public void testLocatedStatusNoDir() throws Throwable {
        this.describe("test the LocatedStatus call on a path which is not present");
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.getFileSystem().listLocatedStatus(this.path("missing")));
    }

    @Test
    public void testListStatusNoDir() throws Throwable {
        this.describe("test the listStatus(path) call on a path which is not present");
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.getFileSystem().listStatus(this.path("missing")));
    }

    @Test
    public void testListStatusFilteredNoDir() throws Throwable {
        this.describe("test the listStatus(path, filter) call on a missing path");
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.getFileSystem().listStatus(this.path("missing"), ALL_PATHS));
    }

    @Test
    public void testListStatusFilteredFile() throws Throwable {
        this.describe("test the listStatus(path, filter) on a file");
        Path f = this.touchf("liststatus");
        AbstractContractGetFileStatusTest.assertEquals((int)0, (int)this.getFileSystem().listStatus(f, NO_PATHS).length);
    }

    @Test
    public void testListStatusFile() throws Throwable {
        this.describe("test the listStatus(path) on a file");
        Path f = this.touchf("liststatusfile");
        this.verifyStatusArrayMatchesFile(f, this.getFileSystem().listStatus(f));
    }

    @Test
    public void testListStatusIteratorFile() throws Throwable {
        this.describe("test the listStatusIterator(path) on a file");
        Path f = this.touchf("listStItrFile");
        List<FileStatus> statusList = ContractTestUtils.iteratorToList(this.getFileSystem().listStatusIterator(f));
        this.validateListingForFile(f, statusList, false);
        List<FileStatus> statusList2 = ContractTestUtils.iteratorToListThroughNextCallsAlone(this.getFileSystem().listStatusIterator(f));
        this.validateListingForFile(f, statusList2, true);
    }

    private void validateListingForFile(Path f, List<FileStatus> statusList, boolean nextCallAlone) {
        String msg = String.format("size of file list returned using %s should be 1", nextCallAlone ? "next() calls alone" : "hasNext() and next() calls");
        ((ListAssert)Assertions.assertThat(statusList).describedAs(msg, new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)statusList.get(0).getPath()).describedAs("path returned should match with the input path", new Object[0])).isEqualTo((Object)f);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)statusList.get(0).isFile()).describedAs("path returned should be a file", new Object[0])).isEqualTo(true);
    }

    @Test
    public void testListFilesFile() throws Throwable {
        this.describe("test the listStatus(path) on a file");
        Path f = this.touchf("listfilesfile");
        List<LocatedFileStatus> statusList = ContractTestUtils.toList((RemoteIterator<LocatedFileStatus>)this.getFileSystem().listFiles(f, false));
        AbstractContractGetFileStatusTest.assertEquals((int)1, (int)statusList.size(), (String)"size of file list returned");
        this.assertIsNamedFile(f, (FileStatus)statusList.get(0));
        List<LocatedFileStatus> statusList2 = ContractTestUtils.toListThroughNextCallsAlone((RemoteIterator<LocatedFileStatus>)this.getFileSystem().listFiles(f, false));
        AbstractContractGetFileStatusTest.assertEquals((int)1, (int)statusList2.size(), (String)"size of file list returned through next() calls");
        this.assertIsNamedFile(f, (FileStatus)statusList2.get(0));
    }

    @Test
    public void testListFilesFileRecursive() throws Throwable {
        this.describe("test the listFiles(path, true) on a file");
        Path f = this.touchf("listfilesRecursive");
        List<LocatedFileStatus> statusList = ContractTestUtils.toList((RemoteIterator<LocatedFileStatus>)this.getFileSystem().listFiles(f, true));
        AbstractContractGetFileStatusTest.assertEquals((int)1, (int)statusList.size(), (String)"size of file list returned");
        this.assertIsNamedFile(f, (FileStatus)statusList.get(0));
        List<LocatedFileStatus> statusList2 = ContractTestUtils.toListThroughNextCallsAlone((RemoteIterator<LocatedFileStatus>)this.getFileSystem().listFiles(f, true));
        AbstractContractGetFileStatusTest.assertEquals((int)1, (int)statusList2.size(), (String)"size of file list returned");
    }

    @Test
    public void testListLocatedStatusFile() throws Throwable {
        this.describe("test the listLocatedStatus(path) on a file");
        Path f = this.touchf("listLocatedStatus");
        List<LocatedFileStatus> statusList = ContractTestUtils.toList((RemoteIterator<LocatedFileStatus>)this.getFileSystem().listLocatedStatus(f));
        AbstractContractGetFileStatusTest.assertEquals((int)1, (int)statusList.size(), (String)"size of file list returned");
        this.assertIsNamedFile(f, (FileStatus)statusList.get(0));
        List<LocatedFileStatus> statusList2 = ContractTestUtils.toListThroughNextCallsAlone((RemoteIterator<LocatedFileStatus>)this.getFileSystem().listLocatedStatus(f));
        AbstractContractGetFileStatusTest.assertEquals((int)1, (int)statusList2.size(), (String)"size of file list returned through next() calls");
    }

    private void verifyStatusArrayMatchesFile(Path f, FileStatus[] status) {
        AbstractContractGetFileStatusTest.assertEquals((int)1, (int)status.length);
        FileStatus fileStatus = status[0];
        this.assertIsNamedFile(f, fileStatus);
    }

    private void assertIsNamedFile(Path f, FileStatus fileStatus) {
        AbstractContractGetFileStatusTest.assertEquals((Object)f, (Object)fileStatus.getPath(), (String)("Wrong pathname in " + fileStatus));
        AbstractContractGetFileStatusTest.assertTrue((boolean)fileStatus.isFile(), (String)("Not a file: " + fileStatus));
    }

    Path touchf(String name) throws IOException {
        Path path = this.path(name);
        ContractTestUtils.touch(this.getFileSystem(), path);
        return path;
    }

    private Path createDirWithEmptySubFolder() throws IOException {
        FileSystem fs = this.getFileSystem();
        Path path = this.getContract().getTestPath();
        fs.delete(path, true);
        Path subfolder = path.suffix('/' + this.methodName.getMethodName() + "-" + UUID.randomUUID());
        this.mkdirs(subfolder);
        return subfolder;
    }

    private ContractTestUtils.TreeScanResults createTestTree() throws IOException {
        return ContractTestUtils.createSubdirs(this.getFileSystem(), this.path(this.methodName.getMethodName()), 2, 3, 4, 512);
    }

    private int verifyFileStats(RemoteIterator<LocatedFileStatus> results) throws IOException {
        this.describe("verifying file statuses");
        int count = 0;
        while (results.hasNext()) {
            ++count;
            LocatedFileStatus next = (LocatedFileStatus)results.next();
            FileStatus fileStatus = this.getFileSystem().getFileStatus(next.getPath());
            AbstractContractGetFileStatusTest.assertEquals((Object)fileStatus.isDirectory(), (Object)next.isDirectory(), (String)"isDirectory");
            AbstractContractGetFileStatusTest.assertEquals((Object)fileStatus.isFile(), (Object)next.isFile(), (String)"isFile");
            AbstractContractGetFileStatusTest.assertEquals((long)fileStatus.getLen(), (long)next.getLen(), (String)"getLen");
            AbstractContractGetFileStatusTest.assertEquals((Object)fileStatus.getOwner(), (Object)next.getOwner(), (String)"getOwner");
        }
        return count;
    }

    @Test
    public void testListStatusFiltering() throws Throwable {
        this.describe("Call listStatus() against paths and directories with filtering");
        Path file1 = this.touchf("file-1.txt");
        this.touchf("file-2.txt");
        Path parent = file1.getParent();
        this.verifyListStatus(0, parent, NO_PATHS);
        this.verifyListStatus(2, parent, ALL_PATHS);
        MatchesNameFilter file1Filter = new MatchesNameFilter("file-1.txt");
        FileStatus[] result = this.verifyListStatus(1, parent, file1Filter);
        AbstractContractGetFileStatusTest.assertEquals((Object)file1, (Object)result[0].getPath());
        this.verifyListStatus(0, file1, NO_PATHS);
        result = this.verifyListStatus(1, file1, ALL_PATHS);
        AbstractContractGetFileStatusTest.assertEquals((Object)file1, (Object)result[0].getPath());
        result = this.verifyListStatus(1, file1, file1Filter);
        AbstractContractGetFileStatusTest.assertEquals((Object)file1, (Object)result[0].getPath());
        Path subdir = this.path("subdir");
        this.mkdirs(subdir);
        this.verifyListStatus(0, subdir, NO_PATHS);
        this.verifyListStatus(0, subdir, ALL_PATHS);
        this.verifyListStatus(0, subdir, new MatchesNameFilter("subdir"));
    }

    @Test
    public void testListLocatedStatusFiltering() throws Throwable {
        this.describe("Call listLocatedStatus() with filtering");
        this.describe("Call listStatus() against paths and directories with filtering");
        Path file1 = this.touchf("file-1.txt");
        Path file2 = this.touchf("file-2.txt");
        Path parent = file1.getParent();
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.touch(fs, file1);
        ContractTestUtils.touch(fs, file2);
        ExtendedFilterFS xfs = new ExtendedFilterFS(fs);
        this.verifyListStatus(0, parent, NO_PATHS);
        this.verifyListStatus(2, parent, ALL_PATHS);
        MatchesNameFilter file1Filter = new MatchesNameFilter("file-1.txt");
        List<LocatedFileStatus> result = this.verifyListLocatedStatus(xfs, 1, parent, file1Filter);
        AbstractContractGetFileStatusTest.assertEquals((Object)file1, (Object)result.get(0).getPath());
        this.verifyListLocatedStatus(xfs, 0, file1, NO_PATHS);
        this.verifyListLocatedStatus(xfs, 1, file1, ALL_PATHS);
        AbstractContractGetFileStatusTest.assertEquals((Object)file1, (Object)result.get(0).getPath());
        this.verifyListLocatedStatus(xfs, 1, file1, file1Filter);
        AbstractContractGetFileStatusTest.assertEquals((Object)file1, (Object)result.get(0).getPath());
        this.verifyListLocatedStatusNextCalls(xfs, 1, file1, file1Filter);
        Path subdir = this.path("subdir");
        this.mkdirs(subdir);
        this.verifyListLocatedStatus(xfs, 0, subdir, NO_PATHS);
        this.verifyListLocatedStatus(xfs, 0, subdir, ALL_PATHS);
        this.verifyListLocatedStatusNextCalls(xfs, 0, subdir, ALL_PATHS);
        this.verifyListLocatedStatus(xfs, 0, subdir, new MatchesNameFilter("subdir"));
    }

    private FileStatus[] verifyListStatus(int expected, Path path, PathFilter filter) throws IOException {
        Object[] result = this.getFileSystem().listStatus(path, filter);
        AbstractContractGetFileStatusTest.assertEquals((int)expected, (int)result.length, (String)("length of listStatus(" + path + ", " + filter + " ) " + Arrays.toString(result)));
        return result;
    }

    private List<LocatedFileStatus> verifyListLocatedStatus(ExtendedFilterFS xfs, int expected, Path path, PathFilter filter) throws IOException {
        RemoteIterator<LocatedFileStatus> it = xfs.listLocatedStatus(path, filter);
        List<LocatedFileStatus> result = ContractTestUtils.toList(it);
        AbstractContractGetFileStatusTest.assertEquals((int)expected, (int)result.size(), (String)("length of listLocatedStatus(" + path + ", " + filter + " )"));
        return result;
    }

    private List<LocatedFileStatus> verifyListLocatedStatusNextCalls(ExtendedFilterFS xfs, int expected, Path path, PathFilter filter) throws IOException {
        RemoteIterator<LocatedFileStatus> it = xfs.listLocatedStatus(path, filter);
        List<LocatedFileStatus> result = ContractTestUtils.toListThroughNextCallsAlone(it);
        AbstractContractGetFileStatusTest.assertEquals((int)expected, (int)result.size(), (String)("length of listLocatedStatus(" + path + ", " + filter + " )"));
        return result;
    }

    protected static final class ExtendedFilterFS
    extends FilterFileSystem {
        public ExtendedFilterFS(FileSystem fs) {
            super(fs);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws IOException {
            return super.listLocatedStatus(f, filter);
        }
    }

    private static final class MatchesNameFilter
    implements PathFilter {
        private final String match;

        MatchesNameFilter(String match) {
            this.match = match;
        }

        public boolean accept(Path path) {
            return this.match.equals(path.getName());
        }
    }

    private static final class NoPathsFilter
    implements PathFilter {
        private NoPathsFilter() {
        }

        public boolean accept(Path path) {
            return false;
        }
    }

    private static final class AllPathsFilter
    implements PathFilter {
        private AllPathsFilter() {
        }

        public boolean accept(Path path) {
            return true;
        }
    }
}

