/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.TrashPolicy;
import org.apache.hadoop.fs.TrashPolicyDefault;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTrash {
    private static final File BASE_PATH = new File(GenericTestUtils.getTempPath("testTrash"));
    private static final Path TEST_DIR = new Path(BASE_PATH.getAbsolutePath());

    @BeforeEach
    public void setUp() throws IOException {
        FileSystem.closeAll();
    }

    protected static Path mkdir(FileSystem fs, Path p) throws IOException {
        Assertions.assertTrue((boolean)fs.mkdirs(p));
        Assertions.assertTrue((boolean)fs.exists(p));
        Assertions.assertTrue((boolean)fs.getFileStatus(p).isDirectory());
        return p;
    }

    protected static void checkTrash(FileSystem trashFs, Path trashRoot, Path path) throws IOException {
        Path p = Path.mergePaths((Path)trashRoot, (Path)path);
        Assertions.assertTrue((boolean)trashFs.exists(p), (String)("Could not find file in trash: " + p));
    }

    protected static int countSameDeletedFiles(FileSystem fs, Path trashDir, Path fileName) throws IOException {
        final String prefix = fileName.getName();
        System.out.println("Counting " + fileName + " in " + trashDir.toString());
        PathFilter pf = new PathFilter(){

            public boolean accept(Path file) {
                return file.getName().startsWith(prefix);
            }
        };
        FileStatus[] fss = fs.listStatus(trashDir, pf);
        return fss == null ? 0 : fss.length;
    }

    static void checkNotInTrash(FileSystem fs, Path trashRoot, String pathname) throws IOException {
        Path p = new Path(trashRoot + "/" + new Path(pathname).getName());
        Assertions.assertTrue((!fs.exists(p) ? 1 : 0) != 0);
    }

    public static void trashShell(FileSystem fs, Path base) throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", fs.getUri().toString());
        TestTrash.trashShell(conf, base, null, null);
    }

    public static void trashShell(Configuration conf, Path base, FileSystem trashRootFs, Path trashRoot) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)conf);
        conf.setLong("fs.trash.interval", 0L);
        Assertions.assertFalse((boolean)new Trash(conf).isEnabled());
        conf.setLong("fs.trash.interval", -1L);
        Assertions.assertFalse((boolean)new Trash(conf).isEnabled());
        conf.setLong("fs.trash.interval", 10L);
        Assertions.assertTrue((boolean)new Trash(conf).isEnabled());
        FsShell shell = new FsShell();
        shell.setConf(conf);
        if (trashRoot == null) {
            trashRoot = shell.getCurrentTrashDir();
        }
        if (trashRootFs == null) {
            trashRootFs = fs;
        }
        Path myPath = new Path(base, "test/mkdirs");
        TestTrash.mkdir(fs, myPath);
        Path myFile = new Path(base, "test/mkdirs/myFile");
        FileSystemTestHelper.writeFile(fs, myFile, 10);
        String[] args = new String[]{"-expunge"};
        int val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Expunge should return zero");
        args = new String[]{"-rm", myFile.toString()};
        val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Remove should return zero");
        TestTrash.checkTrash(trashRootFs, trashRoot, fs.makeQualified(myFile));
        FileSystemTestHelper.writeFile(fs, myFile, 10);
        args = new String[]{"-rm", new Path(base, "test/mkdirs/myFile").toString()};
        val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Remove should return zero");
        FileSystemTestHelper.writeFile(fs, myFile, 10);
        args = new String[]{"-rmr", new Path(base, "test/mkdirs").toString()};
        val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Recursive Remove should return zero");
        TestTrash.mkdir(fs, myPath);
        args = new String[]{"-rmr", new Path(base, "test/mkdirs").toString()};
        val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Recursive Remove should return zero");
        Path toErase = new Path(trashRoot, "toErase");
        val = -1;
        FileSystemTestHelper.writeFile(trashRootFs, toErase, 10);
        val = shell.run(new String[]{"-rm", toErase.toString()});
        Assertions.assertEquals((int)0, (int)val, (String)"Recursive Remove should return zero");
        TestTrash.checkNotInTrash(trashRootFs, trashRoot, toErase.toString());
        TestTrash.checkNotInTrash(trashRootFs, trashRoot, toErase.toString() + ".1");
        args = new String[]{"-expunge"};
        val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Expunge should return zero");
        TestTrash.checkNotInTrash(trashRootFs, trashRoot, new Path(base, "test/mkdirs/myFile").toString());
        TestTrash.mkdir(fs, myPath);
        FileSystemTestHelper.writeFile(fs, myFile, 10);
        args = new String[]{"-rm", myFile.toString()};
        val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Remove should return zero");
        TestTrash.checkTrash(trashRootFs, trashRoot, myFile);
        args = new String[]{"-rmr", myPath.toString()};
        val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Recursive Remove should return zero");
        TestTrash.checkTrash(trashRootFs, trashRoot, myPath);
        args = new String[]{"-rmr", trashRoot.getParent().getParent().toString()};
        val = -1;
        val = shell.run(args);
        Assertions.assertEquals((int)1, (int)val, (String)"Recursive Remove should return exit code 1");
        Assertions.assertTrue((boolean)trashRootFs.exists(trashRoot));
        TestTrash.mkdir(fs, myPath);
        FileSystemTestHelper.writeFile(fs, myFile, 10);
        args = new String[]{"-rm", "-skipTrash", myFile.toString()};
        val = -1;
        Assertions.assertEquals((int)0, (int)shell.run(new String[]{"-expunge"}), (String)"-expunge failed");
        val = shell.run(args);
        Assertions.assertFalse((boolean)trashRootFs.exists(trashRoot), (String)("Expected TrashRoot (" + trashRoot + ") to exist in file system:" + trashRootFs.getUri()));
        Assertions.assertFalse((boolean)fs.exists(myFile));
        Assertions.assertEquals((int)0, (int)val, (String)"Remove with skipTrash should return zero");
        TestTrash.mkdir(fs, myPath);
        FileSystemTestHelper.writeFile(fs, myFile, 10);
        args = new String[]{"-rmr", "-skipTrash", myPath.toString()};
        val = -1;
        Assertions.assertEquals((int)0, (int)shell.run(new String[]{"-expunge"}));
        val = shell.run(args);
        Assertions.assertFalse((boolean)trashRootFs.exists(trashRoot));
        Assertions.assertFalse((boolean)fs.exists(myPath));
        Assertions.assertFalse((boolean)fs.exists(myFile));
        Assertions.assertEquals((int)0, (int)val, (String)"Remove with skipTrash should return zero");
        int val2 = -1;
        TestTrash.mkdir(fs, myPath);
        Assertions.assertEquals((int)0, (int)shell.run(new String[]{"-expunge"}), (String)"Expunge should return zero");
        myFile = new Path(base, "test/mkdirs/myFile");
        String[] args2 = new String[]{"-rm", myFile.toString()};
        int num_runs = 10;
        for (int i = 0; i < num_runs; ++i) {
            FileSystemTestHelper.writeFile(fs, myFile, 10);
            val2 = shell.run(args2);
            Assertions.assertEquals((int)0, (int)val2, (String)"Remove should return zero");
        }
        Path trashDir = Path.mergePaths((Path)new Path(trashRoot.toUri().getPath()), (Path)new Path(myFile.getParent().toUri().getPath()));
        System.out.println("Deleting same myFile: myFile.parent=" + myFile.getParent().toUri().getPath() + "; trashroot=" + trashRoot.toUri().getPath() + "; trashDir=" + trashDir.toUri().getPath());
        int count = TestTrash.countSameDeletedFiles(fs, trashDir, myFile);
        System.out.println("counted " + count + " files " + myFile.getName() + "* in " + trashDir);
        Assertions.assertEquals((int)num_runs, (int)count, (String)"Count should have returned 10");
        args = new String[]{"-rmr", "/"};
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream newOut = new PrintStream(byteStream);
        System.setOut(newOut);
        System.setErr(newOut);
        shell.run(args);
        String output = byteStream.toString();
        System.setOut(stdout);
        System.setErr(stderr);
        Assertions.assertTrue((output.indexOf("Consider using -skipTrash option") != -1 || output.indexOf("Failed to determine server trash configuration") != -1 ? 1 : 0) != 0, (String)"skipTrash wasn't suggested as remedy to failed rm command or we deleted / even though we could not get server defaults");
        long trashInterval = conf.getLong("fs.trash.interval", 0L);
        long now = Time.now();
        SimpleDateFormat oldCheckpointFormat = new SimpleDateFormat("yyMMddHHmm");
        Path dirToDelete = new Path(trashRoot.getParent(), oldCheckpointFormat.format(now - trashInterval * 60L * 1000L - 1L));
        Path dirToKeep = new Path(trashRoot.getParent(), oldCheckpointFormat.format(now));
        TestTrash.mkdir(trashRootFs, dirToDelete);
        TestTrash.mkdir(trashRootFs, dirToKeep);
        int rc = -1;
        rc = shell.run(new String[]{"-expunge"});
        Assertions.assertEquals((int)0, (int)rc, (String)"Expunge should return zero");
        Assertions.assertFalse((boolean)trashRootFs.exists(dirToDelete), (String)"old checkpoint format not recognized");
        Assertions.assertTrue((boolean)trashRootFs.exists(dirToKeep), (String)"old checkpoint format directory should not be removed");
        trashInterval = conf.getLong("fs.trash.interval", 0L);
        now = Time.now();
        SimpleDateFormat checkpointFormat = new SimpleDateFormat("yyMMddHHmm");
        Path oldCheckpoint = new Path(trashRoot.getParent(), checkpointFormat.format(now - trashInterval * 60L * 1000L - 1L));
        Path recentCheckpoint = new Path(trashRoot.getParent(), checkpointFormat.format(now));
        Path currentFolder = new Path(trashRoot.getParent(), "Current");
        TestTrash.mkdir(trashRootFs, oldCheckpoint);
        TestTrash.mkdir(trashRootFs, recentCheckpoint);
        TestTrash.mkdir(trashRootFs, currentFolder);
        int rc2 = -1;
        rc2 = shell.run(new String[]{"-expunge", "-immediate"});
        Assertions.assertEquals((int)0, (int)rc2, (String)"Expunge immediate should return zero");
        Assertions.assertFalse((boolean)trashRootFs.exists(oldCheckpoint), (String)"Old checkpoint should be removed");
        Assertions.assertFalse((boolean)trashRootFs.exists(recentCheckpoint), (String)"Recent checkpoint should be removed");
        Assertions.assertFalse((boolean)trashRootFs.exists(currentFolder), (String)"Current folder should be removed");
        Assertions.assertEquals((int)0, (int)trashRootFs.listStatus(trashRoot.getParent()).length, (String)"Ensure trash folder is empty");
    }

    @Test
    public void testExpungeWithFileSystem() throws Exception {
        Configuration config = new Configuration();
        config.setClass("fs.testlfs.impl", TestLFS.class, FileSystem.class);
        TestLFS testlfs = new TestLFS();
        testlfs.setUri("testlfs:/");
        URI testlfsURI = testlfs.getUri();
        config.set("fs.defaultFS", testlfsURI.toString());
        config.setLong("fs.trash.interval", 10L);
        Assertions.assertTrue((boolean)new Trash(config).isEnabled());
        FileSystem.addFileSystemForTesting((URI)testlfsURI, (Configuration)config, (FileSystem)testlfs);
        testlfs.initialize(testlfsURI, config);
        FsShell testlfsshell = new FsShell();
        testlfsshell.setConf(config);
        Path trashRoot = testlfsshell.getCurrentTrashDir();
        long trashInterval = config.getLong("fs.trash.interval", 0L);
        long now = Time.now();
        SimpleDateFormat checkpointFormat = new SimpleDateFormat("yyMMddHHmm");
        Path oldCheckpoint = new Path(trashRoot.getParent(), checkpointFormat.format(now - trashInterval * 60L * 1000L - 1L));
        Path recentCheckpoint = new Path(trashRoot.getParent(), checkpointFormat.format(now));
        Path currentFolder = new Path(trashRoot.getParent(), "Current");
        Path myPath = new Path(TEST_DIR, "test/mkdirs");
        Path myFile = new Path(TEST_DIR, "test/mkdirs/testFile");
        TestTrash.mkdir((FileSystem)testlfs, oldCheckpoint);
        TestTrash.mkdir((FileSystem)testlfs, recentCheckpoint);
        TestTrash.mkdir((FileSystem)testlfs, currentFolder);
        TestTrash.mkdir((FileSystem)testlfs, myPath);
        FileSystemTestHelper.writeFile((FileSystem)testlfs, myFile, 10);
        String[] args = new String[]{"-expunge", "-immediate", "-fs", "testlfs:/"};
        int val = testlfsshell.run(args);
        Assertions.assertEquals((int)0, (int)val, (String)"Expunge immediate with filesystem should return zero");
        Assertions.assertFalse((boolean)testlfs.exists(oldCheckpoint), (String)"Old checkpoint should be removed");
        Assertions.assertFalse((boolean)testlfs.exists(recentCheckpoint), (String)"Recent checkpoint should be removed");
        Assertions.assertFalse((boolean)testlfs.exists(currentFolder), (String)"Current folder should be removed");
        Assertions.assertEquals((int)0, (int)testlfs.listStatus(trashRoot.getParent()).length, (String)"Ensure trash folder is empty");
        String incorrectFS = "incorrectfs:/";
        args = new String[]{"-expunge", "-immediate", "-fs", incorrectFS};
        val = testlfsshell.run(args);
        Assertions.assertEquals((int)1, (int)val, (String)"Expunge immediate should return exit code 1 when incorrect Filesystem is passed");
        args = new String[]{"-expunge", "-immediate", "-fs", ""};
        val = testlfsshell.run(args);
        Assertions.assertNotEquals((int)0, (int)val, (String)"Expunge immediate should fail when filesystem is NULL");
        FileSystem.removeFileSystemForTesting((URI)testlfsURI, (Configuration)config, (FileSystem)testlfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trashNonDefaultFS(Configuration conf) throws IOException {
        conf.setLong("fs.trash.interval", 10L);
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path p = TEST_DIR;
        Path f = new Path(p, "foo/bar");
        if (lfs.exists(p)) {
            lfs.delete(p, true);
        }
        try {
            FileSystemTestHelper.writeFile((FileSystem)lfs, f, 10);
            FileSystem.closeAll();
            FileSystem localFs = FileSystem.get((URI)URI.create("file:///"), (Configuration)conf);
            Trash lTrash = new Trash(localFs, conf);
            lTrash.moveToTrash(f.getParent());
            TestTrash.checkTrash(localFs, lTrash.getCurrentTrashDir(), f);
        }
        finally {
            if (lfs.exists(p)) {
                lfs.delete(p, true);
            }
        }
    }

    @Test
    public void testTrash() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        TestTrash.trashShell((FileSystem)FileSystem.getLocal((Configuration)conf), TEST_DIR);
    }

    @Test
    public void testExistingFileTrash() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        conf.set("fs.defaultFS", fs.getUri().toString());
        conf.setLong("fs.trash.interval", 0L);
        Assertions.assertFalse((boolean)new Trash(conf).isEnabled());
        conf.setLong("fs.trash.interval", -1L);
        Assertions.assertFalse((boolean)new Trash(conf).isEnabled());
        conf.setLong("fs.trash.interval", 10L);
        Assertions.assertTrue((boolean)new Trash(conf).isEnabled());
        FsShell shell = new FsShell();
        shell.setConf(conf);
        Path myPath = new Path(TEST_DIR, "test/mkdirs");
        TestTrash.mkdir((FileSystem)fs, myPath);
        Path myFile = new Path(TEST_DIR, "test/mkdirs/myExistingFile");
        FileSystemTestHelper.writeFile((FileSystem)fs, myFile, 10);
        TestTrash.mkdir((FileSystem)fs, myPath);
        FileSystemTestHelper.writeFile((FileSystem)fs, myFile, 10);
        String[] args1 = new String[]{"-rm", myFile.toString()};
        int val1 = -1;
        try {
            val1 = shell.run(args1);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        Assertions.assertTrue((val1 == 0 ? 1 : 0) != 0);
        TestTrash.mkdir((FileSystem)fs, myFile);
        FileSystemTestHelper.writeFile((FileSystem)fs, new Path(myFile, "mySubFile"), 10);
        String[] args2 = new String[]{"-rm", new Path(myFile, "mySubFile").toString()};
        int val2 = -1;
        try {
            val2 = shell.run(args2);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        Assertions.assertTrue((val2 == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNonDefaultFS() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        conf.set("fs.defaultFS", "invalid://host/bar/foo");
        TestTrash.trashNonDefaultFS(conf);
    }

    @Test
    public void testPluggableTrash() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.trash.classname", TestTrashPolicy.class, TrashPolicy.class);
        Trash trash = new Trash(conf);
        Assertions.assertTrue((boolean)trash.getTrashPolicy().getClass().equals(TestTrashPolicy.class));
    }

    @Test
    public void testCheckpointInterval() throws IOException {
        this.verifyDefaultPolicyIntervalValues(10L, 12L, 10L);
        this.verifyDefaultPolicyIntervalValues(10L, 5L, 5L);
        this.verifyDefaultPolicyIntervalValues(10L, 0L, 10L);
        this.verifyDefaultPolicyIntervalValues(10L, -1L, 10L);
    }

    @Test
    public void testMoveEmptyDirToTrash() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", RawLocalFileSystem.class, FileSystem.class);
        conf.setLong("fs.trash.interval", 1L);
        FileSystem fs = FileSystem.get((Configuration)conf);
        TestTrash.verifyMoveEmptyDirToTrash(fs, conf);
    }

    @Test
    public void testTrashRestarts() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("fs.trash.classname", AuditableTrashPolicy.class, TrashPolicy.class);
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        conf.set("fs.trash.interval", "50");
        Trash trash = new Trash(conf);
        for (int i = 0; i < 5; ++i) {
            trash.checkpoint();
        }
        this.verifyAuditableTrashEmptier(trash, 120L, 3);
        conf.set("fs.trash.interval", "100");
        Trash trashNew = new Trash(conf);
        this.verifyAuditableTrashEmptier(trashNew, 120L, 2);
    }

    @Test
    public void testTrashPermission() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.trash.classname", TrashPolicyDefault.class, TrashPolicy.class);
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        conf.set("fs.trash.interval", "0.2");
        TestTrash.verifyTrashPermission((FileSystem)FileSystem.getLocal((Configuration)conf), conf);
    }

    @Test
    public void testTrashEmptier() throws Exception {
        FileStatus[] files;
        Configuration conf = new Configuration();
        conf.set("fs.trash.interval", "0.2");
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        conf.set("fs.trash.checkpoint.interval", "0.1");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        conf.set("fs.default.name", fs.getUri().toString());
        Trash trash = new Trash(conf);
        Runnable emptier = trash.getEmptier();
        Thread emptierThread = new Thread(emptier);
        emptierThread.start();
        FsShell shell = new FsShell();
        shell.setConf(conf);
        shell.init();
        Path myPath = new Path(TEST_DIR, "test/mkdirs");
        TestTrash.mkdir((FileSystem)fs, myPath);
        int fileIndex = 0;
        HashSet<String> checkpoints = new HashSet<String>();
        while (true) {
            Path myFile = new Path(TEST_DIR, "test/mkdirs/myFile" + fileIndex++);
            FileSystemTestHelper.writeFile((FileSystem)fs, myFile, 10);
            String[] args = new String[]{"-rm", myFile.toString()};
            int val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
            }
            Assertions.assertTrue((val == 0 ? 1 : 0) != 0);
            Path trashDir = shell.getCurrentTrashDir();
            for (FileStatus file : files = fs.listStatus(trashDir.getParent())) {
                String fileName = file.getPath().getName();
                checkpoints.add(fileName);
            }
            if (checkpoints.size() == 4) break;
            Thread.sleep(5000L);
        }
        Assertions.assertTrue((checkpoints.size() > files.length ? 1 : 0) != 0);
        emptierThread.interrupt();
        emptierThread.join();
    }

    @Test
    public void testTrashEmptierCleanDirNotInCheckpointDir() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.trash.interval", "0.2");
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        conf.set("fs.trash.checkpoint.interval", "0.1");
        conf.setBoolean("fs.trash.clean.trashroot.enable", true);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        conf.set("fs.default.name", fs.getUri().toString());
        Trash trash = new Trash(conf);
        Runnable emptier = trash.getEmptier();
        Thread emptierThread = new Thread(emptier);
        emptierThread.start();
        FsShell shell = new FsShell();
        shell.setConf(conf);
        shell.init();
        TestTrash.mkdir((FileSystem)fs, shell.getCurrentTrashDir());
        Assertions.assertTrue((boolean)fs.exists(shell.getCurrentTrashDir()));
        Path myPath = new Path(shell.getCurrentTrashDir().getParent(), "test_dirs");
        TestTrash.mkdir((FileSystem)fs, myPath);
        Assertions.assertTrue((boolean)fs.exists(myPath));
        GenericTestUtils.waitFor(new Supplier<Boolean>((FileSystem)fs, myPath){
            final /* synthetic */ FileSystem val$fs;
            final /* synthetic */ Path val$myPath;
            {
                this.val$fs = fileSystem;
                this.val$myPath = path;
            }

            @Override
            public Boolean get() {
                try {
                    return !this.val$fs.exists(this.val$myPath);
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }, 6000L, 60000L);
        emptierThread.interrupt();
        emptierThread.join();
    }

    @AfterEach
    public void tearDown() throws IOException {
        File trashDir = new File(TEST_DIR.toUri().getPath());
        if (trashDir.exists() && !FileUtil.fullyDelete((File)trashDir)) {
            throw new IOException("Cannot remove data directory: " + trashDir);
        }
    }

    public static void performanceTestDeleteSameFile() throws IOException {
        Path base = TEST_DIR;
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        conf.set("fs.defaultFS", fs.getUri().toString());
        conf.setLong("fs.trash.interval", 10L);
        FsShell shell = new FsShell();
        shell.setConf(conf);
        Path myPath = new Path(base, "test/mkdirs");
        TestTrash.mkdir((FileSystem)fs, myPath);
        long first = 0L;
        int retVal = 0;
        int factor = 10;
        Path myFile = new Path(base, "test/mkdirs/myFile");
        String[] args = new String[]{"-rm", myFile.toString()};
        int iters = 1000;
        for (int i = 0; i < iters; ++i) {
            long factoredTime;
            FileSystemTestHelper.writeFile((FileSystem)fs, myFile, 10);
            long start = Time.now();
            try {
                retVal = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
                throw new IOException(e.getMessage());
            }
            Assertions.assertTrue((retVal == 0 ? 1 : 0) != 0);
            long iterTime = Time.now() - start;
            if (i < 10) {
                first = i == 0 ? iterTime : (first + iterTime) / 2L;
            }
            int print_freq = iters / 10;
            if (i <= 10) continue;
            if (i % print_freq == 0) {
                System.out.println("iteration=" + i + ";res =" + retVal + "; start=" + start + "; iterTime = " + iterTime + " vs. firstTime=" + first);
            }
            Assertions.assertTrue((iterTime < (factoredTime = first * (long)factor) ? 1 : 0) != 0);
        }
    }

    public static void verifyMoveEmptyDirToTrash(FileSystem fs, Configuration conf) throws IOException {
        Path caseRoot = new Path(GenericTestUtils.getTempPath("testUserTrash"));
        Path testRoot = new Path(caseRoot, "trash-users");
        Path emptyDir = new Path(testRoot, "empty-dir");
        try (FileSystem fileSystem = fs;){
            fileSystem.mkdirs(emptyDir);
            Trash trash = new Trash(fileSystem, conf);
            Path trashRoot = trash.getCurrentTrashDir(emptyDir);
            fileSystem.delete(trashRoot, true);
            Assertions.assertTrue((boolean)trash.moveToTrash(emptyDir), (String)"Move an empty directory to trash failed");
            Assertions.assertFalse((boolean)fileSystem.exists(emptyDir), (String)"The empty directory still exists on file system");
            emptyDir = fileSystem.makeQualified(emptyDir);
            Path dirInTrash = Path.mergePaths((Path)trashRoot, (Path)emptyDir);
            Assertions.assertTrue((boolean)fileSystem.exists(dirInTrash), (String)"Directory wasn't moved to trash");
            FileStatus[] flist = fileSystem.listStatus(dirInTrash);
            Assertions.assertTrue((flist != null && flist.length == 0 ? 1 : 0) != 0, (String)"Directory is not empty");
        }
    }

    public static void verifyTrashPermission(FileSystem fs, Configuration conf) throws IOException {
        Path caseRoot = new Path(BASE_PATH.getPath(), "testTrashPermission");
        try (FileSystem fileSystem = fs;){
            Trash trash = new Trash(fileSystem, conf);
            FileSystemTestWrapper wrapper = new FileSystemTestWrapper(fileSystem);
            short[] filePermssions = new short[]{384, 420, 432, 448, 488, 493, 509, 511};
            for (int i = 0; i < filePermssions.length; ++i) {
                FsPermission fsPermission = new FsPermission(filePermssions[i]);
                Path file = new Path(caseRoot, "file" + i);
                byte[] randomBytes = new byte[new Random().nextInt(10)];
                wrapper.writeFile(file, randomBytes);
                wrapper.setPermission(file, fsPermission);
                trash.moveToTrash(file);
                Path trashDir = trash.getCurrentTrashDir(file);
                if (!file.isAbsolute()) {
                    file = wrapper.makeQualified(file);
                }
                Path fileInTrash = Path.mergePaths((Path)trashDir, (Path)file);
                FileStatus fstat = wrapper.getFileStatus(fileInTrash);
                Assertions.assertTrue((boolean)wrapper.exists(fileInTrash), (String)String.format("File %s is not moved to trash", fileInTrash.toString()));
                Assertions.assertTrue((boolean)fstat.getPermission().equals((Object)fsPermission), (String)String.format("Expected file: %s is %s, but actual is %s", fileInTrash.toString(), fsPermission.toString(), fstat.getPermission().toString()));
            }
            Path trashRoot = trash.getCurrentTrashDir();
            Assertions.assertTrue((boolean)wrapper.delete(trashRoot, true));
        }
    }

    private void verifyDefaultPolicyIntervalValues(long trashInterval, long checkpointInterval, long expectedInterval) throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("fs.trash.interval", trashInterval);
        conf.set("fs.trash.classname", TrashPolicyDefault.class.getName());
        conf.setLong("fs.trash.checkpoint.interval", checkpointInterval);
        Trash trash = new Trash(conf);
        TrashPolicyDefault.Emptier emptier = (TrashPolicyDefault.Emptier)trash.getEmptier();
        Assertions.assertEquals((long)expectedInterval, (long)emptier.getEmptierInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAuditableTrashEmptier(Trash trash, long timeAlive, int expectedNumOfCheckpoints) throws IOException {
        Thread emptierThread = null;
        try {
            Runnable emptier = trash.getEmptier();
            emptierThread = new Thread(emptier);
            emptierThread.start();
            Thread.sleep(timeAlive);
            emptierThread.interrupt();
            emptierThread.join();
            AuditableTrashPolicy at = (AuditableTrashPolicy)trash.getTrashPolicy();
            Assertions.assertEquals((int)expectedNumOfCheckpoints, (int)at.getNumberOfCheckpoints(), (String)String.format("Expected num of checkpoints is %s, but actual is %s", expectedNumOfCheckpoints, at.getNumberOfCheckpoints()));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (emptierThread != null) {
                emptierThread.interrupt();
            }
        }
    }

    private static class AuditableCheckpoints {
        private static final Logger LOG = LoggerFactory.getLogger(AuditableCheckpoints.class);
        private static AtomicInteger numOfCheckpoint = new AtomicInteger(0);

        private AuditableCheckpoints() {
        }

        private static void add() {
            numOfCheckpoint.incrementAndGet();
            LOG.info("Create a checkpoint, current number of checkpoints {}", (Object)numOfCheckpoint.get());
        }

        private static void delete() {
            if (numOfCheckpoint.get() > 0) {
                numOfCheckpoint.decrementAndGet();
                LOG.info("Delete a checkpoint, current number of checkpoints {}", (Object)numOfCheckpoint.get());
            }
        }

        private static void deleteAll() {
            numOfCheckpoint.set(0);
            LOG.info("Delete all checkpoints, current number of checkpoints {}", (Object)numOfCheckpoint.get());
        }

        private static int get() {
            return numOfCheckpoint.get();
        }
    }

    public static class AuditableTrashPolicy
    extends TrashPolicy {
        public AuditableTrashPolicy() {
        }

        public AuditableTrashPolicy(Configuration conf) throws IOException {
            this.initialize(conf, null);
        }

        @Deprecated
        public void initialize(Configuration conf, FileSystem fs, Path home) {
            this.deletionInterval = (long)conf.getFloat("fs.trash.interval", 0.0f);
        }

        public void initialize(Configuration conf, FileSystem fs) {
            this.deletionInterval = (long)conf.getFloat("fs.trash.interval", 0.0f);
        }

        public boolean moveToTrash(Path path) throws IOException {
            return false;
        }

        public void createCheckpoint() throws IOException {
            AuditableCheckpoints.add();
        }

        public void deleteCheckpoint() throws IOException {
            AuditableCheckpoints.delete();
        }

        public void deleteCheckpointsImmediately() throws IOException {
            AuditableCheckpoints.deleteAll();
        }

        public Path getCurrentTrashDir() {
            return null;
        }

        public Runnable getEmptier() throws IOException {
            return new AuditableEmptier(this.getConf());
        }

        public int getNumberOfCheckpoints() {
            return AuditableCheckpoints.get();
        }

        public boolean isEnabled() {
            return true;
        }

        private class AuditableEmptier
        implements Runnable {
            private Configuration conf = null;

            public AuditableEmptier(Configuration conf) {
                this.conf = conf;
            }

            @Override
            public void run() {
                AuditableTrashPolicy trash = null;
                try {
                    trash = new AuditableTrashPolicy(this.conf);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(AuditableTrashPolicy.this.deletionInterval);
                            trash.deleteCheckpoint();
                        }
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    break;
                }
            }
        }
    }

    public static class TestTrashPolicy
    extends TrashPolicy {
        public void initialize(Configuration conf, FileSystem fs, Path home) {
        }

        public void initialize(Configuration conf, FileSystem fs) {
        }

        public boolean isEnabled() {
            return false;
        }

        public boolean moveToTrash(Path path) throws IOException {
            return false;
        }

        public void createCheckpoint() throws IOException {
        }

        public void deleteCheckpoint() throws IOException {
        }

        public void deleteCheckpointsImmediately() throws IOException {
        }

        public Path getCurrentTrashDir() {
            return null;
        }

        public Path getCurrentTrashDir(Path path) throws IOException {
            return null;
        }

        public Runnable getEmptier() throws IOException {
            return null;
        }
    }

    public static class TestLFS
    extends LocalFileSystem {
        private URI uriName = null;
        Path home;

        TestLFS() {
            this(TEST_DIR);
        }

        TestLFS(final Path home) {
            super((FileSystem)new RawLocalFileSystem(){

                protected Path getInitialWorkingDirectory() {
                    return this.makeQualified(home);
                }

                public Path getHomeDirectory() {
                    return this.makeQualified(home);
                }
            });
            this.home = home;
        }

        public Path getHomeDirectory() {
            return this.home;
        }

        public URI getUri() {
            if (this.uriName == null) {
                return super.getUri();
            }
            return this.uriName;
        }

        public String getScheme() {
            return "testlfs";
        }

        public void setUri(String uri) {
            this.uriName = URI.create(uri);
        }
    }
}

