/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.StringReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestStat
extends FileSystemTestHelper {
    private static Stat stat;

    @BeforeAll
    public static void setup() throws Exception {
        stat = new Stat(new Path("/dummypath"), 4096L, false, FileSystem.get((Configuration)new Configuration()));
    }

    @Test
    @Timeout(value=10L)
    public void testStatLinux() throws Exception {
        String[] symlinks = new String[]{"6,symbolic link,1373584236,1373584236,777,andrew,andrew,`link' -> `target'", "6,symbolic link,1373584236,1373584236,777,andrew,andrew,'link' -> 'target'"};
        StatOutput linux = new StatOutput("stat: cannot stat `watermelon': No such file or directory", "4096,directory,1373584236,1373586485,755,andrew,root,`.'", "0,regular empty file,1373584228,1373584228,644,andrew,andrew,`target'", symlinks, "4096,directory,1374622334,1375124212,1755,andrew,andrew,`stickydir'");
        linux.test();
    }

    @Test
    @Timeout(value=10L)
    public void testStatFreeBSD() throws Exception {
        String[] symlinks = new String[]{"6,Symbolic Link,1373508941,1373508941,120755,awang,awang,`link' -> `target'"};
        StatOutput freebsd = new StatOutput("stat: symtest/link: stat: No such file or directory", "512,Directory,1373583695,1373583669,40755,awang,awang,`link' -> `'", "0,Regular File,1373508937,1373508937,100644,awang,awang,`link' -> `'", symlinks, "512,Directory,1375139537,1375139537,41755,awang,awang,`link' -> `'");
        freebsd.test();
    }

    @Test
    @Timeout(value=10L)
    public void testStatFileNotFound() throws Exception {
        Assumptions.assumeTrue((boolean)Stat.isAvailable());
        try {
            stat.getFileStatus();
            Assertions.fail((String)"Expected FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=10L)
    public void testStatEnvironment() throws Exception {
        Assertions.assertEquals((Object)"C", (Object)stat.getEnvironment("LANG"));
    }

    @Test
    @Timeout(value=10L)
    public void testStat() throws Exception {
        Assumptions.assumeTrue((boolean)Stat.isAvailable());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        Path testDir = new Path(this.getTestRootPath((FileSystem)fs), "teststat");
        fs.mkdirs(testDir);
        Path sub1 = new Path(testDir, "sub1");
        Path sub2 = new Path(testDir, "sub2");
        fs.mkdirs(sub1);
        fs.createSymlink(sub1, sub2, false);
        FileStatus stat1 = new Stat(sub1, 4096L, false, (FileSystem)fs).getFileStatus();
        FileStatus stat2 = new Stat(sub2, 0L, false, (FileSystem)fs).getFileStatus();
        Assertions.assertTrue((boolean)stat1.isDirectory());
        Assertions.assertFalse((boolean)stat2.isDirectory());
        fs.delete(testDir, true);
    }

    static {
        FileSystem.enableSymlinks();
    }

    private class StatOutput {
        final String doesNotExist;
        final String directory;
        final String file;
        final String[] symlinks;
        final String stickydir;

        StatOutput(String doesNotExist, String directory, String file, String[] symlinks, String stickydir) {
            this.doesNotExist = doesNotExist;
            this.directory = directory;
            this.file = file;
            this.symlinks = symlinks;
            this.stickydir = stickydir;
        }

        void test() throws Exception {
            BufferedReader br;
            try {
                br = new BufferedReader(new StringReader(this.doesNotExist));
                stat.parseExecResult(br);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            br = new BufferedReader(new StringReader(this.directory));
            stat.parseExecResult(br);
            FileStatus status = stat.getFileStatusForTesting();
            Assertions.assertTrue((boolean)status.isDirectory());
            br = new BufferedReader(new StringReader(this.file));
            stat.parseExecResult(br);
            status = stat.getFileStatusForTesting();
            Assertions.assertTrue((boolean)status.isFile());
            for (String symlink : this.symlinks) {
                br = new BufferedReader(new StringReader(symlink));
                stat.parseExecResult(br);
                status = stat.getFileStatusForTesting();
                Assertions.assertTrue((boolean)status.isSymlink());
            }
            br = new BufferedReader(new StringReader(this.stickydir));
            stat.parseExecResult(br);
            status = stat.getFileStatusForTesting();
            Assertions.assertTrue((boolean)status.isDirectory());
            Assertions.assertTrue((boolean)status.getPermission().getStickyBit());
        }
    }
}

