/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Shell;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestLocalDirAllocator {
    private static final Configuration conf = new Configuration();
    private static final String BUFFER_DIR_ROOT = "build/test/temp";
    private static final String ABSOLUTE_DIR_ROOT;
    private static final String QUALIFIED_DIR_ROOT;
    private static final Path BUFFER_PATH_ROOT;
    private static final File BUFFER_ROOT;
    private static final String CONTEXT = "mapred.local.dir";
    private static final String FILENAME = "block";
    private static final LocalDirAllocator dirAllocator;
    static LocalFileSystem localFs;
    static final int SMALL_FILE_SIZE = 100;
    private static final String RELATIVE = "/RELATIVE";
    private static final String ABSOLUTE = "/ABSOLUTE";
    private static final String QUALIFIED = "/QUALIFIED";
    private String root;
    private String prefix;
    static final int TRIALS = 100;

    public void initTestLocalDirAllocator(String paramRoot, String paramPrefix) {
        this.root = paramRoot;
        this.prefix = paramPrefix;
    }

    public static Collection<Object[]> params() {
        Object[][] data = new Object[][]{{BUFFER_DIR_ROOT, RELATIVE}, {ABSOLUTE_DIR_ROOT, ABSOLUTE}, {QUALIFIED_DIR_ROOT, QUALIFIED}};
        return Arrays.asList(data);
    }

    private static void rmBufferDirs() throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((!localFs.exists(BUFFER_PATH_ROOT) || localFs.delete(BUFFER_PATH_ROOT, true) ? 1 : 0) != 0);
    }

    private static void validateTempDirCreation(String dir) throws IOException {
        File result = TestLocalDirAllocator.createTempFile(100L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.getPath().startsWith(new Path(dir, FILENAME).toUri().getPath()), (String)("Checking for " + dir + " in " + result + " - FAILED!"));
    }

    private static File createTempFile() throws IOException {
        return TestLocalDirAllocator.createTempFile(-1L);
    }

    private static File createTempFile(long size) throws IOException {
        File result = dirAllocator.createTmpFileForWrite(FILENAME, size, conf);
        result.delete();
        return result;
    }

    private String buildBufferDir(String dir, int i) {
        return dir + this.prefix + i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void test0(String paramRoot, String paramPrefix) throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir0 = this.buildBufferDir(this.root, 0);
        String dir1 = this.buildBufferDir(this.root, 1);
        try {
            conf.set(CONTEXT, dir0 + "," + dir1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir1)));
            BUFFER_ROOT.setReadOnly();
            TestLocalDirAllocator.validateTempDirCreation(dir1);
            TestLocalDirAllocator.validateTempDirCreation(dir1);
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testROBufferDirAndRWBufferDir(String paramRoot, String paramPrefix) throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir1 = this.buildBufferDir(this.root, 1);
        String dir2 = this.buildBufferDir(this.root, 2);
        try {
            conf.set(CONTEXT, dir1 + "," + dir2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir2)));
            BUFFER_ROOT.setReadOnly();
            TestLocalDirAllocator.validateTempDirCreation(dir2);
            TestLocalDirAllocator.validateTempDirCreation(dir2);
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testDirsNotExist(String paramRoot, String paramPrefix) throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir2 = this.buildBufferDir(this.root, 2);
        String dir3 = this.buildBufferDir(this.root, 3);
        try {
            conf.set(CONTEXT, dir2 + "," + dir3);
            TestLocalDirAllocator.createTempFile(100L);
            int firstDirIdx = dirAllocator.getCurrentDirectoryIndex() == 0 ? 2 : 3;
            int secondDirIdx = firstDirIdx == 2 ? 3 : 2;
            TestLocalDirAllocator.validateTempDirCreation(this.buildBufferDir(this.root, firstDirIdx));
            TestLocalDirAllocator.validateTempDirCreation(this.buildBufferDir(this.root, secondDirIdx));
            TestLocalDirAllocator.validateTempDirCreation(this.buildBufferDir(this.root, firstDirIdx));
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testRWBufferDirBecomesRO(String paramRoot, String paramPrefix) throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir3 = this.buildBufferDir(this.root, 3);
        String dir4 = this.buildBufferDir(this.root, 4);
        try {
            conf.set(CONTEXT, dir3 + "," + dir4);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir3)));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir4)));
            TestLocalDirAllocator.createTempFile(100L);
            int nextDirIdx = dirAllocator.getCurrentDirectoryIndex() == 0 ? 3 : 4;
            TestLocalDirAllocator.validateTempDirCreation(this.buildBufferDir(this.root, nextDirIdx));
            new File(new Path(dir4).toUri().getPath()).setReadOnly();
            TestLocalDirAllocator.validateTempDirCreation(dir3);
            TestLocalDirAllocator.validateTempDirCreation(dir3);
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testCreateManyFiles(String paramRoot, String paramPrefix) throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir5 = this.buildBufferDir(this.root, 5);
        String dir6 = this.buildBufferDir(this.root, 6);
        try {
            conf.set(CONTEXT, dir5 + "," + dir6);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir5)));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir6)));
            int inDir5 = 0;
            int inDir6 = 0;
            for (int i = 0; i < 100; ++i) {
                File result = TestLocalDirAllocator.createTempFile();
                if (result.getPath().startsWith(new Path(dir5, FILENAME).toUri().getPath())) {
                    ++inDir5;
                } else if (result.getPath().startsWith(new Path(dir6, FILENAME).toUri().getPath())) {
                    ++inDir6;
                }
                result.delete();
            }
            org.junit.jupiter.api.Assertions.assertTrue((inDir5 + inDir6 == 100 ? 1 : 0) != 0);
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testCreateManyFilesRandom(String paramRoot, String paramPrefix) throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        int numDirs = 5;
        int numTries = 100;
        String[] dirs = new String[5];
        for (int d = 0; d < 5; ++d) {
            dirs[d] = this.buildBufferDir(this.root, d);
        }
        boolean next_dir_not_selected_at_least_once = false;
        try {
            conf.set(CONTEXT, dirs[0] + "," + dirs[1] + "," + dirs[2] + "," + dirs[3] + "," + dirs[4]);
            Path[] paths = new Path[5];
            for (int d = 0; d < 5; ++d) {
                paths[d] = new Path(dirs[d]);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(paths[d]));
            }
            int inDir = 0;
            int prevDir = -1;
            int[] counts = new int[5];
            for (int i = 0; i < 100; ++i) {
                File result = TestLocalDirAllocator.createTempFile(100L);
                for (int d = 0; d < 5; ++d) {
                    if (!result.getPath().startsWith(paths[d].toUri().getPath())) continue;
                    inDir = d;
                    break;
                }
                org.junit.jupiter.api.Assertions.assertNotEquals((int)prevDir, (int)inDir);
                if (prevDir != -1 && inDir != (prevDir + 1) % 5) {
                    next_dir_not_selected_at_least_once = true;
                }
                prevDir = inDir;
                int n = inDir;
                counts[n] = counts[n] + 1;
                result.delete();
            }
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)next_dir_not_selected_at_least_once);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testLocalPathForWriteDirCreation(String paramRoot, String paramPrefix) throws IOException {
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir0 = this.buildBufferDir(this.root, 0);
        String dir1 = this.buildBufferDir(this.root, 1);
        try {
            conf.set(CONTEXT, dir0 + "," + dir1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir1)));
            BUFFER_ROOT.setReadOnly();
            Path p1 = dirAllocator.getLocalPathForWrite("p1/x", 100L, conf);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.getFileStatus(p1.getParent()).isDirectory());
            Path p2 = dirAllocator.getLocalPathForWrite("p2/x", 100L, conf, false);
            try {
                localFs.getFileStatus(p2.getParent());
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.assertEquals(e.getClass(), FileNotFoundException.class);
            }
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testShouldNotthrowNPE(String paramRoot, String paramPrefix) throws Exception {
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        Configuration conf1 = new Configuration();
        try {
            dirAllocator.getLocalPathForWrite("/test", conf1);
            org.junit.jupiter.api.Assertions.fail((String)"Exception not thrown when mapred.local.dir is not set");
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"mapred.local.dir not configured", (Object)e.getMessage());
        }
        catch (NullPointerException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Lack of configuration should not have thrown a NPE.");
        }
        String NEW_CONTEXT = "mapred.local.dir.new";
        conf1.set(NEW_CONTEXT, "");
        LocalDirAllocator newDirAllocator = new LocalDirAllocator(NEW_CONTEXT);
        try {
            newDirAllocator.getLocalPathForWrite("/test", conf1);
            org.junit.jupiter.api.Assertions.fail((String)("Exception not thrown when " + NEW_CONTEXT + " is set to empty string"));
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(e instanceof DiskChecker.DiskErrorException));
        }
        catch (NullPointerException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Wrong configuration should not have thrown a NPE.");
        }
        try {
            newDirAllocator.getLocalPathToRead("/test", conf1);
            org.junit.jupiter.api.Assertions.fail((String)("Exception not thrown when " + NEW_CONTEXT + " is set to empty string"));
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(e instanceof DiskChecker.DiskErrorException));
        }
        catch (NullPointerException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Wrong configuration should not have thrown a NPE.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testNoSideEffects(String paramRoot, String paramPrefix) throws IOException {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir = this.buildBufferDir(this.root, 0);
        try {
            conf.set(CONTEXT, dir);
            File result = dirAllocator.createTmpFileForWrite(FILENAME, -1L, conf);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.delete());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.getParentFile().delete());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)new File(dir).exists());
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testGetLocalPathToRead(String paramRoot, String paramPrefix) throws IOException {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir = this.buildBufferDir(this.root, 0);
        try {
            conf.set(CONTEXT, dir);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir)));
            File f1 = dirAllocator.createTmpFileForWrite(FILENAME, 100L, conf);
            Path p1 = dirAllocator.getLocalPathToRead(f1.getName(), conf);
            org.junit.jupiter.api.Assertions.assertEquals((Object)f1.getName(), (Object)p1.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"file", (Object)p1.getFileSystem(conf).getUri().getScheme());
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testGetAllLocalPathsToRead(String paramRoot, String paramPrefix) throws IOException {
        PlatformAssumptions.assumeNotWindows();
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir0 = this.buildBufferDir(this.root, 0);
        String dir1 = this.buildBufferDir(this.root, 1);
        try {
            conf.set(CONTEXT, dir0 + "," + dir1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir0)));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.mkdirs(new Path(dir1)));
            localFs.create(new Path(dir0 + "/" + FILENAME));
            localFs.create(new Path(dir1 + "/" + FILENAME));
            Iterable pathIterable = dirAllocator.getAllLocalPathsToRead(FILENAME, conf);
            int count = 0;
            for (Path p : pathIterable) {
                ++count;
                org.junit.jupiter.api.Assertions.assertEquals((Object)FILENAME, (Object)p.getName());
                org.junit.jupiter.api.Assertions.assertEquals((Object)"file", (Object)p.getFileSystem(conf).getUri().getScheme());
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)count);
            try {
                Path p = (Path)pathIterable.iterator().next();
                org.junit.jupiter.api.Assertions.assertFalse((boolean)true, (String)("NoSuchElementException must be thrown, but returned [" + p + "] instead."));
            }
            catch (NoSuchElementException p) {
                // empty catch block
            }
            Iterable pathIterable2 = dirAllocator.getAllLocalPathsToRead(FILENAME, conf);
            Iterator it = pathIterable2.iterator();
            try {
                it.remove();
                org.junit.jupiter.api.Assertions.assertFalse((boolean)true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            Shell.execCommand((String[])new String[]{"chmod", "u+w", BUFFER_DIR_ROOT});
            TestLocalDirAllocator.rmBufferDirs();
            throw throwable;
        }
        Shell.execCommand((String[])new String[]{"chmod", "u+w", BUFFER_DIR_ROOT});
        TestLocalDirAllocator.rmBufferDirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testRemoveContext(String paramRoot, String paramPrefix) throws IOException {
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir = this.buildBufferDir(this.root, 0);
        try {
            String contextCfgItemName = "application_1340842292563_0004.app.cache.dirs";
            conf.set(contextCfgItemName, dir);
            LocalDirAllocator localDirAllocator = new LocalDirAllocator(contextCfgItemName);
            localDirAllocator.getLocalPathForWrite("p1/x", 100L, conf);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)LocalDirAllocator.isContextValid((String)contextCfgItemName));
            LocalDirAllocator.removeContext((String)contextCfgItemName);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)LocalDirAllocator.isContextValid((String)contextCfgItemName));
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testGetLocalPathForWriteForInvalidPaths(String paramRoot, String paramPrefix) throws Exception {
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        conf.set(CONTEXT, " ");
        LambdaTestUtils.intercept(IOException.class, "No space available in any of the local directories", () -> dirAllocator.getLocalPathForWrite("/test", conf));
    }

    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testGetLocalPathForWriteForLessSpace(String paramRoot, String paramPrefix) throws Exception {
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir0 = this.buildBufferDir(this.root, 0);
        String dir1 = this.buildBufferDir(this.root, 1);
        conf.set(CONTEXT, dir0 + "," + dir1);
        DiskChecker.DiskErrorException ex = LambdaTestUtils.intercept(DiskChecker.DiskErrorException.class, String.format("Could not find any valid local directory for %s with requested size %s", "p1/x", 0x7FFFFFFFFFFFFFFEL), "Expect a DiskErrorException.", () -> dirAllocator.getLocalPathForWrite("p1/x", 0x7FFFFFFFFFFFFFFEL, conf));
        ((AbstractStringAssert)Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{new File(dir0).getName()})).contains(new CharSequence[]{new File(dir1).getName()});
    }

    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testDirectoryRecovery(String paramRoot, String paramPrefix) throws Throwable {
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir0 = this.buildBufferDir(this.root, 0);
        String subdir = dir0 + "/subdir1/subdir2";
        conf.set(CONTEXT, subdir);
        Path pathForWrite = dirAllocator.getLocalPathForWrite("file", -1L, conf);
        Path ancestor = pathForWrite.getParent().getParent();
        localFs.delete(ancestor, true);
        dirAllocator.getLocalPathForWrite("file2", -1L, conf);
    }

    @Timeout(value=30L)
    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testDirectoryRecoveryKnownSize(String paramRoot, String paramPrefix) throws Throwable {
        this.initTestLocalDirAllocator(paramRoot, paramPrefix);
        String dir0 = this.buildBufferDir(this.root, 0);
        String subdir = dir0 + "/subdir1/subdir2";
        conf.set(CONTEXT, subdir);
        Path pathForWrite = dirAllocator.getLocalPathForWrite("file", 512L, conf);
        Path ancestor = pathForWrite.getParent().getParent();
        localFs.delete(ancestor, true);
        dirAllocator.getLocalPathForWrite("file2", -1L, conf);
    }

    static {
        BUFFER_PATH_ROOT = new Path(BUFFER_DIR_ROOT);
        BUFFER_ROOT = new File(BUFFER_DIR_ROOT);
        dirAllocator = new LocalDirAllocator(CONTEXT);
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
            TestLocalDirAllocator.rmBufferDirs();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        ABSOLUTE_DIR_ROOT = new Path(localFs.getWorkingDirectory(), BUFFER_DIR_ROOT).toUri().getPath();
        QUALIFIED_DIR_ROOT = new Path(localFs.getWorkingDirectory(), BUFFER_DIR_ROOT).toUri().toString();
    }
}

