/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHardLink {
    private static final File TEST_DIR = GenericTestUtils.getTestDir("test/hl");
    private static String DIR = "dir_";
    private static File src = new File(TEST_DIR, DIR + "src");
    private static File tgt_mult = new File(TEST_DIR, DIR + "tgt_mult");
    private static File tgt_one = new File(TEST_DIR, DIR + "tgt_one");
    private static File x1 = new File(src, "x1");
    private static File x2 = new File(src, "x2");
    private static File x3 = new File(src, "x3");
    private static File x1_one = new File(tgt_one, "x1");
    private static File y_one = new File(tgt_one, "y");
    private static File x3_one = new File(tgt_one, "x3");
    private static File x11_one = new File(tgt_one, "x11");
    private static File x1_mult = new File(tgt_mult, "x1");
    private static File x2_mult = new File(tgt_mult, "x2");
    private static File x3_mult = new File(tgt_mult, "x3");
    private static String str1 = "11111";
    private static String str2 = "22222";
    private static String str3 = "33333";

    @BeforeAll
    public static void setupClean() {
        FileUtil.fullyDelete((File)src);
        FileUtil.fullyDelete((File)tgt_one);
        FileUtil.fullyDelete((File)tgt_mult);
        Assertions.assertFalse((boolean)src.exists());
        Assertions.assertFalse((boolean)tgt_one.exists());
        Assertions.assertFalse((boolean)tgt_mult.exists());
    }

    @BeforeEach
    public void setupDirs() throws IOException {
        Assertions.assertFalse((boolean)src.exists());
        Assertions.assertFalse((boolean)tgt_one.exists());
        Assertions.assertFalse((boolean)tgt_mult.exists());
        src.mkdirs();
        tgt_one.mkdirs();
        tgt_mult.mkdirs();
        this.makeNonEmptyFile(x1, str1);
        this.makeNonEmptyFile(x2, str2);
        this.makeNonEmptyFile(x3, str3);
        this.validateSetup();
    }

    private void validateSetup() throws IOException {
        Assertions.assertTrue((boolean)src.exists());
        Assertions.assertEquals((int)3, (int)src.list().length);
        Assertions.assertTrue((boolean)x1.exists());
        Assertions.assertTrue((boolean)x2.exists());
        Assertions.assertTrue((boolean)x3.exists());
        Assertions.assertTrue((boolean)this.fetchFileContents(x1).equals(str1));
        Assertions.assertTrue((boolean)this.fetchFileContents(x2).equals(str2));
        Assertions.assertTrue((boolean)this.fetchFileContents(x3).equals(str3));
        Assertions.assertTrue((boolean)tgt_one.exists());
        Assertions.assertTrue((boolean)tgt_mult.exists());
        Assertions.assertEquals((int)0, (int)tgt_one.list().length);
        Assertions.assertEquals((int)0, (int)tgt_mult.list().length);
    }

    private void validateTgtOne() throws IOException {
        Assertions.assertTrue((boolean)tgt_one.exists());
        Assertions.assertEquals((int)4, (int)tgt_one.list().length);
        Assertions.assertTrue((boolean)x1_one.exists());
        Assertions.assertTrue((boolean)x11_one.exists());
        Assertions.assertTrue((boolean)y_one.exists());
        Assertions.assertTrue((boolean)x3_one.exists());
        Assertions.assertTrue((boolean)this.fetchFileContents(x1_one).equals(str1));
        Assertions.assertTrue((boolean)this.fetchFileContents(x11_one).equals(str1));
        Assertions.assertTrue((boolean)this.fetchFileContents(y_one).equals(str2));
        Assertions.assertTrue((boolean)this.fetchFileContents(x3_one).equals(str3));
    }

    private void validateTgtMult() throws IOException {
        Assertions.assertTrue((boolean)tgt_mult.exists());
        Assertions.assertEquals((int)3, (int)tgt_mult.list().length);
        Assertions.assertTrue((boolean)x1_mult.exists());
        Assertions.assertTrue((boolean)x2_mult.exists());
        Assertions.assertTrue((boolean)x3_mult.exists());
        Assertions.assertTrue((boolean)this.fetchFileContents(x1_mult).equals(str1));
        Assertions.assertTrue((boolean)this.fetchFileContents(x2_mult).equals(str2));
        Assertions.assertTrue((boolean)this.fetchFileContents(x3_mult).equals(str3));
    }

    @AfterEach
    public void tearDown() throws IOException {
        TestHardLink.setupClean();
    }

    private void makeNonEmptyFile(File file, String contents) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(contents);
        fw.close();
    }

    private void appendToFile(File file, String contents) throws IOException {
        FileWriter fw = new FileWriter(file, true);
        fw.write(contents);
        fw.close();
    }

    private String fetchFileContents(File file) throws IOException {
        char[] buf = new char[20];
        FileReader fr = new FileReader(file);
        int cnt = fr.read(buf);
        fr.close();
        char[] result = Arrays.copyOf(buf, cnt);
        return new String(result);
    }

    @Test
    public void testGetLinkCount() throws IOException {
        Assertions.assertEquals((int)1, (int)HardLink.getLinkCount((File)x1));
        Assertions.assertEquals((int)1, (int)HardLink.getLinkCount((File)x2));
        Assertions.assertEquals((int)1, (int)HardLink.getLinkCount((File)x3));
    }

    @Test
    public void testGetLinkCountFromFileAttribute() throws IOException {
        Assertions.assertTrue((boolean)HardLink.supportsHardLink((File)x1));
        Assertions.assertEquals((int)1, (int)HardLink.getLinkCount((File)x1));
        Assertions.assertTrue((boolean)HardLink.supportsHardLink((File)x2));
        Assertions.assertEquals((int)1, (int)HardLink.getLinkCount((File)x2));
        Assertions.assertTrue((boolean)HardLink.supportsHardLink((File)x3));
        Assertions.assertEquals((int)1, (int)HardLink.getLinkCount((File)x3));
    }

    @Test
    public void testCreateHardLink() throws IOException {
        HardLink.createHardLink((File)x1, (File)x1_one);
        Assertions.assertTrue((boolean)x1_one.exists());
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x1));
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x1_one));
        Assertions.assertEquals((int)1, (int)HardLink.getLinkCount((File)x2));
        HardLink.createHardLink((File)x2, (File)y_one);
        HardLink.createHardLink((File)x3, (File)x3_one);
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x2));
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x3));
        HardLink.createHardLink((File)x1, (File)x11_one);
        Assertions.assertEquals((int)3, (int)HardLink.getLinkCount((File)x1));
        Assertions.assertEquals((int)3, (int)HardLink.getLinkCount((File)x1_one));
        Assertions.assertEquals((int)3, (int)HardLink.getLinkCount((File)x11_one));
        this.validateTgtOne();
        this.appendToFile(x1_one, str3);
        Assertions.assertTrue((boolean)this.fetchFileContents(x1_one).equals(str1 + str3));
        Assertions.assertTrue((boolean)this.fetchFileContents(x11_one).equals(str1 + str3));
        Assertions.assertTrue((boolean)this.fetchFileContents(x1).equals(str1 + str3));
    }

    @Test
    public void testCreateHardLinkMult() throws IOException {
        String[] fileNames = src.list();
        HardLink.createHardLinkMult((File)src, (String[])fileNames, (File)tgt_mult);
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x1));
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x2));
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x3));
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x1_mult));
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x2_mult));
        Assertions.assertEquals((int)2, (int)HardLink.getLinkCount((File)x3_mult));
        this.validateTgtMult();
        this.appendToFile(x1_mult, str3);
        Assertions.assertTrue((boolean)this.fetchFileContents(x1_mult).equals(str1 + str3));
        Assertions.assertTrue((boolean)this.fetchFileContents(x1).equals(str1 + str3));
    }

    @Test
    public void testCreateHardLinkMultEmptyList() throws IOException {
        String[] emptyList = new String[]{};
        HardLink.createHardLinkMult((File)src, (String[])emptyList, (File)tgt_mult);
        this.validateSetup();
    }

    @Test
    public void testWindowsSyntax() {
        class Win
        extends HardLink.HardLinkCGWin {
            Win() {
            }
        }
        Assertions.assertEquals((int)4, (int)Win.getLinkCountCommand.length);
        Assertions.assertEquals((int)2, (int)"%f".length());
        Assertions.assertEquals((int)3, (int)"\\%f".length());
        Assertions.assertEquals((Object)"hardlink", (Object)Win.getLinkCountCommand[1]);
        Assertions.assertEquals((int)4, (int)"-c%h".length());
    }
}

