/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.GlobExpander;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGlobExpander {
    @Test
    public void testExpansionIsIdentical() throws IOException {
        this.checkExpansionIsIdentical("");
        this.checkExpansionIsIdentical("/}");
        this.checkExpansionIsIdentical("/}{a,b}");
        this.checkExpansionIsIdentical("{/");
        this.checkExpansionIsIdentical("{a}");
        this.checkExpansionIsIdentical("{a,b}/{b,c}");
        this.checkExpansionIsIdentical("p\\{a/b,c/d\\}s");
        this.checkExpansionIsIdentical("p{a\\/b,c\\/d}s");
    }

    @Test
    public void testExpansion() throws IOException {
        this.checkExpansion("{a/b}", "a/b");
        this.checkExpansion("/}{a/b}", "/}a/b");
        this.checkExpansion("p{a/b,c/d}s", "pa/bs", "pc/ds");
        this.checkExpansion("{a/b,c/d,{e,f}}", "a/b", "c/d", "{e,f}");
        this.checkExpansion("{a/b,c/d}{e,f}", "a/b{e,f}", "c/d{e,f}");
        this.checkExpansion("{a,b}/{b,{c/d,e/f}}", "{a,b}/b", "{a,b}/c/d", "{a,b}/e/f");
        this.checkExpansion("{a,b}/{c/\\d}", "{a,b}/c/d");
    }

    private void checkExpansionIsIdentical(String filePattern) throws IOException {
        this.checkExpansion(filePattern, filePattern);
    }

    private void checkExpansion(String filePattern, String ... expectedExpansions) throws IOException {
        List actualExpansions = GlobExpander.expand((String)filePattern);
        Assertions.assertEquals((int)expectedExpansions.length, (int)actualExpansions.size(), (String)"Different number of expansions");
        for (int i = 0; i < expectedExpansions.length; ++i) {
            Assertions.assertEquals((Object)expectedExpansions[i], actualExpansions.get(i), (String)("Expansion of " + filePattern));
        }
    }
}

