/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestGetSpaceUsed {
    private static final File DIR = GenericTestUtils.getTestDir("TestGetSpaceUsed");

    @BeforeEach
    public void setUp() {
        FileUtil.fullyDelete((File)DIR);
        Assertions.assertTrue((boolean)DIR.mkdirs());
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DIR);
    }

    @Test
    public void testBuilderConf() throws Exception {
        File file = new File(DIR, "testBuilderConf");
        Assertions.assertTrue((boolean)file.createNewFile());
        Configuration conf = new Configuration();
        conf.set("fs.getspaceused.classname", DummyDU.class.getName());
        CachingGetSpaceUsed instance = (CachingGetSpaceUsed)new GetSpaceUsed.Builder().setPath(file).setInterval(0L).setConf(conf).build();
        Assertions.assertNotNull((Object)instance);
        Assertions.assertTrue((boolean)(instance instanceof DummyDU));
        Assertions.assertFalse((boolean)instance.running());
        instance.close();
    }

    @Test
    public void testBuildInitial() throws Exception {
        File file = new File(DIR, "testBuildInitial");
        Assertions.assertTrue((boolean)file.createNewFile());
        CachingGetSpaceUsed instance = (CachingGetSpaceUsed)new GetSpaceUsed.Builder().setPath(file).setInitialUsed(90210L).setKlass(DummyDU.class).build();
        Assertions.assertEquals((long)90210L, (long)instance.getUsed());
        instance.close();
    }

    @Test
    public void testBuildInterval() throws Exception {
        File file = new File(DIR, "testBuildInitial");
        Assertions.assertTrue((boolean)file.createNewFile());
        CachingGetSpaceUsed instance = (CachingGetSpaceUsed)new GetSpaceUsed.Builder().setPath(file).setInitialUsed(90210L).setInterval(50060L).setKlass(DummyDU.class).build();
        Assertions.assertEquals((long)50060L, (long)instance.getRefreshInterval());
        instance.close();
    }

    @Test
    public void testBuildNonCaching() throws Exception {
        File file = new File(DIR, "testBuildNonCaching");
        Assertions.assertTrue((boolean)file.createNewFile());
        GetSpaceUsed instance = new GetSpaceUsed.Builder().setPath(file).setInitialUsed(90210L).setInterval(50060L).setKlass(DummyGetSpaceUsed.class).build();
        Assertions.assertEquals((long)300L, (long)instance.getUsed());
        Assertions.assertTrue((boolean)(instance instanceof DummyGetSpaceUsed));
    }

    private static class DummyGetSpaceUsed
    implements GetSpaceUsed {
        public DummyGetSpaceUsed(GetSpaceUsed.Builder builder) {
        }

        public long getUsed() throws IOException {
            return 300L;
        }
    }

    private static class DummyDU
    extends CachingGetSpaceUsed {
        public DummyDU(GetSpaceUsed.Builder builder) throws IOException {
            super(builder);
        }

        protected void refresh() {
        }
    }
}

