/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.HadoopTestBase;
import org.junit.jupiter.api.Test;

public class TestGetEnclosingRoot
extends HadoopTestBase {
    @Test
    public void testEnclosingRootEquivalence() throws IOException {
        FileSystem fs = this.getFileSystem();
        Path root = this.path("/");
        Path foobar = this.path("/foo/bar");
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(root));
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(foobar));
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(fs.getEnclosingRoot(foobar)));
        TestGetEnclosingRoot.assertEquals((Object)fs.getEnclosingRoot(root), (Object)fs.getEnclosingRoot(foobar));
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(this.path(foobar.toString())));
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(fs.getEnclosingRoot(this.path(foobar.toString()))));
        TestGetEnclosingRoot.assertEquals((Object)fs.getEnclosingRoot(root), (Object)fs.getEnclosingRoot(this.path(foobar.toString())));
    }

    @Test
    public void testEnclosingRootPathExists() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path root = this.path("/");
        Path foobar = this.path("/foo/bar");
        fs.mkdirs(foobar);
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(foobar));
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(this.path(foobar.toString())));
    }

    @Test
    public void testEnclosingRootPathDNE() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path foobar = this.path("/foo/bar");
        Path root = this.path("/");
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(foobar));
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(this.path(foobar.toString())));
    }

    @Test
    public void testEnclosingRootWrapped() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path root = this.path("/");
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(new Path("/foo/bar")));
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"foo");
        Path p = (Path)ugi.doAs(() -> {
            FileSystem wFs = this.getFileSystem();
            return wFs.getEnclosingRoot(new Path("/foo/bar"));
        });
        TestGetEnclosingRoot.assertEquals((Object)root, (Object)p);
    }

    private FileSystem getFileSystem() throws IOException {
        return FileSystem.get((Configuration)new Configuration());
    }

    private Path path(String filepath) throws IOException {
        return this.getFileSystem().makeQualified(new Path(filepath));
    }
}

