/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.text.ParseException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.TouchCommands;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFsShellTouch {
    static final Logger LOG = LoggerFactory.getLogger(TestFsShellTouch.class);
    static FsShell shell;
    static LocalFileSystem lfs;
    static Path testRootDir;

    @BeforeAll
    public static void setup() throws Exception {
        Configuration conf = new Configuration();
        shell = new FsShell(conf);
        lfs = FileSystem.getLocal((Configuration)conf);
        testRootDir = lfs.makeQualified(new Path(GenericTestUtils.getTempPath("testFsShell")));
        lfs.mkdirs(testRootDir);
        lfs.setWorkingDirectory(testRootDir);
    }

    @BeforeEach
    public void prepFiles() throws Exception {
        lfs.setVerifyChecksum(true);
        lfs.setWriteChecksum(true);
    }

    private int shellRun(String ... args) throws Exception {
        int exitCode = shell.run(args);
        LOG.info("exit " + exitCode + " - " + StringUtils.join((CharSequence)" ", (String[])args));
        return exitCode;
    }

    @Test
    public void testTouchz() throws Exception {
        String newFileName = "newFile";
        Path newFile = new Path("newFile");
        lfs.delete(newFile, true);
        Assertions.assertThat((boolean)lfs.exists(newFile)).isFalse();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touchz", "newFile")).as("Expected successful touchz on a new file", new Object[0])).isEqualTo(0);
        this.shellRun("-ls", "newFile");
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touchz", "newFile")).as("Expected successful touchz on an existing zero-length file", new Object[0])).isEqualTo(0);
        String noDirName = "noDir";
        Path noDir = new Path("noDir");
        lfs.delete(noDir, true);
        Assertions.assertThat((boolean)lfs.exists(noDir)).isFalse();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touchz", "noDir/foo")).as("Expected failed touchz in a non-existent directory", new Object[0])).isNotEqualTo(0);
    }

    @Test
    public void testTouch() throws Exception {
        String newFileName = "newFile2";
        Path newFile = new Path("newFile2");
        lfs.delete(newFile, true);
        Assertions.assertThat((boolean)lfs.exists(newFile)).isFalse();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-c", "newFile2")).as("Expected successful touch on a non-existent file with -c option", new Object[0])).isEqualTo(0);
        Assertions.assertThat((boolean)lfs.exists(newFile)).isFalse();
        String strTime = this.formatTimestamp(System.currentTimeMillis());
        Date dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-t", strTime, "newFile2")).as("Expected successful touch on a new file with a specified timestamp", new Object[0])).isEqualTo(0);
        FileStatus new_status = lfs.getFileStatus(newFile);
        Assertions.assertThat((long)new_status.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)new_status.getModificationTime()).isEqualTo(dateObj.getTime());
        FileStatus fstatus = lfs.getFileStatus(newFile);
        String strTime2 = this.formatTimestamp(System.currentTimeMillis());
        Date dateObj2 = this.parseTimestamp(strTime2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-a", "-t", strTime2, "newFile2")).as("Expected successful touch with a specified access time", new Object[0])).isEqualTo(0);
        FileStatus new_status2 = lfs.getFileStatus(newFile);
        Assertions.assertThat((long)new_status2.getAccessTime()).isEqualTo(dateObj2.getTime());
        Assertions.assertThat((long)new_status2.getModificationTime()).isEqualTo(fstatus.getModificationTime());
        fstatus = lfs.getFileStatus(newFile);
        strTime2 = this.formatTimestamp(System.currentTimeMillis());
        dateObj2 = this.parseTimestamp(strTime2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-m", "-t", strTime2, "newFile2")).as("Expected successful touch with a specified modification time", new Object[0])).isEqualTo(0);
        new_status2 = lfs.getFileStatus(newFile);
        Assertions.assertThat((long)new_status2.getAccessTime()).isEqualTo(fstatus.getAccessTime());
        Assertions.assertThat((long)new_status2.getModificationTime()).isEqualTo(dateObj2.getTime());
        strTime2 = this.formatTimestamp(System.currentTimeMillis());
        dateObj2 = this.parseTimestamp(strTime2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-t", strTime2, "newFile2")).as("Expected successful touch with a specified timestamp", new Object[0])).isEqualTo(0);
        new_status2 = lfs.getFileStatus(newFile);
        Assertions.assertThat((long)new_status2.getAccessTime()).isEqualTo(dateObj2.getTime());
        Assertions.assertThat((long)new_status2.getModificationTime()).isEqualTo(dateObj2.getTime());
        strTime2 = this.formatTimestamp(System.currentTimeMillis());
        dateObj2 = this.parseTimestamp(strTime2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-a", "-m", "-t", strTime2, "newFile2")).as("Expected successful touch with a specified timestamp", new Object[0])).isEqualTo(0);
        new_status2 = lfs.getFileStatus(newFile);
        Assertions.assertThat((long)new_status2.getAccessTime()).isEqualTo(dateObj2.getTime());
        Assertions.assertThat((long)new_status2.getModificationTime()).isEqualTo(dateObj2.getTime());
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-t", "newFile2")).as("Expected failed touch with a missing timestamp", new Object[0])).isNotEqualTo(0);
        strTime2 = this.formatTimestamp(System.currentTimeMillis());
        dateObj2 = this.parseTimestamp(strTime2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-c", "-t", strTime2, "newFile2")).as("Expected successful touch on a non-existent file with -c option", new Object[0])).isEqualTo(0);
        FileStatus fileStatus = lfs.getFileStatus(newFile);
        Assertions.assertThat((long)fileStatus.getAccessTime()).isEqualTo(dateObj2.getTime());
        Assertions.assertThat((long)fileStatus.getModificationTime()).isEqualTo(dateObj2.getTime());
        lfs.delete(newFile, true);
        Assertions.assertThat((boolean)lfs.exists(newFile)).isFalse();
    }

    @Test
    public void testTouchDir() throws Exception {
        String newFileName = "dir3/newFile3";
        Path newFile = new Path("dir3/newFile3");
        Path dirPath = new Path("dir3");
        lfs.delete(dirPath, true);
        lfs.mkdirs(dirPath);
        lfs.delete(newFile, true);
        Assertions.assertThat((boolean)lfs.exists(newFile)).isFalse();
        String strTime = this.formatTimestamp(System.currentTimeMillis());
        Date dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-t", strTime, "dir3/newFile3")).as("Expected successful touch on a new file with a specified timestamp", new Object[0])).isEqualTo(0);
        FileStatus newStatus = lfs.getFileStatus(newFile);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        Thread.sleep(500L);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-m", "-a", "-t", strTime, "dir3")).as("Expected successful touch with a specified modification time", new Object[0])).isEqualTo(0);
        newStatus = lfs.getFileStatus(dirPath);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        FileStatus fstatus = lfs.getFileStatus(dirPath);
        Thread.sleep(500L);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-m", "-t", strTime, "dir3")).as("Expected successful touch with a specified modification time", new Object[0])).isEqualTo(0);
        newStatus = lfs.getFileStatus(dirPath);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(fstatus.getAccessTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(dateObj.getTime());
        fstatus = lfs.getFileStatus(dirPath);
        Thread.sleep(500L);
        strTime = this.formatTimestamp(System.currentTimeMillis());
        dateObj = this.parseTimestamp(strTime);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.shellRun("-touch", "-a", "-t", strTime, "dir3")).as("Expected successful touch with a specified modification time", new Object[0])).isEqualTo(0);
        newStatus = lfs.getFileStatus(dirPath);
        Assertions.assertThat((long)newStatus.getAccessTime()).isEqualTo(dateObj.getTime());
        Assertions.assertThat((long)newStatus.getModificationTime()).isEqualTo(fstatus.getModificationTime());
        lfs.delete(newFile, true);
        lfs.delete(dirPath, true);
        Assertions.assertThat((boolean)lfs.exists(newFile)).isFalse();
        Assertions.assertThat((boolean)lfs.exists(dirPath)).isFalse();
    }

    private String formatTimestamp(long timeInMillis) {
        return new TouchCommands.Touch().getDateFormat().format(new Date(timeInMillis));
    }

    private Date parseTimestamp(String tstamp) throws ParseException {
        return new TouchCommands.Touch().getDateFormat().parse(tstamp);
    }
}

