/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestFileSystemTokens {
    private static String renewer = "renewer!";

    @Test
    public void testFsWithNoToken() throws Exception {
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[0]);
        Credentials credentials = new Credentials();
        fs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(fs, false);
        Assertions.assertEquals((int)0, (int)credentials.numberOfTokens());
    }

    @Test
    public void testFsWithToken() throws Exception {
        Text service = new Text("singleTokenFs");
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(service, new FileSystem[0]);
        Credentials credentials = new Credentials();
        fs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(fs, true);
        Assertions.assertEquals((int)1, (int)credentials.numberOfTokens());
        Assertions.assertNotNull((Object)credentials.getToken(service));
    }

    @Test
    public void testFsWithTokenExists() throws Exception {
        Credentials credentials = new Credentials();
        Text service = new Text("singleTokenFs");
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(service, new FileSystem[0]);
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(service, token);
        fs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(fs, false);
        Assertions.assertEquals((int)1, (int)credentials.numberOfTokens());
        Assertions.assertSame((Object)token, (Object)credentials.getToken(service));
    }

    @Test
    public void testFsWithChildTokens() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs3 = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[]{fs1, fs2, fs3});
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, true);
        this.verifyTokenFetch(fs3, false);
        Assertions.assertEquals((int)2, (int)credentials.numberOfTokens());
        Assertions.assertNotNull((Object)credentials.getToken(service1));
        Assertions.assertNotNull((Object)credentials.getToken(service2));
    }

    @Test
    public void testFsWithDuplicateChildren() throws Exception {
        Credentials credentials = new Credentials();
        Text service = new Text("singleTokenFs1");
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(service, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[]{fs, new FilterFileSystem((FileSystem)fs)});
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs, true);
        Assertions.assertEquals((int)1, (int)credentials.numberOfTokens());
        Assertions.assertNotNull((Object)credentials.getToken(service));
    }

    @Test
    public void testFsWithDuplicateChildrenTokenExists() throws Exception {
        Credentials credentials = new Credentials();
        Text service = new Text("singleTokenFs1");
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(service, token);
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(service, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[]{fs, new FilterFileSystem((FileSystem)fs)});
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs, false);
        Assertions.assertEquals((int)1, (int)credentials.numberOfTokens());
        Assertions.assertSame((Object)token, (Object)credentials.getToken(service));
    }

    @Test
    public void testFsWithChildTokensOneExists() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(service2, token);
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs3 = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[]{fs1, fs2, fs3});
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, false);
        this.verifyTokenFetch(fs3, false);
        Assertions.assertEquals((int)2, (int)credentials.numberOfTokens());
        Assertions.assertNotNull((Object)credentials.getToken(service1));
        Assertions.assertSame((Object)token, (Object)credentials.getToken(service2));
    }

    @Test
    public void testFsWithMyOwnAndChildTokens() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        Text myService = new Text("multiTokenFs");
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(service2, token);
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(myService, new FileSystem[]{fs1, fs2});
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, true);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, false);
        Assertions.assertEquals((int)3, (int)credentials.numberOfTokens());
        Assertions.assertNotNull((Object)credentials.getToken(myService));
        Assertions.assertNotNull((Object)credentials.getToken(service1));
        Assertions.assertNotNull((Object)credentials.getToken(service2));
    }

    @Test
    public void testFsWithMyOwnExistsAndChildTokens() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        Text myService = new Text("multiTokenFs");
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(myService, token);
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(myService, new FileSystem[]{fs1, fs2});
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, true);
        Assertions.assertEquals((int)3, (int)credentials.numberOfTokens());
        Assertions.assertSame((Object)token, (Object)credentials.getToken(myService));
        Assertions.assertNotNull((Object)credentials.getToken(service1));
        Assertions.assertNotNull((Object)credentials.getToken(service2));
    }

    @Test
    public void testFsWithNestedDuplicatesChildren() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        Text service4 = new Text("singleTokenFs4");
        Text multiService = new Text("multiTokenFs");
        Token token2 = (Token)Mockito.mock(Token.class);
        credentials.addToken(service2, token2);
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs1B = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs3 = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs4 = TestFileSystemTokens.createFileSystemForServiceName(service4, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(multiService, new FileSystem[]{fs1, fs1B, fs2, fs2, new FilterFileSystem((FileSystem)fs3), new FilterFileSystem((FileSystem)new FilterFileSystem((FileSystem)fs4))});
        FileSystemTestHelper.MockFileSystem superMultiFs = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[]{fs1, fs1B, fs1, new FilterFileSystem((FileSystem)fs3), new FilterFileSystem((FileSystem)multiFs)});
        superMultiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(superMultiFs, false);
        this.verifyTokenFetch(multiFs, true);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, false);
        this.verifyTokenFetch(fs3, false);
        this.verifyTokenFetch(fs4, true);
        Assertions.assertEquals((int)4, (int)credentials.numberOfTokens());
        Assertions.assertNotNull((Object)credentials.getToken(service1));
        Assertions.assertNotNull((Object)credentials.getToken(service2));
        Assertions.assertSame((Object)token2, (Object)credentials.getToken(service2));
        Assertions.assertNotNull((Object)credentials.getToken(multiService));
        Assertions.assertNotNull((Object)credentials.getToken(service4));
    }

    public static FileSystemTestHelper.MockFileSystem createFileSystemForServiceName(final Text service, FileSystem ... children) throws IOException {
        FileSystemTestHelper.MockFileSystem fs = new FileSystemTestHelper.MockFileSystem();
        FileSystemTestHelper.MockFileSystem mockFs = fs.getRawFileSystem();
        if (service != null) {
            Mockito.when((Object)mockFs.getCanonicalServiceName()).thenReturn((Object)service.toString());
            Mockito.when(mockFs.getDelegationToken((String)Mockito.any(String.class))).thenAnswer(new Answer<Token<?>>(){

                public Token<?> answer(InvocationOnMock invocation) throws Throwable {
                    Token token = new Token();
                    token.setService(service);
                    return token;
                }
            });
        }
        Mockito.when((Object)mockFs.getChildFileSystems()).thenReturn((Object)children);
        return fs;
    }

    private void verifyTokenFetch(FileSystemTestHelper.MockFileSystem fs, boolean expected) throws IOException {
        ((FileSystemTestHelper.MockFileSystem)((Object)Mockito.verify((Object)((Object)fs.getRawFileSystem()), (VerificationMode)Mockito.atLeast((int)1)))).getCanonicalServiceName();
        if (expected) {
            ((FileSystemTestHelper.MockFileSystem)((Object)Mockito.verify((Object)((Object)fs.getRawFileSystem())))).getDelegationToken(renewer);
        } else {
            ((FileSystemTestHelper.MockFileSystem)((Object)Mockito.verify((Object)((Object)fs.getRawFileSystem()), (VerificationMode)Mockito.never()))).getDelegationToken((String)Mockito.any(String.class));
        }
        ((FileSystemTestHelper.MockFileSystem)((Object)Mockito.verify((Object)((Object)fs.getRawFileSystem()), (VerificationMode)Mockito.atLeast((int)1)))).getChildFileSystems();
    }
}

