/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Iterator;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemStorageStatistics;
import org.apache.hadoop.fs.StorageStatistics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=10L)
public class TestFileSystemStorageStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileSystemStorageStatistics.class);
    private static final String FS_STORAGE_STATISTICS_NAME = "test-fs-statistics";
    private static final String[] STATISTICS_KEYS = new String[]{"bytesRead", "bytesWritten", "readOps", "largeReadOps", "writeOps", "bytesReadLocalHost", "bytesReadDistanceOfOneOrTwo", "bytesReadDistanceOfThreeOrFour", "bytesReadDistanceOfFiveOrLarger", "bytesReadErasureCoded", "remoteReadTimeMS"};
    private FileSystem.Statistics statistics = new FileSystem.Statistics("test-scheme");
    private FileSystemStorageStatistics storageStatistics = new FileSystemStorageStatistics("test-fs-statistics", this.statistics);

    @BeforeEach
    public void setup() {
        this.statistics.incrementBytesRead((long)RandomUtils.nextInt((int)0, (int)100));
        this.statistics.incrementBytesWritten((long)RandomUtils.nextInt((int)0, (int)100));
        this.statistics.incrementLargeReadOps(RandomUtils.nextInt((int)0, (int)100));
        this.statistics.incrementWriteOps(RandomUtils.nextInt((int)0, (int)100));
        this.statistics.incrementBytesReadByDistance(0, (long)RandomUtils.nextInt((int)0, (int)100));
        this.statistics.incrementBytesReadByDistance(1, (long)RandomUtils.nextInt((int)0, (int)100));
        this.statistics.incrementBytesReadByDistance(3, (long)RandomUtils.nextInt((int)0, (int)100));
        this.statistics.incrementBytesReadErasureCoded((long)RandomUtils.nextInt((int)0, (int)100));
        this.statistics.increaseRemoteReadTime((long)RandomUtils.nextInt((int)0, (int)100));
    }

    @Test
    public void testGetLongStatistics() {
        Iterator iter = this.storageStatistics.getLongStatistics();
        while (iter.hasNext()) {
            StorageStatistics.LongStatistic longStat = (StorageStatistics.LongStatistic)iter.next();
            Assertions.assertNotNull((Object)longStat);
            long expectedStat = this.getStatisticsValue(longStat.getName());
            LOG.info("{}: FileSystem.Statistics={}, FileSystemStorageStatistics={}", new Object[]{longStat.getName(), expectedStat, longStat.getValue()});
            Assertions.assertEquals((long)expectedStat, (long)longStat.getValue());
        }
    }

    @Test
    public void testGetLong() {
        for (String key : STATISTICS_KEYS) {
            long expectedStat = this.getStatisticsValue(key);
            long storageStat = this.storageStatistics.getLong(key);
            LOG.info("{}: FileSystem.Statistics={}, FileSystemStorageStatistics={}", new Object[]{key, expectedStat, storageStat});
            Assertions.assertEquals((long)expectedStat, (long)storageStat);
        }
    }

    @Test
    public void testStatisticsDataReferenceCleanerClassLoader() {
        Thread thread = Thread.getAllStackTraces().keySet().stream().filter(t -> t.getName().contains("StatisticsDataReferenceCleaner")).findFirst().get();
        ClassLoader classLoader = thread.getContextClassLoader();
        Assertions.assertNull((Object)classLoader);
    }

    private long getStatisticsValue(String name) {
        switch (name) {
            case "bytesRead": {
                return this.statistics.getBytesRead();
            }
            case "bytesWritten": {
                return this.statistics.getBytesWritten();
            }
            case "readOps": {
                return this.statistics.getReadOps();
            }
            case "largeReadOps": {
                return this.statistics.getLargeReadOps();
            }
            case "writeOps": {
                return this.statistics.getWriteOps();
            }
            case "bytesReadLocalHost": {
                return this.statistics.getBytesReadByDistance(0);
            }
            case "bytesReadDistanceOfOneOrTwo": {
                return this.statistics.getBytesReadByDistance(1);
            }
            case "bytesReadDistanceOfThreeOrFour": {
                return this.statistics.getBytesReadByDistance(3);
            }
            case "bytesReadDistanceOfFiveOrLarger": {
                return this.statistics.getBytesReadByDistance(5);
            }
            case "bytesReadErasureCoded": {
                return this.statistics.getBytesReadErasureCoded();
            }
            case "remoteReadTimeMS": {
                return this.statistics.getRemoteReadTime();
            }
        }
        return 0L;
    }
}

