/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDU {
    private static final File DU_DIR = GenericTestUtils.getTestDir("dutmp");

    @BeforeEach
    public void setUp() {
        Assumptions.assumeFalse((boolean)Shell.WINDOWS);
        FileUtil.fullyDelete((File)DU_DIR);
        Assertions.assertTrue((boolean)DU_DIR.mkdirs());
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DU_DIR);
    }

    private void createFile(File newFile, int size) throws IOException {
        Random random = new Random();
        byte[] data = new byte[size];
        random.nextBytes(data);
        newFile.createNewFile();
        RandomAccessFile file = new RandomAccessFile(newFile, "rws");
        file.write(data);
        file.getFD().sync();
        file.close();
    }

    @Test
    public void testDU() throws IOException, InterruptedException {
        int writtenSize = 32768;
        int slack = 4096;
        File file = new File(DU_DIR, "data");
        this.createFile(file, 32768);
        Thread.sleep(5000L);
        DU du = new DU(file, 10000L, 0L, -1L);
        du.init();
        long duSize = du.getUsed();
        du.close();
        Assertions.assertTrue((duSize >= 32768L && 32768L <= duSize + 4096L ? 1 : 0) != 0, (String)"Invalid on-disk size");
        du = new DU(file, 0L, 1L, -1L);
        du.init();
        duSize = du.getUsed();
        du.close();
        Assertions.assertTrue((duSize >= 32768L && 32768L <= duSize + 4096L ? 1 : 0) != 0, (String)"Invalid on-disk size");
        du = new DU(file, 10000L, 0L, -1L);
        du.init();
        duSize = du.getUsed();
        Assertions.assertTrue((duSize >= 32768L && 32768L <= duSize + 4096L ? 1 : 0) != 0, (String)"Invalid on-disk size");
    }

    @Test
    public void testDUGetUsedWillNotReturnNegative() throws IOException {
        File file = new File(DU_DIR, "data");
        Assertions.assertTrue((boolean)file.createNewFile());
        Configuration conf = new Configuration();
        conf.setLong("fs.du.interval", 10000L);
        DU du = new DU(file, 10000L, 0L, -1L);
        du.incDfsUsed(-9223372036854775807L);
        long duSize = du.getUsed();
        Assertions.assertTrue((duSize >= 0L ? 1 : 0) != 0, (String)String.valueOf(duSize));
    }

    @Test
    public void testDUSetInitialValue() throws IOException {
        File file = new File(DU_DIR, "dataX");
        this.createFile(file, 8192);
        DU du = new DU(file, 3000L, 0L, 1024L);
        du.init();
        Assertions.assertTrue((du.getUsed() == 1024L ? 1 : 0) != 0, (String)"Initial usage setting not honored");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((du.getUsed() == 8192L ? 1 : 0) != 0, (String)"Usage didn't get updated");
    }
}

