/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.random;

import java.util.Arrays;
import org.apache.hadoop.crypto.random.OpensslSecureRandom;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestOpensslSecureRandom {
    @Test
    @Timeout(value=120L)
    public void testRandomBytes() throws Exception {
        OpensslSecureRandom random = new OpensslSecureRandom();
        this.checkRandomBytes(random, 16);
        this.checkRandomBytes(random, 32);
        this.checkRandomBytes(random, 128);
        this.checkRandomBytes(random, 256);
    }

    private void checkRandomBytes(OpensslSecureRandom random, int len) {
        byte[] bytes = new byte[len];
        byte[] bytes1 = new byte[len];
        random.nextBytes(bytes);
        random.nextBytes(bytes1);
        while (Arrays.equals(bytes, bytes1)) {
            random.nextBytes(bytes1);
        }
    }

    @Test
    @Timeout(value=120L)
    public void testRandomInt() throws Exception {
        OpensslSecureRandom random = new OpensslSecureRandom();
        int rand1 = random.nextInt();
        int rand2 = random.nextInt();
        while (rand1 == rand2) {
            rand2 = random.nextInt();
        }
    }

    @Test
    @Timeout(value=120L)
    public void testRandomLong() throws Exception {
        OpensslSecureRandom random = new OpensslSecureRandom();
        long rand1 = random.nextLong();
        long rand2 = random.nextLong();
        while (rand1 == rand2) {
            rand2 = random.nextLong();
        }
    }

    @Test
    @Timeout(value=120L)
    public void testRandomFloat() throws Exception {
        OpensslSecureRandom random = new OpensslSecureRandom();
        float rand1 = random.nextFloat();
        float rand2 = random.nextFloat();
        while (rand1 == rand2) {
            rand2 = random.nextFloat();
        }
    }

    @Test
    @Timeout(value=120L)
    public void testRandomDouble() throws Exception {
        OpensslSecureRandom random = new OpensslSecureRandom();
        double rand1 = random.nextDouble();
        double rand2 = random.nextDouble();
        while (rand1 == rand2) {
            rand2 = random.nextDouble();
        }
    }
}

