/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.KMSDelegationToken;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Timeout(value=60L)
public class TestKMSClientProvider {
    public static final Logger LOG = LoggerFactory.getLogger(TestKMSClientProvider.class);
    private final Token token = new Token();
    private final Token oldToken = new Token();
    private final String urlString = "https://host:16000/kms";
    private final String providerUriString = "kms://https@host:16000/kms";
    private final String oldTokenService = "host:16000";

    public TestKMSClientProvider() {
        GenericTestUtils.setLogLevel(KMSClientProvider.LOG, Level.TRACE);
    }

    @BeforeEach
    public void setup() {
        SecurityUtil.setTokenServiceUseIp((boolean)false);
        this.token.setKind(KMSDelegationToken.TOKEN_KIND);
        this.token.setService(new Text("kms://https@host:16000/kms"));
        this.oldToken.setKind(KMSDelegationToken.TOKEN_KIND);
        this.oldToken.setService(new Text("host:16000"));
    }

    @Test
    public void testSelectDelegationToken() throws Exception {
        Credentials creds = new Credentials();
        creds.addToken(new Text("kms://https@host:16000/kms"), this.token);
        Assertions.assertNull((Object)KMSClientProvider.selectDelegationToken((Credentials)creds, null));
        Assertions.assertNull((Object)KMSClientProvider.selectDelegationToken((Credentials)creds, (Text)new Text("host:16000")));
        Assertions.assertEquals((Object)this.token, (Object)KMSClientProvider.selectDelegationToken((Credentials)creds, (Text)new Text("kms://https@host:16000/kms")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectTokenOldService() throws Exception {
        Configuration conf = new Configuration();
        URI uri = new URI("kms://https@host:16000/kms");
        try (KMSClientProvider kp = new KMSClientProvider(uri, conf);){
            Credentials creds = new Credentials();
            creds.addToken(new Text("host:16000"), this.oldToken);
            Token t = kp.selectDelegationToken(creds);
            Assertions.assertEquals((Object)this.oldToken, (Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectTokenWhenBothExist() throws Exception {
        Credentials creds = new Credentials();
        Configuration conf = new Configuration();
        URI uri = new URI("kms://https@host:16000/kms");
        try (KMSClientProvider kp = new KMSClientProvider(uri, conf);){
            creds.addToken(this.token.getService(), this.token);
            creds.addToken(this.oldToken.getService(), this.oldToken);
            Token t = kp.selectDelegationToken(creds);
            Assertions.assertEquals((Object)this.token, (Object)t, (String)"new token should be selected when both exist");
        }
    }

    @Test
    public void testURLSelectTokenUriFormat() throws Exception {
        this.testURLSelectToken(this.token);
    }

    @Test
    public void testURLSelectTokenIpPort() throws Exception {
        this.testURLSelectToken(this.oldToken);
    }

    private void testURLSelectToken(Token tok) throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        URI uri = new URI("kms://https@host:16000/kms");
        KMSClientProvider kp = new KMSClientProvider(uri, conf);
        DelegationTokenAuthenticatedURL url = kp.createAuthenticatedURL();
        Credentials creds = new Credentials();
        creds.addToken(tok.getService(), tok);
        Token chosen = url.selectDelegationToken(new URL("https://host:16000/kms"), creds);
        Assertions.assertEquals((Object)tok, (Object)chosen);
    }
}

