/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.event.Level;

public class TestCryptoUtils {
    @Test
    @Timeout(value=1L)
    public void testProviderName() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BC", (Object)"BC");
    }

    static void assertRemoveProvider() {
        Security.removeProvider("BC");
        org.junit.jupiter.api.Assertions.assertNull((Object)Security.getProvider("BC"));
    }

    static void assertSetProvider(Configuration conf) {
        conf.set("hadoop.security.crypto.jce.provider", "BC");
        String providerFromConf = CryptoUtils.getJceProvider((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BC", (Object)providerFromConf);
    }

    @Test
    @Timeout(value=5L)
    public void testAutoAddDisabled() {
        TestCryptoUtils.assertRemoveProvider();
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.crypto.jce.provider.auto-add", false);
        TestCryptoUtils.assertSetProvider(conf);
        org.junit.jupiter.api.Assertions.assertNull((Object)Security.getProvider("BC"));
    }

    @Test
    @Timeout(value=5L)
    public void testAutoAddEnabled() {
        TestCryptoUtils.assertRemoveProvider();
        Configuration conf = new Configuration();
        ((AbstractStringAssert)Assertions.assertThat((String)conf.get("hadoop.security.crypto.jce.provider.auto-add")).describedAs("conf: hadoop.security.crypto.jce.provider.auto-add", new Object[0])).isEqualToIgnoringCase((CharSequence)"true");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)true);
        conf.set("hadoop.security.crypto.jce.provider", "BC");
        String providerFromConf = CryptoUtils.getJceProvider((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BC", (Object)providerFromConf);
        Provider provider = Security.getProvider("BC");
        Assertions.assertThat((Map)provider).isInstanceOf(BouncyCastleProvider.class);
        TestCryptoUtils.assertRemoveProvider();
    }

    static {
        GenericTestUtils.setLogLevel(CryptoUtils.LOG, Level.TRACE);
    }
}

