/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.StorageUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStorageUnit {
    static final double KB = 1024.0;
    static final double MB = 1048576.0;
    static final double GB = 1.073741824E9;
    static final double TB = 1.099511627776E12;
    static final double PB = 1.125899906842624E15;
    static final double EB = 1.152921504606847E18;

    @Test
    public void testByteToKiloBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1024.0, 1.0);
        results.put(2048.0, 2.0);
        results.put(-1024.0, -1.0);
        results.put(34565.0, 33.7549);
        results.put(2.23344332E8, 218109.6992);
        results.put(1234983.0, 1206.0381);
        results.put(1234332.0, 1205.4023);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            Assertions.assertThat((double)StorageUnit.BYTES.toKBs(((Double)entry.getKey()).doubleValue())).isEqualTo(entry.getValue());
        }
    }

    @Test
    public void testBytesToMegaBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1048576.0, 1.0);
        results.put(2.4117248E7, 23.0);
        results.put(4.59920023E8, 438.6139);
        results.put(2.34443233E8, 223.5825);
        results.put(-3.5651584E7, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            Assertions.assertThat((double)StorageUnit.BYTES.toMBs(((Double)entry.getKey()).doubleValue())).isEqualTo(entry.getValue());
        }
    }

    @Test
    public void testBytesToGigaBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1.073741824E9, 1.0);
        results.put(2.4696061952E10, 23.0);
        results.put(4.59920023E8, 0.4283);
        results.put(2.34443233E8, 0.2183);
        results.put(-3.6507222016E10, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            Assertions.assertThat((double)StorageUnit.BYTES.toGBs(((Double)entry.getKey()).doubleValue())).isEqualTo(entry.getValue());
        }
    }

    @Test
    public void testBytesToTerraBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1.09951E12, 1.0);
        results.put(2.52888E13, 23.0);
        results.put(4.59920023E8, 4.0E-4);
        results.put(2.34443233E8, 2.0E-4);
        results.put(-3.73834E13, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            Assertions.assertThat((double)StorageUnit.BYTES.toTBs(((Double)entry.getKey()).doubleValue())).isEqualTo(entry.getValue());
        }
    }

    @Test
    public void testBytesToPetaBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1.1259E15, 1.0);
        results.put(2.58957E16, 23.0);
        results.put(4.70958E11, 4.0E-4);
        results.put(2.34443233E8, 0.0);
        results.put(-3.82806E16, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            Assertions.assertThat((double)StorageUnit.BYTES.toPBs(((Double)entry.getKey()).doubleValue())).isEqualTo(entry.getValue());
        }
    }

    @Test
    public void testBytesToExaBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1.15292E18, 1.0);
        results.put(2.65172E19, 23.0);
        results.put(4.82261E14, 4.0E-4);
        results.put(2.34443233E8, 0.0);
        results.put(-3.91993E19, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            Assertions.assertThat((double)StorageUnit.BYTES.toEBs(((Double)entry.getKey()).doubleValue())).isEqualTo(entry.getValue());
        }
    }

    @Test
    public void testByteConversions() {
        Assertions.assertThat((String)StorageUnit.BYTES.getShortName()).isEqualTo((Object)"b");
        Assertions.assertThat((String)StorageUnit.BYTES.getSuffixChar()).isEqualTo((Object)"b");
        Assertions.assertThat((String)StorageUnit.BYTES.getLongName()).isEqualTo((Object)"bytes");
        Assertions.assertThat((String)StorageUnit.BYTES.toString()).isEqualTo((Object)"bytes");
        Assertions.assertThat((double)StorageUnit.BYTES.toBytes(1.0)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.BYTES.toBytes(1024.0)).isEqualTo(StorageUnit.BYTES.getDefault(1024.0));
        Assertions.assertThat((double)StorageUnit.BYTES.fromBytes(10.0)).isEqualTo(10.0);
    }

    @Test
    public void testKBConversions() {
        Assertions.assertThat((String)StorageUnit.KB.getShortName()).isEqualTo((Object)"kb");
        Assertions.assertThat((String)StorageUnit.KB.getSuffixChar()).isEqualTo((Object)"k");
        Assertions.assertThat((String)StorageUnit.KB.getLongName()).isEqualTo((Object)"kilobytes");
        Assertions.assertThat((String)StorageUnit.KB.toString()).isEqualTo((Object)"kilobytes");
        Assertions.assertThat((double)StorageUnit.KB.toKBs(1024.0)).isEqualTo(StorageUnit.KB.getDefault(1024.0));
        Assertions.assertThat((double)StorageUnit.KB.toBytes(1.0)).isEqualTo(1024.0);
        Assertions.assertThat((double)StorageUnit.KB.fromBytes(1024.0)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.KB.toKBs(10.0)).isEqualTo(10.0);
        Assertions.assertThat((double)StorageUnit.KB.toMBs(3072.0)).isEqualTo(3.0);
        Assertions.assertThat((double)StorageUnit.KB.toGBs(1.073741824E9)).isEqualTo(1024.0);
        Assertions.assertThat((double)StorageUnit.KB.toTBs(1.073741824E9)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.KB.toPBs(1.0995116E12)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.KB.toEBs(1.1258999E15)).isEqualTo(1.0);
    }

    @Test
    public void testMBConversions() {
        Assertions.assertThat((String)StorageUnit.MB.getShortName()).isEqualTo((Object)"mb");
        Assertions.assertThat((String)StorageUnit.MB.getSuffixChar()).isEqualTo((Object)"m");
        Assertions.assertThat((String)StorageUnit.MB.getLongName()).isEqualTo((Object)"megabytes");
        Assertions.assertThat((String)StorageUnit.MB.toString()).isEqualTo((Object)"megabytes");
        Assertions.assertThat((double)StorageUnit.MB.toMBs(1024.0)).isEqualTo(StorageUnit.MB.getDefault(1024.0));
        Assertions.assertThat((double)StorageUnit.MB.toBytes(1.0)).isEqualTo(1048576.0);
        Assertions.assertThat((double)StorageUnit.MB.fromBytes(1048576.0)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.MB.toKBs(1.0)).isEqualTo(1024.0);
        Assertions.assertThat((double)StorageUnit.MB.toMBs(10.0)).isEqualTo(10.0);
        Assertions.assertThat((double)StorageUnit.MB.toGBs(4.4040192E7)).isEqualTo(43008.0);
        Assertions.assertThat((double)StorageUnit.MB.toTBs(1.073741824E9)).isEqualTo(1024.0);
        Assertions.assertThat((double)StorageUnit.MB.toPBs(1.073741824E9)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.MB.toEBs(1.099511627776E12)).isEqualTo(1.0);
    }

    @Test
    public void testGBConversions() {
        Assertions.assertThat((String)StorageUnit.GB.getShortName()).isEqualTo((Object)"gb");
        Assertions.assertThat((String)StorageUnit.GB.getSuffixChar()).isEqualTo((Object)"g");
        Assertions.assertThat((String)StorageUnit.GB.getLongName()).isEqualTo((Object)"gigabytes");
        Assertions.assertThat((String)StorageUnit.GB.toString()).isEqualTo((Object)"gigabytes");
        Assertions.assertThat((double)StorageUnit.GB.toGBs(1024.0)).isEqualTo(StorageUnit.GB.getDefault(1024.0));
        Assertions.assertThat((double)StorageUnit.GB.toBytes(1.0)).isEqualTo(1.073741824E9);
        Assertions.assertThat((double)StorageUnit.GB.fromBytes(1.073741824E9)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.GB.toKBs(1.0)).isEqualTo(1048576.0);
        Assertions.assertThat((double)StorageUnit.GB.toMBs(10.0)).isEqualTo(10240.0);
        Assertions.assertThat((double)StorageUnit.GB.toGBs(4.4040192E7)).isEqualTo(4.4040192E7);
        Assertions.assertThat((double)StorageUnit.GB.toTBs(1.073741824E9)).isEqualTo(1048576.0);
        Assertions.assertThat((double)StorageUnit.GB.toPBs(1.07375E9)).isEqualTo(1024.0078);
        Assertions.assertThat((double)StorageUnit.GB.toEBs(1.073741824E9)).isEqualTo(1.0);
    }

    @Test
    public void testTBConversions() {
        Assertions.assertThat((String)StorageUnit.TB.getShortName()).isEqualTo((Object)"tb");
        Assertions.assertThat((String)StorageUnit.TB.getSuffixChar()).isEqualTo((Object)"t");
        Assertions.assertThat((String)StorageUnit.TB.getLongName()).isEqualTo((Object)"terabytes");
        Assertions.assertThat((String)StorageUnit.TB.toString()).isEqualTo((Object)"terabytes");
        Assertions.assertThat((double)StorageUnit.TB.toTBs(1024.0)).isEqualTo(StorageUnit.TB.getDefault(1024.0));
        Assertions.assertThat((double)StorageUnit.TB.toBytes(1.0)).isEqualTo(1.099511627776E12);
        Assertions.assertThat((double)StorageUnit.TB.fromBytes(1.099511627776E12)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.TB.toKBs(1.0)).isEqualTo(1.073741824E9);
        Assertions.assertThat((double)StorageUnit.TB.toMBs(10.0)).isEqualTo(1.048576E7);
        Assertions.assertThat((double)StorageUnit.TB.toGBs(4.4040192E7)).isEqualTo(4.5097156608E10);
        Assertions.assertThat((double)StorageUnit.TB.toTBs(1.073741824E9)).isEqualTo(1.073741824E9);
        Assertions.assertThat((double)StorageUnit.TB.toPBs(1024.0)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.TB.toEBs(1048576.0)).isEqualTo(1.0);
    }

    @Test
    public void testPBConversions() {
        Assertions.assertThat((String)StorageUnit.PB.getShortName()).isEqualTo((Object)"pb");
        Assertions.assertThat((String)StorageUnit.PB.getSuffixChar()).isEqualTo((Object)"p");
        Assertions.assertThat((String)StorageUnit.PB.getLongName()).isEqualTo((Object)"petabytes");
        Assertions.assertThat((String)StorageUnit.PB.toString()).isEqualTo((Object)"petabytes");
        Assertions.assertThat((double)StorageUnit.PB.toPBs(1024.0)).isEqualTo(StorageUnit.PB.getDefault(1024.0));
        Assertions.assertThat((double)StorageUnit.PB.toBytes(1.0)).isEqualTo(1.125899906842624E15);
        Assertions.assertThat((double)StorageUnit.PB.fromBytes(1.125899906842624E15)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.PB.toKBs(1.0)).isEqualTo(1.099511627776E12);
        Assertions.assertThat((double)StorageUnit.PB.toMBs(10.0)).isEqualTo(1.073741824E10);
        Assertions.assertThat((double)StorageUnit.PB.toGBs(4.4040192E7)).isEqualTo(4.6179488366592E13);
        Assertions.assertThat((double)StorageUnit.PB.toTBs(1.073741824E9)).isEqualTo(1.099511627776E12);
        Assertions.assertThat((double)StorageUnit.PB.toPBs(1024.0)).isEqualTo(1024.0);
        Assertions.assertThat((double)StorageUnit.PB.toEBs(1024.0)).isEqualTo(1.0);
    }

    @Test
    public void testEBConversions() {
        Assertions.assertThat((String)StorageUnit.EB.getShortName()).isEqualTo((Object)"eb");
        Assertions.assertThat((String)StorageUnit.EB.getSuffixChar()).isEqualTo((Object)"e");
        Assertions.assertThat((String)StorageUnit.EB.getLongName()).isEqualTo((Object)"exabytes");
        Assertions.assertThat((String)StorageUnit.EB.toString()).isEqualTo((Object)"exabytes");
        Assertions.assertThat((double)StorageUnit.EB.toEBs(1024.0)).isEqualTo(StorageUnit.EB.getDefault(1024.0));
        Assertions.assertThat((double)StorageUnit.EB.toBytes(1.0)).isEqualTo(1.152921504606847E18);
        Assertions.assertThat((double)StorageUnit.EB.fromBytes(1.152921504606847E18)).isEqualTo(1.0);
        Assertions.assertThat((double)StorageUnit.EB.toKBs(1.0)).isEqualTo(1.125899906842624E15);
        Assertions.assertThat((double)StorageUnit.EB.toMBs(10.0)).isEqualTo(1.099511627776E13);
        Assertions.assertThat((double)StorageUnit.EB.toGBs(4.4040192E7)).isEqualTo(4.728779608739021E16);
        Assertions.assertThat((double)StorageUnit.EB.toTBs(1.073741824E9)).isEqualTo(1.125899906842624E15);
        Assertions.assertThat((double)StorageUnit.EB.toPBs(1.0)).isEqualTo(1024.0);
        Assertions.assertThat((double)StorageUnit.EB.toEBs(42.0)).isEqualTo(42.0);
    }
}

