/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Unstable
public final class Tuples {
    private Tuples() {
    }

    public static <K, V> Map.Entry<K, V> pair(K key, V value) {
        return new Tuple<K, V>(key, value);
    }

    private static final class Tuple<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        private Tuple(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("Tuple is immutable");
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple tuple = (Tuple)o;
            return Objects.equals(this.key, tuple.key) && Objects.equals(this.value, tuple.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

