/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Arrays;
import java.util.function.ToIntFunction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Common", "HDFS", "MapReduce", "Yarn"})
@InterfaceStability.Unstable
public final class CrcUtil {
    public static final int MULTIPLICATIVE_IDENTITY = Integer.MIN_VALUE;
    public static final int GZIP_POLYNOMIAL = -306674912;
    public static final int CASTAGNOLI_POLYNOMIAL = -2097792136;
    private static final long UNIT = Long.MIN_VALUE;

    static int multiplyMod(int a, int b, ToIntFunction<Long> mod) {
        long left = (long)a << 32;
        long right = (long)b << 32;
        long product = ((left & Long.MIN_VALUE) == 0L ? 0L : right) ^ ((left & 0x4000000000000000L) == 0L ? 0L : right >>> 1) ^ (((left & 0x2000000000000000L) == 0L ? 0L : right >>> 2) ^ ((left & 0x1000000000000000L) == 0L ? 0L : right >>> 3)) ^ (((left & 0x800000000000000L) == 0L ? 0L : right >>> 4) ^ ((left & 0x400000000000000L) == 0L ? 0L : right >>> 5) ^ (((left & 0x200000000000000L) == 0L ? 0L : right >>> 6) ^ ((left & 0x100000000000000L) == 0L ? 0L : right >>> 7))) ^ (((left & 0x80000000000000L) == 0L ? 0L : right >>> 8) ^ ((left & 0x40000000000000L) == 0L ? 0L : right >>> 9) ^ (((left & 0x20000000000000L) == 0L ? 0L : right >>> 10) ^ ((left & 0x10000000000000L) == 0L ? 0L : right >>> 11)) ^ (((left & 0x8000000000000L) == 0L ? 0L : right >>> 12) ^ ((left & 0x4000000000000L) == 0L ? 0L : right >>> 13) ^ (((left & 0x2000000000000L) == 0L ? 0L : right >>> 14) ^ ((left & 0x1000000000000L) == 0L ? 0L : right >>> 15)))) ^ (((left & 0x800000000000L) == 0L ? 0L : right >>> 16) ^ ((left & 0x400000000000L) == 0L ? 0L : right >>> 17) ^ (((left & 0x200000000000L) == 0L ? 0L : right >>> 18) ^ ((left & 0x100000000000L) == 0L ? 0L : right >>> 19)) ^ (((left & 0x80000000000L) == 0L ? 0L : right >>> 20) ^ ((left & 0x40000000000L) == 0L ? 0L : right >>> 21) ^ (((left & 0x20000000000L) == 0L ? 0L : right >>> 22) ^ ((left & 0x10000000000L) == 0L ? 0L : right >>> 23))) ^ (((left & 0x8000000000L) == 0L ? 0L : right >>> 24) ^ ((left & 0x4000000000L) == 0L ? 0L : right >>> 25) ^ (((left & 0x2000000000L) == 0L ? 0L : right >>> 26) ^ ((left & 0x1000000000L) == 0L ? 0L : right >>> 27)) ^ (((left & 0x800000000L) == 0L ? 0L : right >>> 28) ^ ((left & 0x400000000L) == 0L ? 0L : right >>> 29) ^ (((left & 0x200000000L) == 0L ? 0L : right >>> 30) ^ ((left & 0x100000000L) == 0L ? 0L : right >>> 31)))));
        return mod.applyAsInt(product);
    }

    private CrcUtil() {
    }

    public static int getMonomial(long lengthBytes, ToIntFunction<Long> mod) {
        if (lengthBytes == 0L) {
            return Integer.MIN_VALUE;
        }
        if (lengthBytes < 0L) {
            throw new IllegalArgumentException("lengthBytes must be positive, got " + lengthBytes);
        }
        int multiplier = 0x800000;
        int product = Integer.MIN_VALUE;
        for (long degree = lengthBytes; degree > 0L; degree >>= 1) {
            if ((degree & 1L) != 0L) {
                product = product == Integer.MIN_VALUE ? multiplier : CrcUtil.multiplyMod(product, multiplier, mod);
            }
            multiplier = CrcUtil.multiplyMod(multiplier, multiplier, mod);
        }
        return product;
    }

    public static int composeWithMonomial(int crcA, int crcB, int monomial, ToIntFunction<Long> mod) {
        return CrcUtil.multiplyMod(crcA, monomial, mod) ^ crcB;
    }

    public static int compose(int crcA, int crcB, long lengthB, ToIntFunction<Long> mod) {
        int monomial = CrcUtil.getMonomial(lengthB, mod);
        return CrcUtil.composeWithMonomial(crcA, crcB, monomial, mod);
    }

    public static byte[] intToBytes(int value) {
        byte[] buf = new byte[4];
        CrcUtil.writeInt(buf, 0, value);
        return buf;
    }

    public static void writeInt(byte[] buf, int offset, int value) {
        if (offset + 4 > buf.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("writeInt out of bounds: buf.length=%d, offset=%d", buf.length, offset));
        }
        buf[offset] = (byte)(value >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(value >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(value >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(value & 0xFF);
    }

    public static int readInt(byte[] buf, int offset) {
        if (offset + 4 > buf.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("readInt out of bounds: buf.length=%d, offset=%d", buf.length, offset));
        }
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    public static String toSingleCrcString(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException(String.format("Unexpected byte[] length '%d' for single CRC. Contents: %s", bytes.length, Arrays.toString(bytes)));
        }
        return String.format("0x%08x", CrcUtil.readInt(bytes, 0));
    }

    public static String toMultiCrcString(byte[] bytes) {
        if (bytes.length % 4 != 0) {
            throw new IllegalArgumentException(String.format("Unexpected byte[] length '%d' not divisible by 4. Contents: %s", bytes.length, Arrays.toString(bytes)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < bytes.length; i += 4) {
            sb.append(String.format("0x%08x", CrcUtil.readInt(bytes, i)));
            if (i == bytes.length - 4) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

