/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RollingFileSystemSink
implements MetricsSink,
Closeable {
    private static final String BASEPATH_KEY = "basepath";
    private static final String SOURCE_KEY = "source";
    private static final String IGNORE_ERROR_KEY = "ignore-error";
    private static final boolean DEFAULT_IGNORE_ERROR = false;
    private static final String ALLOW_APPEND_KEY = "allow-append";
    private static final boolean DEFAULT_ALLOW_APPEND = false;
    private static final String KEYTAB_PROPERTY_KEY = "keytab-key";
    private static final String USERNAME_PROPERTY_KEY = "principal-key";
    private static final String ROLL_INTERVAL_KEY = "roll-interval";
    private static final String DEFAULT_ROLL_INTERVAL = "1h";
    private static final String ROLL_OFFSET_INTERVAL_MILLIS_KEY = "roll-offset-interval-millis";
    private static final int DEFAULT_ROLL_OFFSET_INTERVAL_MILLIS = 30000;
    private static final String SOURCE_DEFAULT = "unknown";
    private static final String BASEPATH_DEFAULT = "/tmp";
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyyMMddHHmm", (TimeZone)TimeZone.getTimeZone("GMT"));
    private final Object lock = new Object();
    private boolean initialized = false;
    private SubsetConfiguration properties;
    private Configuration conf;
    @VisibleForTesting
    protected String source;
    @VisibleForTesting
    protected boolean ignoreError;
    @VisibleForTesting
    protected boolean allowAppend;
    @VisibleForTesting
    protected Path basePath;
    private FileSystem fileSystem;
    private Path currentDirPath;
    private Path currentFilePath;
    private PrintStream currentOutStream;
    private FSDataOutputStream currentFSOutStream;
    private Timer flushTimer;
    @VisibleForTesting
    protected long rollIntervalMillis;
    @VisibleForTesting
    protected long rollOffsetIntervalMillis;
    @VisibleForTesting
    protected Calendar nextFlush = null;
    @VisibleForTesting
    protected static boolean forceFlush = false;
    @VisibleForTesting
    protected static volatile boolean hasFlushed = false;
    @VisibleForTesting
    protected static Configuration suppliedConf = null;
    @VisibleForTesting
    protected static FileSystem suppliedFilesystem = null;

    public RollingFileSystemSink() {
    }

    @VisibleForTesting
    protected RollingFileSystemSink(long flushIntervalMillis, long flushOffsetIntervalMillis) {
        this.rollIntervalMillis = flushIntervalMillis;
        this.rollOffsetIntervalMillis = flushOffsetIntervalMillis;
    }

    @Override
    public void init(SubsetConfiguration metrics2Properties) {
        this.properties = metrics2Properties;
        this.basePath = new Path(this.properties.getString(BASEPATH_KEY, BASEPATH_DEFAULT));
        this.source = this.properties.getString(SOURCE_KEY, SOURCE_DEFAULT);
        this.ignoreError = this.properties.getBoolean(IGNORE_ERROR_KEY, false);
        this.allowAppend = this.properties.getBoolean(ALLOW_APPEND_KEY, false);
        this.rollOffsetIntervalMillis = this.getNonNegative(ROLL_OFFSET_INTERVAL_MILLIS_KEY, 30000);
        this.rollIntervalMillis = this.getRollInterval();
        this.conf = this.loadConf();
        UserGroupInformation.setConfiguration(this.conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            this.checkIfPropertyExists(KEYTAB_PROPERTY_KEY);
            this.checkIfPropertyExists(USERNAME_PROPERTY_KEY);
            try {
                SecurityUtil.login(this.conf, this.properties.getString(KEYTAB_PROPERTY_KEY), this.properties.getString(USERNAME_PROPERTY_KEY));
            }
            catch (IOException ex) {
                throw new MetricsException("Error logging in securely: [" + ex.toString() + "]", ex);
            }
        }
    }

    private boolean initFs() {
        boolean success;
        block4: {
            success = false;
            this.fileSystem = this.getFileSystem();
            try {
                this.fileSystem.mkdirs(this.basePath);
                success = true;
            }
            catch (Exception ex) {
                if (this.ignoreError) break block4;
                throw new MetricsException("Failed to create " + this.basePath + "[source=" + this.source + ", allow-append=" + this.allowAppend + ", " + this.stringifySecurityProperty(KEYTAB_PROPERTY_KEY) + ", " + this.stringifySecurityProperty(USERNAME_PROPERTY_KEY) + "] -- " + ex.toString(), ex);
            }
        }
        if (success) {
            if (this.allowAppend) {
                this.allowAppend = this.checkAppend(this.fileSystem);
            }
            this.flushTimer = new Timer("RollingFileSystemSink Flusher", true);
            this.setInitialFlushTime(new Date());
        }
        return success;
    }

    private String stringifySecurityProperty(String property) {
        String securityProperty;
        if (this.properties.containsKey(property)) {
            String propertyValue = this.properties.getString(property);
            String confValue = this.conf.get(this.properties.getString(property));
            securityProperty = confValue != null ? property + "=" + propertyValue + ", " + this.properties.getString(property) + "=" + confValue : property + "=" + propertyValue + ", " + this.properties.getString(property) + "=<NOT SET>";
        } else {
            securityProperty = property + "=<NOT SET>";
        }
        return securityProperty;
    }

    @VisibleForTesting
    protected long getRollInterval() {
        long millis;
        String rollInterval = this.properties.getString(ROLL_INTERVAL_KEY, DEFAULT_ROLL_INTERVAL);
        Pattern pattern = Pattern.compile("^\\s*(\\d+)\\s*([A-Za-z]*)\\s*$");
        Matcher match = pattern.matcher(rollInterval);
        if (match.matches()) {
            int rollIntervalInt;
            String flushUnit = match.group(2);
            try {
                rollIntervalInt = Integer.parseInt(match.group(1));
            }
            catch (NumberFormatException ex) {
                throw new MetricsException("Unrecognized flush interval: " + rollInterval + ". Must be a number followed by an optional unit. The unit must be one of: minute, hour, day", ex);
            }
            if ("".equals(flushUnit)) {
                millis = TimeUnit.HOURS.toMillis(rollIntervalInt);
            } else {
                switch (flushUnit.toLowerCase()) {
                    case "m": 
                    case "min": 
                    case "minute": 
                    case "minutes": {
                        millis = TimeUnit.MINUTES.toMillis(rollIntervalInt);
                        break;
                    }
                    case "h": 
                    case "hr": 
                    case "hour": 
                    case "hours": {
                        millis = TimeUnit.HOURS.toMillis(rollIntervalInt);
                        break;
                    }
                    case "d": 
                    case "day": 
                    case "days": {
                        millis = TimeUnit.DAYS.toMillis(rollIntervalInt);
                        break;
                    }
                    default: {
                        throw new MetricsException("Unrecognized unit for flush interval: " + flushUnit + ". Must be one of: minute, hour, day");
                    }
                }
            }
        } else {
            throw new MetricsException("Unrecognized flush interval: " + rollInterval + ". Must be a number followed by an optional unit. The unit must be one of: minute, hour, day");
        }
        if (millis < 60000L) {
            throw new MetricsException("The flush interval property must be at least 1 minute. Value was " + rollInterval);
        }
        return millis;
    }

    private long getNonNegative(String key, int defaultValue) {
        int flushOffsetIntervalMillis = this.properties.getInt(key, defaultValue);
        if (flushOffsetIntervalMillis < 0) {
            throw new MetricsException("The " + key + " property must be non-negative. Value was " + flushOffsetIntervalMillis);
        }
        return flushOffsetIntervalMillis;
    }

    private void checkIfPropertyExists(String key) {
        if (!this.properties.containsKey(key)) {
            throw new MetricsException("Metrics2 configuration is missing " + key + " property");
        }
    }

    private Configuration loadConf() {
        Configuration c = suppliedConf != null ? suppliedConf : new Configuration();
        return c;
    }

    private FileSystem getFileSystem() throws MetricsException {
        FileSystem fs = null;
        if (suppliedFilesystem != null) {
            fs = suppliedFilesystem;
        } else {
            try {
                fs = FileSystem.get(new URI(this.basePath.toString()), this.conf);
            }
            catch (URISyntaxException ex) {
                throw new MetricsException("The supplied filesystem base path URI is not a valid URI: " + this.basePath.toString(), ex);
            }
            catch (IOException ex) {
                throw new MetricsException("Error connecting to file system: " + this.basePath + " [" + ex.toString() + "]", ex);
            }
        }
        return fs;
    }

    private boolean checkAppend(FileSystem fs) {
        boolean canAppend = true;
        try {
            fs.append(this.basePath);
        }
        catch (UnsupportedOperationException ex) {
            canAppend = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canAppend;
    }

    private void rollLogDirIfNeeded() throws MetricsException {
        Date now = new Date();
        if (this.currentOutStream == null || now.after(this.nextFlush.getTime())) {
            if (!this.initialized) {
                this.initialized = this.initFs();
            }
            if (this.initialized) {
                if (this.currentOutStream != null) {
                    this.currentOutStream.close();
                }
                this.currentDirPath = this.findCurrentDirectory(now);
                try {
                    this.rollLogDir();
                }
                catch (IOException ex) {
                    this.throwMetricsException("Failed to create new log file", ex);
                }
                this.updateFlushTime(now);
                this.scheduleFlush(this.nextFlush.getTime());
            }
        } else if (forceFlush) {
            this.scheduleFlush(new Date());
        }
    }

    private Path findCurrentDirectory(Date now) {
        long offset = (now.getTime() - this.nextFlush.getTimeInMillis()) / this.rollIntervalMillis * this.rollIntervalMillis;
        String currentDir = DATE_FORMAT.format(new Date(this.nextFlush.getTimeInMillis() + offset));
        return new Path(this.basePath, currentDir);
    }

    private void scheduleFlush(Date when) {
        final PrintStream toClose = this.currentOutStream;
        this.flushTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RollingFileSystemSink.this.lock;
                synchronized (object) {
                    toClose.close();
                }
                hasFlushed = true;
            }
        }, when);
    }

    @VisibleForTesting
    protected void updateFlushTime(Date now) {
        int millis = (int)(((now.getTime() - this.nextFlush.getTimeInMillis()) / this.rollIntervalMillis + 1L) * this.rollIntervalMillis);
        this.nextFlush.add(14, millis);
    }

    @VisibleForTesting
    protected void setInitialFlushTime(Date now) {
        this.nextFlush = Calendar.getInstance();
        this.nextFlush.setTime(now);
        this.nextFlush.set(14, 0);
        this.nextFlush.set(13, 0);
        this.nextFlush.set(12, 0);
        int millis = (int)((now.getTime() - this.nextFlush.getTimeInMillis()) / this.rollIntervalMillis * this.rollIntervalMillis);
        if (this.rollOffsetIntervalMillis > 0L) {
            millis = (int)((long)millis + ThreadLocalRandom.current().nextLong(this.rollOffsetIntervalMillis));
            while (this.nextFlush.getTimeInMillis() + (long)millis > now.getTime()) {
                millis = (int)((long)millis - this.rollIntervalMillis);
            }
        }
        this.nextFlush.add(14, millis);
    }

    private void rollLogDir() throws IOException {
        String fileName = this.source + "-" + InetAddress.getLocalHost().getHostName() + ".log";
        Path targetFile = new Path(this.currentDirPath, fileName);
        this.fileSystem.mkdirs(this.currentDirPath);
        if (this.allowAppend) {
            this.createOrAppendLogFile(targetFile);
        } else {
            this.createLogFile(targetFile);
        }
    }

    private void createLogFile(Path initial) throws IOException {
        Path currentAttempt = initial;
        int id = 0;
        while (true) {
            try {
                this.currentFSOutStream = this.fileSystem.create(currentAttempt, false);
                this.currentOutStream = new PrintStream((OutputStream)this.currentFSOutStream, true, StandardCharsets.UTF_8.name());
                this.currentFilePath = currentAttempt;
            }
            catch (IOException ex) {
                if (this.fileSystem.exists(currentAttempt)) {
                    id = this.getNextIdToTry(initial, id);
                    currentAttempt = new Path(initial.toString() + "." + id);
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    private int getNextIdToTry(Path initial, int lastId) throws IOException {
        RemoteIterator<LocatedFileStatus> files = this.fileSystem.listFiles(this.currentDirPath, true);
        String base = initial.toString();
        int id = lastId;
        while (files.hasNext()) {
            int fileId;
            String file = files.next().getPath().getName();
            if (!file.startsWith(base) || (fileId = this.extractId(file)) <= id) continue;
            id = fileId;
        }
        return id + 1;
    }

    private int extractId(String file) {
        int index = file.lastIndexOf(".");
        int id = -1;
        if (index > 0) {
            try {
                id = Integer.parseInt(file.substring(index + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return id;
    }

    private void createOrAppendLogFile(Path targetFile) throws IOException {
        try {
            this.currentFSOutStream = this.fileSystem.create(targetFile, false);
            this.currentOutStream = new PrintStream((OutputStream)this.currentFSOutStream, true, StandardCharsets.UTF_8.name());
        }
        catch (IOException ex) {
            try {
                this.currentFSOutStream = this.fileSystem.append(targetFile);
                this.currentOutStream = new PrintStream((OutputStream)this.currentFSOutStream, true, StandardCharsets.UTF_8.name());
            }
            catch (IOException ex2) {
                ex2.initCause(ex);
                throw ex2;
            }
        }
        this.currentFilePath = targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMetrics(MetricsRecord record) {
        Object object = this.lock;
        synchronized (object) {
            this.rollLogDirIfNeeded();
            if (this.currentOutStream != null) {
                this.currentOutStream.printf("%d %s.%s", record.timestamp(), record.context(), record.name());
                String separator = ": ";
                for (MetricsTag tag : record.tags()) {
                    this.currentOutStream.printf("%s%s=%s", separator, tag.name(), tag.value());
                    separator = ", ";
                }
                for (AbstractMetric metric : record.metrics()) {
                    this.currentOutStream.printf("%s%s=%s", separator, metric.name(), metric.value());
                }
                this.currentOutStream.println();
                try {
                    this.currentFSOutStream.hflush();
                }
                catch (IOException ex) {
                    this.throwMetricsException("Failed flushing the stream", ex);
                }
                this.checkForErrors("Unable to write to log file");
            } else if (!this.ignoreError) {
                this.throwMetricsException("Unable to write to log file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentFSOutStream != null) {
                try {
                    this.currentFSOutStream.hflush();
                }
                catch (IOException ex) {
                    this.throwMetricsException("Unable to flush log file", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentOutStream != null) {
                this.currentOutStream.close();
                try {
                    this.checkForErrors("Unable to close log file");
                }
                finally {
                    this.currentOutStream = null;
                    this.currentFSOutStream = null;
                }
            }
        }
    }

    private void checkForErrors(String message) throws MetricsException {
        if (!this.ignoreError && this.currentOutStream.checkError()) {
            throw new MetricsException(message + ": " + this.currentFilePath);
        }
    }

    private void throwMetricsException(String message, Throwable t) {
        if (!this.ignoreError) {
            throw new MetricsException(message + ": " + this.currentFilePath + " [" + t.toString() + "]", t);
        }
    }

    private void throwMetricsException(String message) {
        if (!this.ignoreError) {
            throw new MetricsException(message + ": " + this.currentFilePath);
        }
    }
}

