/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.hash;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.hash.Hash;
import org.apache.hadoop.util.hash.JenkinsHash;
import org.apache.hadoop.util.hash.MurmurHash;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHash {
    static final String LINE = "34563@45kjkksdf/ljfdb9d8fbusd*89uggjsk<dfgjsdfh@sddc2q3esc";

    @Test
    public void testHash() {
        int i;
        int i2;
        int iterations = 30;
        Assertions.assertTrue((0 == Hash.parseHashType((String)"jenkins") ? 1 : 0) != 0, (String)"testHash jenkins error !!!");
        Assertions.assertTrue((1 == Hash.parseHashType((String)"murmur") ? 1 : 0) != 0, (String)"testHash murmur error !!!");
        Assertions.assertTrue((-1 == Hash.parseHashType((String)"undefined") ? 1 : 0) != 0, (String)"testHash undefined");
        Configuration cfg = new Configuration();
        cfg.set("hadoop.util.hash.type", "murmur");
        Assertions.assertTrue((MurmurHash.getInstance() == Hash.getInstance((Configuration)cfg) ? 1 : 0) != 0, (String)"testHash");
        cfg = new Configuration();
        cfg.set("hadoop.util.hash.type", "jenkins");
        Assertions.assertTrue((JenkinsHash.getInstance() == Hash.getInstance((Configuration)cfg) ? 1 : 0) != 0, (String)"testHash jenkins configuration error !!!");
        cfg = new Configuration();
        Assertions.assertTrue((MurmurHash.getInstance() == Hash.getInstance((Configuration)cfg) ? 1 : 0) != 0, (String)"testHash undefine configuration error !!!");
        Assertions.assertTrue((JenkinsHash.getInstance() == Hash.getInstance((int)0) ? 1 : 0) != 0, (String)"testHash error jenkin getInstance !!!");
        Assertions.assertTrue((MurmurHash.getInstance() == Hash.getInstance((int)1) ? 1 : 0) != 0, (String)"testHash error murmur getInstance !!!");
        Assertions.assertNull((Object)Hash.getInstance((int)-1), (String)"testHash error invalid getInstance !!!");
        int murmurHash = Hash.getInstance((int)1).hash(LINE.getBytes());
        for (i2 = 0; i2 < iterations; ++i2) {
            Assertions.assertTrue((murmurHash == Hash.getInstance((int)1).hash(LINE.getBytes()) ? 1 : 0) != 0, (String)"multiple evaluation murmur hash error !!!");
        }
        murmurHash = Hash.getInstance((int)1).hash(LINE.getBytes(), 67);
        for (i2 = 0; i2 < iterations; ++i2) {
            Assertions.assertTrue((murmurHash == Hash.getInstance((int)1).hash(LINE.getBytes(), 67) ? 1 : 0) != 0, (String)"multiple evaluation murmur hash error !!!");
        }
        int jenkinsHash = Hash.getInstance((int)0).hash(LINE.getBytes());
        for (i = 0; i < iterations; ++i) {
            Assertions.assertTrue((jenkinsHash == Hash.getInstance((int)0).hash(LINE.getBytes()) ? 1 : 0) != 0, (String)"multiple evaluation jenkins hash error !!!");
        }
        jenkinsHash = Hash.getInstance((int)0).hash(LINE.getBytes(), 67);
        for (i = 0; i < iterations; ++i) {
            Assertions.assertTrue((jenkinsHash == Hash.getInstance((int)0).hash(LINE.getBytes(), 67) ? 1 : 0) != 0, (String)"multiple evaluation jenkins hash error !!!");
        }
    }
}

